package com.yx.tcbj.center.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.dto.request.ItemAuthBatchReqDto;
import com.yx.tcbj.center.api.dto.request.ItemAuthExtQueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 供应商和产品的供货价格服务接口
 *
 * @author jianshi
 * @since 2021-11-11
 */
@Api(tags = {"商品中心:商品授权扩展相关"})
@FeignClient(
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/itemAuthExpand",
        url = "${yundt.cube.center.item.api:}"
)
public interface IItemAuthExpandQueryApi {


    @PostMapping("/queryItemAuthExtPage")
    @ApiOperation(value = "查询客户商品授权分页接口", notes = "查询客户商品授权分页接口")
    RestResponse<PageInfo<ItemAuthQueryRespDto>> queryItemAuthExtPage(@RequestBody ItemAuthExtQueryReqDto itemAuthQueryReqDto);

    @PostMapping("/queryShellItemList")
    @ApiOperation(value = "查询组织下的授权商品接口", notes = "查询组织下的授权商品接口")
    RestResponse<List<ItemAuthQueryRespDto>> queryShellItemList(@RequestBody ItemAuthExtQueryReqDto itemAuthQueryReqDto);
}
