package com.yx.tcbj.center.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel(value = "ItemAuthExtractCodeReqDto", description = "店铺商品的外部系统编码查询请求DTO对象")
public class ItemAuthExtractCodeReqDto extends BaseVo {
    @ApiModelProperty(name = "itemIds", value = "商品Ids")
    private List<Long> itemIds;

    @ApiModelProperty(name = "itemId", value = "商品Id")
    private Long itemId;

    @ApiModelProperty(name = "targetId", value = "店铺id，对应到授权表的tragetId")
    private Long targetId;

    /**
     *  商品授权表it_item_auth的external_code字段。
     */
    @ApiModelProperty(name = "externalCode", value = "商品外部系统编码")
    private String externalCode;
}
