package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.ItemExtendReqDto;
import com.yx.tcbj.center.api.dto.request.ItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import java.util.List;

/**
* 商品扩展参数表服务接口
*
* @author yuangui
* @since 2022-05-11
*/
@Api(tags = {"商品扩展参数表服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-IItemExtendApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/itemExtend",
    url = "${yundt.cube.center.item.api:}"
)
public interface IItemExtendApi {

/**
* 新增商品扩展参数表
*
* @param addReqDto 商品扩展参数表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增商品扩展参数表", notes = "新增商品扩展参数表")
RestResponse<Long> addItemExtend(@RequestBody ItemExtendReqDto addReqDto);

    /**
    * 修改商品扩展参数表
    *
    * @param modifyReqDto 商品扩展参数表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改商品扩展参数表", notes = "修改商品扩展参数表")
    RestResponse<Void> modifyItemExtend(@RequestBody ItemExtendReqDto modifyReqDto);

    @PutMapping("/modifyPrice")
    @ApiOperation(value = "修改商品推荐价格", notes = "修改商品推荐价格")
    RestResponse<Void> modifyPrice(@RequestBody ItemExtendReqDto modifyReqDto);

    /**
    * 删除商品扩展参数表
    *
    * @param ids        商品扩展参数表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除商品扩展参数表", notes = "删除商品扩展参数表")
    RestResponse<Void> removeItemExtend(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);

    @PostMapping("/refreshIndex")
    RestResponse<Void> refreshIndex(@RequestBody List<Long> ids);

    /**
     * 更新基础商品数据
     *
     * @param itemDto 商品请求对象
     * @return 处理结果
     */
    @PostMapping("/updateSimpleItem")
    @ApiOperation(value = "更新基础商品数据", notes = "更新基础商品数据")
    RestResponse<Void> updateSimpleItem(@RequestBody ItemReqDto itemDto);

   }
