package com.yx.tcbj.center.api.query;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.PcpPhysicalTrayReqDto;
import com.yx.tcbj.center.api.dto.response.PcpPhysicalTrayRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* PCP物料仓库托盘数列表服务接口
*
* @author yuangui
* @since 2022-05-23
*/
@Api(tags = {"PCP物料仓库托盘数列表服务"})
@FeignClient(
    contextId = "com-yx-tcbj-center-api-query-IPcpPhysicalTrayQueryApi",
    name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
    path = "/v1/pcpPhysicalTray",
    url = "${yundt.cube.center.item.api:}"
)
public interface IPcpPhysicalTrayQueryApi {

    /**
    * 根据id查询PCP物料仓库托盘数列表
    *
    * @param id PCP物料仓库托盘数列表id
    * @return   PCP物料仓库托盘数列表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询PCP物料仓库托盘数列表", notes = "根据id查询PCP物料仓库托盘数列表")
    RestResponse<PcpPhysicalTrayRespDto> queryById(@PathVariable("id") Long id);

    /**
     * PCP物料仓库托盘数列表分页数据
     * @param reqDto
     * @return PCP物料仓库托盘数列表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "PCP物料仓库托盘数列表分页数据", notes = "根据filter查询条件查询PCP物料仓库托盘数列表数据，filter=PcpPhysicalTrayReqDto")
    RestResponse<PageInfo<PcpPhysicalTrayRespDto>> queryByPage(@RequestBody PcpPhysicalTrayReqDto reqDto);

}
