/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.PropGroupUsageTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropGroupReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropGroupRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropNameRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirPropRelationService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropGroupDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropGroupRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropNameDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropValueDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropGroupEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropNameEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdPropGroupRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdPropValueEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirPropRelationServiceImpl
implements IDirPropRelationService {
    @Resource
    private DirDas dirDas;
    @Resource
    private DirPropRelationDas dirPropRelationDas;
    @Resource
    private PropGroupRelationDas propGroupRelationDas;
    @Resource
    private PropGroupDas propGroupDas;
    @Resource
    private PropNameDas propNameDas;
    @Resource
    private PropValueDas propValueDas;

    @Override
    public List<PropGroupRespDto> queryPropGroupByDirId(Long dirId, Integer usage) {
        ArrayList propGroupRespDtoList = Lists.newArrayList();
        List dirPropRelationEos = this.dirPropRelationDas.selectByDirId(dirId, Integer.valueOf(1), usage);
        if (CollectionUtils.isNotEmpty((Collection)dirPropRelationEos)) {
            List propGroupEoList = this.propGroupDas.selectByIdList(dirPropRelationEos.stream().map(StdDirPropRelationEo::getPropGroupId).collect(Collectors.toList()));
            Map<Object, Object> propGroupEoMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)propGroupEoList)) {
                propGroupEoMap = propGroupEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            }
            HashMap finalPropGroupEoMap = propGroupEoMap;
            dirPropRelationEos.forEach(dirPropRelationEo -> {
                PropGroupRespDto propGroupRespDto = new PropGroupRespDto();
                Long propGroupId = dirPropRelationEo.getPropGroupId();
                PropGroupEo propGroupEo = (PropGroupEo)finalPropGroupEoMap.get(propGroupId);
                if (propGroupEo != null) {
                    DtoHelper.eo2Dto((BaseEo)propGroupEo, (BaseVo)propGroupRespDto);
                    propGroupRespDto.setPropGroupUsageType(dirPropRelationEo.getPropGroupUsageType());
                    List propGroupRelationEoList = this.propGroupRelationDas.selectByPropGroupId(propGroupId);
                    if (CollectionUtils.isNotEmpty((Collection)propGroupRelationEoList)) {
                        List propNameEoList = this.propNameDas.selectByIdList(propGroupRelationEoList.stream().map(StdPropGroupRelationEo::getPropNameId).collect(Collectors.toList()));
                        Map<Object, Object> propNameEoMap = Maps.newHashMap();
                        if (CollectionUtils.isNotEmpty((Collection)propNameEoList)) {
                            propNameEoMap = propNameEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                        }
                        HashMap finalPropNameEoMap = propNameEoMap;
                        List propNameRespDtos = propGroupRelationEoList.stream().map(propGroupRelationEo -> {
                            PropNameRespDto propNameRespDto = new PropNameRespDto();
                            PropNameEo propNameEo = (PropNameEo)finalPropNameEoMap.get(propGroupRelationEo.getPropNameId());
                            DtoHelper.eo2Dto((BaseEo)propNameEo, (BaseVo)propNameRespDto);
                            List propValueEoList = this.propValueDas.selectByPropNameId(propNameEo.getId());
                            if (CollectionUtils.isNotEmpty((Collection)propGroupEoList)) {
                                propNameRespDto.setPropValueList(propValueEoList.stream().map(StdPropValueEo::getName).collect(Collectors.toList()));
                            }
                            return propNameRespDto;
                        }).collect(Collectors.toList());
                        propGroupRespDto.setPropNameRespDtos(propNameRespDtos);
                    }
                    propGroupRespDtoList.add(propGroupRespDto);
                }
            });
        }
        return propGroupRespDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDirPropGroup(Long dirId, List<PropGroupReqDto> propGroupReqDtos) {
        DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirId);
        if (dirEo == null) {
            throw new BizException("\u7c7b\u76ee\u4e0d\u5b58\u5728");
        }
        List<Object> propGroupIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(propGroupReqDtos) && CollectionUtils.isNotEmpty((Collection)(propGroupIds = propGroupReqDtos.stream().map(PropGroupReqDto::getId).filter(Objects::nonNull).collect(Collectors.toList())))) {
            propGroupIds.forEach(propGroupId -> {
                PropGroupEo propGroupEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(propGroupId);
                if (propGroupEo == null) {
                    throw new BizException(String.format("\u5c5e\u6027\u7ec4[id:%s]\u4e0d\u5b58\u5728", propGroupId));
                }
            });
        }
        this.dirPropRelationDas.deleteByDirId(dirId, Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)propGroupIds)) {
            List dirPropRelationEoList = propGroupReqDtos.stream().map(propGroupReqDto -> {
                DirPropRelationEo dirPropRelationEo = new DirPropRelationEo();
                dirPropRelationEo.setDirId(dirId);
                dirPropRelationEo.setPropType(Integer.valueOf(1));
                dirPropRelationEo.setPropGroupUsageType(Integer.valueOf(propGroupReqDto.getPropGroupUsageType() == null ? PropGroupUsageTypeEnum.base.getCode() : propGroupReqDto.getPropGroupUsageType().intValue()));
                dirPropRelationEo.setPropGroupId(propGroupReqDto.getId());
                dirPropRelationEo.setTenantId(dirEo.getTenantId());
                dirPropRelationEo.setInstanceId(dirEo.getInstanceId());
                return dirPropRelationEo;
            }).collect(Collectors.toList());
            this.dirPropRelationDas.insertBatch(dirPropRelationEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addDirPropGroup(Long dirId, Set<Long> propGroupIds) {
        DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirId);
        if (dirEo == null) {
            throw new BizException("\u7c7b\u76ee\u4e0d\u5b58\u5728");
        }
        propGroupIds.forEach(propGroupId -> {
            PropGroupEo propGroupEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(propGroupId);
            if (propGroupEo == null) {
                throw new BizException("\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
            }
        });
        List dirPropRelationEoList = propGroupIds.stream().map(propGroupId -> {
            DirPropRelationEo dirPropRelationEo = new DirPropRelationEo();
            dirPropRelationEo.setDirId(dirId);
            dirPropRelationEo.setPropType(Integer.valueOf(1));
            dirPropRelationEo.setPropGroupUsageType(Integer.valueOf(PropGroupUsageTypeEnum.base.getCode()));
            dirPropRelationEo.setPropGroupId(propGroupId);
            dirPropRelationEo.setTenantId(dirEo.getTenantId());
            dirPropRelationEo.setInstanceId(dirEo.getInstanceId());
            return dirPropRelationEo;
        }).collect(Collectors.toList());
        this.dirPropRelationDas.insertBatch(dirPropRelationEoList);
    }

    @Override
    public void updateDirPropGroupUsage(Long dirId, Long propGroupId, Integer usage) {
        DirPropRelationEo dirPropRelationEo = this.dirPropRelationDas.selectOneByParam(dirId, propGroupId);
        if (dirPropRelationEo == null) {
            throw new BizException("\u7c7b\u76ee\u4e0b\u4e0d\u5b58\u5728\u8be5\u5c5e\u6027\u7ec4");
        }
        dirPropRelationEo.setPropGroupUsageType(Integer.valueOf(usage != null ? usage.intValue() : PropGroupUsageTypeEnum.base.getCode()));
        this.dirPropRelationDas.updateSelective((BaseEo)dirPropRelationEo);
    }

    @Override
    public void removeDirPropGroup(Long dirId, Set<Long> propGroupIds) {
        propGroupIds.forEach(propGroupId -> {
            DirPropRelationEo dirPropRelationEo = this.dirPropRelationDas.selectOneByParam(dirId, propGroupId);
            if (dirPropRelationEo != null) {
                this.dirPropRelationDas.deleteById(dirPropRelationEo.getId());
            }
        });
    }

    @Override
    public void updateDirPropGroupSort(Long dirId, Long propGroupId, String action) {
    }

    @Override
    public void copyDirPropGroup(Long sourceDirId, Long targetDirId) {
        List sourceDirPropRelationEoList = this.dirPropRelationDas.selectByDirId(sourceDirId, Integer.valueOf(1), null);
        if (CollectionUtils.isNotEmpty((Collection)sourceDirPropRelationEoList)) {
            List dirPropRelationEoList = this.dirPropRelationDas.selectByDirId(targetDirId, Integer.valueOf(1), null);
            List<Object> propGroupIdList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)dirPropRelationEoList)) {
                propGroupIdList = dirPropRelationEoList.stream().map(StdDirPropRelationEo::getPropGroupId).distinct().collect(Collectors.toList());
            }
            ArrayList targetDirPropRelationEoList = Lists.newArrayList();
            ArrayList finalPropGroupIdList = propGroupIdList;
            sourceDirPropRelationEoList.forEach(sourceDirPropRelationEo -> {
                if (!finalPropGroupIdList.contains(sourceDirPropRelationEo.getPropGroupId())) {
                    DirPropRelationEo targetDirPropRelationEo = new DirPropRelationEo();
                    targetDirPropRelationEo.setDirId(targetDirId);
                    targetDirPropRelationEo.setPropType(Integer.valueOf(1));
                    targetDirPropRelationEo.setPropGroupUsageType(sourceDirPropRelationEo.getPropGroupUsageType());
                    targetDirPropRelationEo.setPropGroupId(sourceDirPropRelationEo.getPropGroupId());
                    targetDirPropRelationEo.setSellerId(sourceDirPropRelationEo.getSellerId());
                    targetDirPropRelationEo.setInstanceId(sourceDirPropRelationEo.getInstanceId());
                    targetDirPropRelationEo.setTenantId(sourceDirPropRelationEo.getTenantId());
                    targetDirPropRelationEoList.add(targetDirPropRelationEo);
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)targetDirPropRelationEoList)) {
                this.dirPropRelationDas.insertBatch((List)targetDirPropRelationEoList);
            }
        }
    }
}

