/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.constants.OptStatus;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemPriceService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="itemPriceService")
public class ItemPriceServiceImpl
implements IItemPriceService {
    private static Logger logger = LoggerFactory.getLogger(ItemPriceServiceImpl.class);
    @Resource
    private ItemPriceDas itemPriceDas;

    @Override
    public Long addItemPrice(ItemPriceEo itemPriceEo) {
        itemPriceEo.setIsActived(OptStatus.DISABLED.getStatus());
        this.itemPriceDas.insert((BaseEo)itemPriceEo);
        return itemPriceEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchItemPrice(List<ItemPriceEo> itemPriceEoList) {
        if (CollectionUtils.isEmpty(itemPriceEoList)) {
            logger.error("\u5546\u54c1\u4ef7\u683c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ItemBusinessRuntimeException("\u5546\u54c1\u4ef7\u683c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.itemPriceDas.insertBatch(itemPriceEoList);
    }

    @Override
    public List<ItemPriceEo> queryItemPriceById(Long itemId) {
        ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
        itemPriceEo.setItemId(itemId);
        return this.itemPriceDas.select((BaseEo)itemPriceEo);
    }

    @Override
    public List<ItemPriceEo> queryItemPrice(ItemPriceEo eo) {
        return this.itemPriceDas.select((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteItemPrice(ItemPriceEo itemPriceEo) {
        this.itemPriceDas.deleteByExample((BaseEo)itemPriceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBatchItemPrice(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"sku_id", (Object)StringUtils.join(skuIds, (String)",")));
        ItemPriceEo itemPriceEo = ItemPriceEo.newInstance();
        itemPriceEo.setSqlFilters(sqlFilters);
        this.itemPriceDas.delete((BaseEo)itemPriceEo);
    }
}

