/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemAttributesRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemAttributesRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class DirItemAttributesServiceImpl
implements IDirItemAttributesService {
    @Resource
    private DirItemAttributesRelationDas dirItemAttributesDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSearchAttrsAttributes(Long dirId, List<ItemAttributesEo> attributesList) {
        List<DirItemAttributesRelationEo> itemAttributesEos = this.transToItemAttributesList(attributesList);
        ArrayList<DirItemAttributesRelationEo> insertItemAttributes = new ArrayList<DirItemAttributesRelationEo>();
        for (DirItemAttributesRelationEo dirItemAttributesEo : itemAttributesEos) {
            dirItemAttributesEo.setDirId(dirId);
            List itemAttributes = this.dirItemAttributesDas.select((BaseEo)dirItemAttributesEo);
            if (itemAttributes != null && itemAttributes.size() > 0) continue;
            insertItemAttributes.add(dirItemAttributesEo);
        }
        if (CollectionUtils.isNotEmpty(insertItemAttributes = DirItemAttributesServiceImpl.removeDirItemAttributes(insertItemAttributes))) {
            this.dirItemAttributesDas.insertBatch(insertItemAttributes);
        }
    }

    private List<DirItemAttributesRelationEo> transToItemAttributesList(List<ItemAttributesEo> attributesList) {
        ArrayList<DirItemAttributesRelationEo> resultAttributes = new ArrayList<DirItemAttributesRelationEo>();
        for (ItemAttributesEo itemAttributesEo : attributesList) {
            String searchAttrs = itemAttributesEo.getSearchAttrs();
            if (StringUtils.isEmpty((Object)searchAttrs)) continue;
            Map map = (Map)JSON.parseObject((String)searchAttrs, Map.class);
            Set entrys = map.entrySet();
            for (Map.Entry entry : entrys) {
                DirItemAttributesRelationEo dirItemAttributesEo = DirItemAttributesRelationEo.newInstance();
                dirItemAttributesEo.setPropName((String)entry.getKey());
                dirItemAttributesEo.setPropValue((String)entry.getValue());
                resultAttributes.add(dirItemAttributesEo);
            }
        }
        return resultAttributes;
    }

    private static ArrayList<DirItemAttributesRelationEo> removeDirItemAttributes(List<DirItemAttributesRelationEo> attrList) {
        TreeSet<DirItemAttributesRelationEo> s = new TreeSet<DirItemAttributesRelationEo>((o1, o2) -> {
            String uniqueString1 = o1.getPropName() + ":" + o1.getPropValue() + ":" + o1.getDirId();
            String uniqueString2 = o2.getPropName() + ":" + o2.getPropValue() + ":" + o2.getDirId();
            return uniqueString1.compareTo(uniqueString2);
        });
        s.addAll(attrList);
        return new ArrayList<DirItemAttributesRelationEo>(s);
    }
}

