/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StorageChangeLogStatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StorageChangeLogTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageInfoReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReturnReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageSubReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BatchItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemStorageDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemConstant;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemType;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.StorageChangeLogMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.impl.ItemStorageServiceImpl;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ItemStorageUtils;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.RedisLockUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StorageChangeLogDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.RItemBundleDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.RItemBundleEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StorageChangeLogEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service
public class ItemStorageServiceImplExt
extends ItemStorageServiceImpl {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Resource
    private IContext context;
    @Resource
    private ItemStorageUtils itemStorageUtils;
    @Resource
    private StorageChangeLogDas storageChangeLogDas;
    @Resource
    private RedisLockUtils redisLockUtils;
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;
    private String todo = "todo";
    @Resource
    private ItemDas itemDas;
    @Resource(name="${project.domain.prefix:tcbj}ShelfService")
    private IShelfService shelfService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ILockService lockService;
    @Resource
    private RItemBundleDas rItemBundleDas;
    @Resource
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long operatingItemStorage(ItemStorageReqDto itemStorageReqDto) {
        return this.operatingItemStorageNoValidSelf(itemStorageReqDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long operatingItemStorageNoValidSelf(ItemStorageReqDto itemStorageReqDto) {
        this.logger.info("\u6263\u51cf\u5e93\u5b58\u53c2\u6570{}", JSON.toJSON((Object)itemStorageReqDto));
        if (itemStorageReqDto == null || itemStorageReqDto.getSkuId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        if (itemStorageReqDto.getBalance() == null || itemStorageReqDto.getBalance().equals(0L)) {
            return null;
        }
        ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"id", (Object)itemStorageReqDto.getSkuId())).one();
        if (null == itemSkuEo) {
            throw new BizException("sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)itemSkuEo.getItemId())).one();
        Mutex mutex = null;
        ItemStorageEo itemStorageEo = new ItemStorageEo();
        try {
            ItemEo it;
            mutex = this.lockService.lock("ITEM_INVENTORY", itemStorageReqDto.getSkuId());
            if (null == mutex) {
                throw new BizException("\u5e93\u5b58\u53d8\u52a8\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().eq((Object)"shop_id", (Object)itemStorageReqDto.getShopId())).eq((Object)"item_id", (Object)itemEo.getId())).eq((Object)"sku_id", (Object)itemStorageReqDto.getSkuId())).orderByDesc((Object)"update_time")).list();
            if (CollectionUtils.isEmpty((Collection)itemStorageEos)) {
                throw new BizException("\u5e93\u5b58\u4e0d\u8db3");
            }
            itemStorageEo = (ItemStorageEo)itemStorageEos.get(0);
            Long stock = itemStorageEo.getBalance() + Long.valueOf(itemStorageReqDto.getBalance());
            itemStorageEo.setBalance(stock);
            itemStorageEo.setInventoryEffectiveDate(new Date());
            this.itemStorageDas.updateSelective((BaseEo)itemStorageEo);
            itemSkuEo.setInventoryQuantity(stock);
            this.itemSkuDas.updateSelective((BaseEo)itemSkuEo);
            if (null != itemStorageReqDto.getComposeItemId() && null != (it = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)itemStorageReqDto.getComposeItemId())).one()) && ItemType.COMB_ITEM.getStatus() == it.getType()) {
                ItemEo eo = new ItemEo();
                eo.setId(it.getId());
                eo.setItemUse(ItemConstant.ITEM_USE);
                this.itemDas.updateSelective((BaseEo)eo);
            }
            StorageChangeLogEo changeLogEo = new StorageChangeLogEo();
            changeLogEo.setShelfId(Long.valueOf(0L));
            changeLogEo.setShopId(itemStorageReqDto.getShopId());
            changeLogEo.setItemId(itemSkuEo.getItemId());
            changeLogEo.setSkuId(itemSkuEo.getId());
            changeLogEo.setOrderNo(itemStorageReqDto.getOrderNo());
            if (StringUtils.isEmpty((CharSequence)changeLogEo.getOrderNo())) {
                changeLogEo.setOrderNo("ST" + IdGenrator.nextId((long)0L, (long)0L));
            }
            changeLogEo.setStatus(StorageChangeLogStatusEnum.CHANGE_BALANCE.getStatus());
            changeLogEo.setPreemptionTime(new Date());
            changeLogEo.setActivity(itemStorageReqDto.getActivity());
            itemStorageEo.setPresell(itemStorageReqDto.getPresell());
            changeLogEo.setInstanceId(this.context.instanceId());
            changeLogEo.setTenantId(this.context.tenantId());
            HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
            if (itemStorageReqDto.getInventoryEffectiveDate() != null) {
                map.put("inventory_effective_date", itemStorageReqDto.getInventoryEffectiveDate());
            }
            map.put("balance", itemStorageReqDto.getBalance());
            changeLogEo.setExtension(JSON.toJSONString(map));
            this.storageChangeLogDas.insert((BaseEo)changeLogEo);
        }
        catch (Exception e) {
            try {
                this.logger.error("\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
        }
        this.lockService.unlock(mutex);
        return itemStorageEo.getId();
    }

    @Override
    public BatchItemStorageRespDto batchOperatingItemStorage(BatchItemStorageReqDto batchItemStorageReqDto) {
        if (CollectionUtils.isEmpty((Collection)batchItemStorageReqDto.getItemStorageReqDtoList())) {
            throw new BizException("\u5546\u54c1\u64cd\u4f5c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BatchItemStorageReqDto.SUB.equals(batchItemStorageReqDto.getOpt())) {
            for (ItemStorageReqDto itemStorageReqDto : batchItemStorageReqDto.getItemStorageReqDtoList()) {
                if (itemStorageReqDto.getBalance() != null && itemStorageReqDto.getBalance() < 0L) continue;
                throw new BizException("\u4f20\u53c2\u6709\u8bef\uff0c\u6263\u51cf\u64cd\u4f5c\u4e0d\u80fd\u5927\u4e8e0\u6216\u8005\u4e3a\u7a7a");
            }
        } else if (BatchItemStorageReqDto.ADD.equals(batchItemStorageReqDto.getOpt())) {
            for (ItemStorageReqDto itemStorageReqDto : batchItemStorageReqDto.getItemStorageReqDtoList()) {
                if (itemStorageReqDto.getBalance() != null && itemStorageReqDto.getBalance() > 0L) continue;
                throw new BizException("\u4f20\u53c2\u6709\u8bef\uff0c\u589e\u52a0\u64cd\u4f5c\u4e0d\u80fd\u5c0f\u4e8e0");
            }
        } else {
            throw new BizException("\u53ea\u652f\u6301\u65b0\u589e\u548c\u6263\u51cf\u4e24\u79cd\u64cd\u4f5c");
        }
        BatchItemStorageRespDto batchItemStorageRespDto = new BatchItemStorageRespDto();
        for (ItemStorageReqDto itemStorageReqDto : batchItemStorageReqDto.getItemStorageReqDtoList()) {
            try {
                this.operatingItemStorage(itemStorageReqDto);
                ItemStorageRespDto itemStorageRespDto = new ItemStorageRespDto();
                BeanUtils.copyProperties((Object)itemStorageReqDto, (Object)itemStorageRespDto);
                batchItemStorageRespDto.getSuccessList().add(itemStorageRespDto);
            }
            catch (Exception e) {
                if (BatchItemStorageReqDto.SUB.equals(batchItemStorageReqDto.getOpt())) {
                    this.logger.info("\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u5e93\u5b58\u5931\u8d25{}", (Object)itemStorageReqDto.getOrderNo(), (Object)e);
                    if (!CollectionUtils.isNotEmpty((Collection)batchItemStorageRespDto.getSuccessList())) continue;
                    for (ItemStorageRespDto itemStorageRespDto : batchItemStorageRespDto.getSuccessList()) {
                        try {
                            ItemStorageReqDto rollBack = new ItemStorageReqDto();
                            BeanUtils.copyProperties((Object)itemStorageRespDto, (Object)rollBack);
                            rollBack.setBalance(Long.valueOf(-rollBack.getBalance().longValue()));
                            this.operatingItemStorage(rollBack);
                        }
                        catch (Exception rollBackEx) {
                            this.logger.error("\u3010\u865a\u62df\u5e93\u5b58\u56de\u6eda\u5931\u8d25:shopId={},skuId={},storage={}\u3011", new Object[]{itemStorageRespDto.getShopId(), itemStorageRespDto.getSkuId(), itemStorageRespDto.getBalance(), rollBackEx});
                            throw new BizException(ItemExtExceptionCode.VIR_STORAGE_ROLLBACK_FAIL.getCode(), rollBackEx.getMessage());
                        }
                    }
                    continue;
                }
                batchItemStorageRespDto.setIfAllSuccess(Boolean.valueOf(false));
                this.logger.error("\u8ba2\u5355\u53f7{}\u64cd\u4f5c\u589e\u52a0\u5e93\u5b58\u5931\u8d25{}\uff0c\u7ee7\u7eed\u589e\u52a0\u5e93\u5b58", (Object)itemStorageReqDto.getOrderNo(), (Object)e);
            }
        }
        if (batchItemStorageRespDto.getIfAllSuccess().booleanValue()) {
            batchItemStorageRespDto.setSuccessList(null);
        }
        this.cacheService.delCacheByPattern("item_storage_", "*");
        return batchItemStorageRespDto;
    }

    @Override
    public List<ItemStorageQueryRespDto> queryItemStorage(List<ItemStorageQueryReqDto> itemStorageQueryReqDtoList, Long instanceId, Long tenantId) {
        if (CollectionUtils.isEmpty(itemStorageQueryReqDtoList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemStorageQueryRespDto> itemStorageQueryRespDtoList = new ArrayList<ItemStorageQueryRespDto>();
        itemStorageQueryReqDtoList.forEach(itemStorageQueryReqDto -> {
            if (CollectionUtils.isEmpty((Collection)itemStorageQueryReqDto.getSkuIds())) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_QUERY_SKU);
            }
            Long shopId = itemStorageQueryReqDto.getShopId();
            itemStorageQueryReqDto.getSkuIds().forEach(skuId -> {
                ItemStorageQueryRespDto itemStorageQueryRespDto = new ItemStorageQueryRespDto();
                itemStorageQueryRespDto.setShopId(shopId);
                itemStorageQueryRespDto.setSkuId(skuId);
                ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"id", skuId)).one();
                if (null == itemSkuEo) {
                    itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
                } else {
                    ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)itemSkuEo.getItemId())).one();
                    if (null == itemEo) {
                        itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
                    } else {
                        itemStorageQueryRespDto.setItemId(itemEo.getId());
                        if (ItemTypeEnum.BUNDLE.getType() == itemEo.getType()) {
                            this.logger.info("\u5f53\u524d\u5546\u54c1\u7c7b\u578b\u4e3a\u7ec4\u5408\u5546\u54c1\uff0c\u5f00\u59cb\u67e5\u8be2\u865a\u62df\u5e93\u5b58...");
                            Long avaNum = this.getBundleSkuStorage(shopId, (Long)skuId, itemEo.getId());
                            itemStorageQueryRespDto.setAvaNum(avaNum);
                            this.logger.info("\u7ed3\u675f\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u865a\u62df\u5e93\u5b58\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)itemStorageQueryRespDto));
                        } else {
                            this.logger.info("\u5f53\u524d\u5546\u54c1\u7c7b\u578b\u4e3a\u975e\u7ec4\u5408\u5546\u54c1\uff0c\u5f00\u59cb\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5e93\u5b58...");
                            List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().eq((Object)"shop_id", (Object)shopId)).eq((Object)"item_id", (Object)itemEo.getId())).eq((Object)"sku_id", skuId)).orderByDesc((Object)"inventory_effective_date")).list();
                            this.logger.info("\u7ed3\u675f\u67e5\u8be2\u975e\u7ec4\u5408\u5546\u54c1\u865a\u62df\u5e93\u5b58\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)itemStorageEos));
                            ItemStorageEo itemStorageEo = new ItemStorageEo();
                            if (CollectionUtils.isNotEmpty((Collection)itemStorageEos)) {
                                itemStorageEo = (ItemStorageEo)itemStorageEos.get(0);
                                itemStorageQueryRespDto.setInventoryEffectiveDate(DateUtil.getDateFormat((Date)itemStorageEo.getInventoryEffectiveDate(), (String)"yyyy-MM-dd"));
                                itemStorageQueryRespDto.setAvaNum(Long.valueOf(itemStorageEo.getBalance() == null ? 0L : itemStorageEo.getBalance()));
                            } else {
                                itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
                            }
                        }
                    }
                }
                itemStorageQueryRespDtoList.add(itemStorageQueryRespDto);
            });
        });
        this.logger.info("\u865a\u62df\u5e93\u5b58\u6570\u636eitemStorageQueryRespDtoList\uff1a{}", (Object)JSON.toJSONString(itemStorageQueryRespDtoList));
        return itemStorageQueryRespDtoList;
    }

    private Long getBundleSkuStorage(Long shopId, Long skuId, Long itemId) {
        Long avaNum = 0L;
        this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u5e93\u5b58\uff1ashopId={}, skuId={}, itemId={}", new Object[]{shopId, skuId, itemId});
        List<RItemBundleEo> itemBundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", new Object[]{itemId})).list();
        itemBundleEos.forEach(v -> {
            List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().eq((Object)"shop_id", (Object)shopId)).eq((Object)"item_id", (Object)v.getSubItemId())).eq((Object)"sku_id", (Object)v.getSubSkuId())).orderByDesc((Object)"update_time")).list();
            ItemStorageEo itemStorageEo = new ItemStorageEo();
            if (CollectionUtils.isNotEmpty((Collection)itemStorageEos)) {
                itemStorageEo = (ItemStorageEo)itemStorageEos.get(0);
                Long num = itemStorageEo.getBalance() / (long)v.getNum().intValue();
                v.setNum(Integer.valueOf(num.intValue()));
            } else {
                v.setNum(Integer.valueOf(0));
            }
        });
        itemBundleEos = itemBundleEos.stream().sorted(Comparator.comparing(RItemBundleEo::getNum)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemBundleEos)) {
            RItemBundleEo itemBundleEo = (RItemBundleEo)itemBundleEos.get(0);
            avaNum = itemBundleEo.getNum() == null ? 0L : (long)itemBundleEo.getNum().intValue();
        }
        return avaNum;
    }

    @Transactional(rollbackFor={Exception.class})
    public void setVirStorage(ItemStorageEo itemStorageEo, Long shopId, Long itemId, Long skuId) {
        if (itemStorageEo.getId() != null && itemStorageEo.getId() > 0L) {
            itemStorageEo.setInventoryEffectiveDate(DateUtil.parseDate((String)DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"));
            this.itemStorageDas.updateSelective((BaseEo)itemStorageEo);
        } else {
            itemStorageEo.setShelfId(Long.valueOf(0L));
            itemStorageEo.setShopId(shopId);
            itemStorageEo.setItemId(itemId);
            itemStorageEo.setSkuId(skuId);
            itemStorageEo.setInventoryEffectiveDate(DateUtil.parseDate((String)DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd"));
            this.itemStorageDas.insert((BaseEo)itemStorageEo);
        }
    }

    @Override
    public Long getBundleItemSkuStorage(Long shopId, Long skuId) {
        this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u5e93\u5b58\uff1ashopId={}, skuId={}", (Object)shopId, (Object)skuId);
        List itemBundleRelationEoList = this.itemBundleRelationDas.getListBySkuId((List)Lists.newArrayList((Object[])new Long[]{skuId}));
        Long minBalance = null;
        if (CollectionUtils.isNotEmpty((Collection)itemBundleRelationEoList)) {
            Map<Long, Integer> subSkuMap = itemBundleRelationEoList.stream().collect(Collectors.toMap(StdItemBundleRelationEo::getSubSkuId, StdItemBundleRelationEo::getNum));
            List itemStorageEoList = this.itemStorageDas.selectByParam((List)Lists.newArrayList((Object[])new Long[]{shopId}), (List)null, (List)Lists.newArrayList(subSkuMap.keySet()));
            if (CollectionUtils.isNotEmpty((Collection)itemStorageEoList)) {
                minBalance = itemStorageEoList.stream().filter(itemStorageEo -> itemStorageEo.getBalance() != null).mapToLong(itemStorageEo -> {
                    long balance = 0L;
                    Integer num = (Integer)subSkuMap.get(itemStorageEo.getSkuId());
                    if (num != null && num != 0) {
                        balance = itemStorageEo.getBalance() / (long)num.intValue();
                    }
                    return balance;
                }).min().orElse(0L);
            }
        }
        return minBalance;
    }

    private static void isValidDate(String dateStr) {
        if (!StringUtils.isEmpty((CharSequence)dateStr) && dateStr.length() <= "yyyy-MM-dd".length()) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                simpleDateFormat.setLenient(false);
                simpleDateFormat.parse(dateStr);
            }
            catch (Exception var2) {
                throw new ItemBusinessRuntimeException("\u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f(yyyy-MM-dd)");
            }
        } else {
            throw new ItemBusinessRuntimeException("\u9519\u8bef\u7684\u65e5\u671f\u683c\u5f0f(yyyy-MM-dd)");
        }
    }

    private void checkInstanceIdAndTenantId(BaseReqDto baseReqDto) {
        if (baseReqDto.getInstanceId() == null || baseReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
    }

    private void rollbackItemStorage(String orderNo, Long instanceId, Long tenantId) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setInstanceId(instanceId);
        storageChangeLogEo.setTenantId(tenantId);
        List storageChangeLogEoList = this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
        if (!CollectionUtils.isEmpty((Collection)storageChangeLogEoList)) {
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u56de\u6eda\u64cd\u4f5c\u5f00\u59cb");
            for (StorageChangeLogEo changeLogEo : storageChangeLogEoList) {
                this.itemStorageUtils.addItemStorage(changeLogEo.getShopId(), changeLogEo.getSkuId(), changeLogEo.getAppending());
            }
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u56de\u6eda\u64cd\u4f5c\u7ed3\u675f");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subItemStorage(ItemStorageSubReqDto itemStorageSubReqDto) {
        this.checkInstanceIdAndTenantId((BaseReqDto)itemStorageSubReqDto);
        if (itemStorageSubReqDto != null && !StringUtils.isBlank((CharSequence)itemStorageSubReqDto.getOrderNo()) && !CollectionUtils.isEmpty((Collection)itemStorageSubReqDto.getItemList())) {
            ItemStorageInfoReqDto itemStorageInfoReqDto;
            Iterator var2 = itemStorageSubReqDto.getItemList().iterator();
            do {
                if (var2.hasNext()) continue;
                StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
                storageChangeLogEo.setOrderNo(itemStorageSubReqDto.getOrderNo());
                storageChangeLogEo.setInstanceId(itemStorageSubReqDto.getInstanceId());
                storageChangeLogEo.setTenantId(itemStorageSubReqDto.getTenantId());
                if (this.storageChangeLogDas.count((BaseEo)storageChangeLogEo) > 0) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.ORDER_EXISTS);
                }
                ArrayList<Long> changeLogIdList = new ArrayList<Long>();
                HashMap<Long, String> params = new HashMap<Long, String>();
                for (ItemStorageInfoReqDto storageInfoReqDto : itemStorageSubReqDto.getItemList()) {
                    boolean subResult;
                    ShelfEo shelfEo = new ShelfEo();
                    shelfEo.setShopId(storageInfoReqDto.getShopId());
                    shelfEo.setSkuId(storageInfoReqDto.getSkuId());
                    shelfEo.setInstanceId(itemStorageSubReqDto.getInstanceId());
                    shelfEo.setTenantId(itemStorageSubReqDto.getTenantId());
                    shelfEo = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfEo);
                    if (shelfEo == null) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_OFF_SHELF);
                    }
                    ItemStorageEo itemStorageEo = new ItemStorageEo();
                    itemStorageEo.setShelfId(shelfEo.getId());
                    this.validDateFormat(storageInfoReqDto, itemStorageEo);
                    itemStorageEo.setInstanceId(shelfEo.getInstanceId());
                    itemStorageEo.setTenantId(shelfEo.getTenantId());
                    itemStorageEo = (ItemStorageEo)this.itemStorageDas.selectOne((BaseEo)itemStorageEo);
                    if (itemStorageEo == null) {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
                    }
                    if (StringUtils.isEmpty((CharSequence)storageInfoReqDto.getInventoryEffectiveDate())) {
                        subResult = this.itemStorageUtils.subItemStorage(shelfEo.getShopId(), shelfEo.getSkuId(), -storageInfoReqDto.getNum().longValue());
                    } else {
                        ItemStorageServiceImplExt.isValidDate(storageInfoReqDto.getInventoryEffectiveDate());
                        subResult = this.itemStorageUtils.subItemStorage(storageInfoReqDto.getInventoryEffectiveDate(), shelfEo.getShopId(), shelfEo.getSkuId(), -storageInfoReqDto.getNum().longValue());
                    }
                    if (!subResult) {
                        this.rollbackItemStorage(itemStorageSubReqDto.getOrderNo(), itemStorageSubReqDto.getInstanceId(), itemStorageSubReqDto.getTenantId());
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
                    }
                    StorageChangeLogEo changeLogEo = new StorageChangeLogEo();
                    changeLogEo.setShelfId(shelfEo.getId());
                    changeLogEo.setShopId(storageInfoReqDto.getShopId());
                    changeLogEo.setChannelId(shelfEo.getChannelId());
                    changeLogEo.setItemId(shelfEo.getItemId());
                    changeLogEo.setSkuId(storageInfoReqDto.getSkuId());
                    changeLogEo.setOrderNo(itemStorageSubReqDto.getOrderNo());
                    changeLogEo.setAppending(storageInfoReqDto.getNum());
                    changeLogEo.setStatus(StorageChangeLogStatusEnum.PREEMPTION.getStatus());
                    changeLogEo.setPreemptionTime(new Date());
                    changeLogEo.setInstanceId(itemStorageSubReqDto.getInstanceId());
                    changeLogEo.setTenantId(itemStorageSubReqDto.getTenantId());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("inventory_effective_date", storageInfoReqDto.getInventoryEffectiveDate());
                    changeLogEo.setExtension(JSON.toJSONString(map));
                    this.storageChangeLogDas.insert((BaseEo)changeLogEo);
                    changeLogIdList.add(changeLogEo.getId());
                    params.put(changeLogEo.getId(), storageInfoReqDto.getInventoryEffectiveDate());
                }
                if (CollectionUtils.isNotEmpty(changeLogIdList)) {
                    StorageChangeLogMessageVo storageChangeLogMessageVo = new StorageChangeLogMessageVo();
                    storageChangeLogMessageVo.setChangeLogIdList(changeLogIdList);
                    storageChangeLogMessageVo.setChangType(StorageChangeLogTypeEnum.PREEMPTION_STORAGE.getStatus());
                    storageChangeLogMessageVo.setParams(params);
                    String messageStr = JSON.toJSONString((Object)storageChangeLogMessageVo);
                    this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
                    this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG", (Object)messageStr, Long.valueOf(1L));
                }
                return;
            } while ((itemStorageInfoReqDto = (ItemStorageInfoReqDto)var2.next()) != null && itemStorageInfoReqDto.getSkuId() != null && itemStorageInfoReqDto.getNum() != null && itemStorageInfoReqDto.getNum() >= 0L);
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
    }

    private void validDateFormat(ItemStorageInfoReqDto itemStorageInfoReqDto, ItemStorageEo itemStorageEo) {
        if (StringUtils.isNotEmpty((CharSequence)itemStorageInfoReqDto.getInventoryEffectiveDate())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                itemStorageEo.setInventoryEffectiveDate(sdf.parse(itemStorageInfoReqDto.getInventoryEffectiveDate()));
            }
            catch (ParseException var5) {
                this.logger.error(var5.getMessage(), (Throwable)var5);
                throw new ItemBusinessRuntimeException(var5.getMessage(), var5.getMessage());
            }
        } else {
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.isNull((String)"inventory_effective_date"));
            itemStorageEo.setSqlFilters(sqlFilterList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnItemStorage(ItemStorageReturnReqDto itemStorageReturnReqDto) {
        this.checkInstanceIdAndTenantId((BaseReqDto)itemStorageReturnReqDto);
        if (itemStorageReturnReqDto == null || StringUtils.isBlank((CharSequence)itemStorageReturnReqDto.getOrderNo()) || CollectionUtils.isEmpty((Collection)itemStorageReturnReqDto.getItemList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageReturnReqDto.getItemList()) {
            if (itemStorageInfoReqDto == null || itemStorageInfoReqDto.getSkuId() == null || itemStorageInfoReqDto.getNum() == null || itemStorageInfoReqDto.getNum() < 0L) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            if (!StringUtils.isNotEmpty((CharSequence)itemStorageInfoReqDto.getInventoryEffectiveDate())) continue;
            ItemStorageServiceImplExt.isValidDate(itemStorageInfoReqDto.getInventoryEffectiveDate());
        }
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(itemStorageReturnReqDto.getOrderNo());
        storageChangeLogEo.setInstanceId(itemStorageReturnReqDto.getInstanceId());
        storageChangeLogEo.setTenantId(itemStorageReturnReqDto.getTenantId());
        if (this.storageChangeLogDas.count((BaseEo)storageChangeLogEo) == 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.ORDER_NOT_EXISTS);
        }
        ArrayList<Long> changeLogIdList = new ArrayList<Long>();
        HashMap<Long, String> params = new HashMap<Long, String>();
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageReturnReqDto.getItemList()) {
            ShelfEo shelfEo = new ShelfEo();
            shelfEo.setShopId(itemStorageInfoReqDto.getShopId());
            shelfEo.setSkuId(itemStorageInfoReqDto.getSkuId());
            shelfEo.setInstanceId(itemStorageReturnReqDto.getInstanceId());
            shelfEo.setTenantId(itemStorageReturnReqDto.getTenantId());
            shelfEo = (ShelfEo)this.shelfDas.selectOne((BaseEo)shelfEo);
            if (shelfEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.ITEM_OFF_SHELF);
            }
            ItemStorageEo itemStorageEo = new ItemStorageEo();
            itemStorageEo.setShelfId(shelfEo.getId());
            this.validDateFormat(itemStorageInfoReqDto, itemStorageEo);
            itemStorageEo.setInstanceId(shelfEo.getInstanceId());
            itemStorageEo.setTenantId(shelfEo.getTenantId());
            itemStorageEo = (ItemStorageEo)this.itemStorageDas.selectOne((BaseEo)itemStorageEo);
            if (itemStorageEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.STORAGE_NOT_ENOUGH);
            }
            StorageChangeLogEo queryEo = new StorageChangeLogEo();
            queryEo.setOrderNo(itemStorageReturnReqDto.getOrderNo());
            queryEo.setInstanceId(itemStorageReturnReqDto.getInstanceId());
            queryEo.setTenantId(itemStorageReturnReqDto.getTenantId());
            try {
                Object map;
                StorageChangeLogEo changeLogEo = (StorageChangeLogEo)this.storageChangeLogDas.selectOne((BaseEo)queryEo);
                if (changeLogEo == null) {
                    throw new BizException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg());
                }
                changeLogEo.setAppending(Long.valueOf(-itemStorageInfoReqDto.getNum().longValue()));
                changeLogEo.setStatus(StorageChangeLogStatusEnum.CANCEL.getStatus());
                changeLogEo.setPreemptionTime(new Date());
                if (StringUtils.isNotEmpty((CharSequence)changeLogEo.getExtension())) {
                    map = JSON.parseObject((String)changeLogEo.getExtension());
                    map.put("stage", this.todo);
                    changeLogEo.setExtension(JSON.toJSONString((Object)map));
                } else {
                    map = new HashMap();
                    map.put("stage", this.todo);
                    changeLogEo.setExtension(JSON.toJSONString((Object)map));
                }
                this.storageChangeLogDas.updateSelective((BaseEo)changeLogEo);
                changeLogIdList.add(changeLogEo.getId());
                params.put(changeLogEo.getId(), itemStorageInfoReqDto.getInventoryEffectiveDate());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        if (CollectionUtils.isNotEmpty(changeLogIdList)) {
            StorageChangeLogMessageVo storageChangeLogMessageVo = new StorageChangeLogMessageVo();
            storageChangeLogMessageVo.setChangeLogIdList(changeLogIdList);
            storageChangeLogMessageVo.setChangType(StorageChangeLogTypeEnum.RETURN_STORAGE.getStatus());
            storageChangeLogMessageVo.setParams(params);
            String messageStr = JSON.toJSONString((Object)storageChangeLogMessageVo);
            this.logger.info("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55mq\u53d1\u9001:{}", (Object)messageStr);
            this.commonsMqService.sendDelaySingleMessage("ITEM_STORAGE_CHANGE_LOG", (Object)messageStr, Long.valueOf(1L));
        }
        for (ItemStorageInfoReqDto itemStorageInfoReqDto : itemStorageReturnReqDto.getItemList()) {
            this.itemStorageUtils.addItemStorage(itemStorageInfoReqDto.getInventoryEffectiveDate(), itemStorageInfoReqDto.getShopId(), itemStorageInfoReqDto.getSkuId(), itemStorageInfoReqDto.getNum());
        }
    }

    @Override
    public List<ItemStorageQueryRespDto> queryBranchItemStorage(ItemStorageBranchQueryReqDto itemStorageBranchQueryReqDto) {
        if (CollectionUtils.isEmpty((Collection)itemStorageBranchQueryReqDto.getShelfList())) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemStorageQueryRespDto> itemStorageQueryRespDtoList = new ArrayList<ItemStorageQueryRespDto>();
        for (ShelfReqDto shelfReqDto : itemStorageBranchQueryReqDto.getShelfList()) {
            ItemStorageQueryRespDto itemStorageQueryRespDto = new ItemStorageQueryRespDto();
            itemStorageQueryRespDto.setShopId(shelfReqDto.getShopId());
            itemStorageQueryRespDto.setSkuId(shelfReqDto.getSkuId());
            ItemShelfRespDto itemShelfSkuRespDto = this.shelfService.queryItemShelf(shelfReqDto);
            if (itemShelfSkuRespDto != null) {
                itemStorageQueryRespDto.setItemShelfRespDto(itemShelfSkuRespDto);
                Long avaNum = this.itemStorageUtils.queryItemStorage(shelfReqDto.getShopId(), shelfReqDto.getSkuId());
                itemStorageQueryRespDto.setAvaNum(avaNum);
                itemStorageQueryRespDto.setItemShelfRespDto(itemShelfSkuRespDto);
            } else {
                itemShelfSkuRespDto = new ItemShelfRespDto();
                itemShelfSkuRespDto.setShopId(shelfReqDto.getShopId());
                itemShelfSkuRespDto.setSkuId(shelfReqDto.getSkuId());
                itemShelfSkuRespDto.setItemId(shelfReqDto.getItemId());
                itemShelfSkuRespDto.setBusType(shelfReqDto.getBusType());
                itemShelfSkuRespDto.setStatus(ItemStatus.ITEM_OFFSHELF.getStatus());
                itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
                itemStorageQueryRespDto.setItemShelfRespDto(itemShelfSkuRespDto);
            }
            itemStorageQueryRespDtoList.add(itemStorageQueryRespDto);
        }
        return itemStorageQueryRespDtoList;
    }

    @Override
    public PageInfo<ItemStorageDetailQueryRespDto> queryItemStorageDetail(ItemStorageDetailQueryReqDto itemStorageDetailQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemStorageDetailQueryReqDto != null && itemStorageDetailQueryReqDto.getInstanceId() != null && itemStorageDetailQueryReqDto.getTenantId() != null) {
            ItemStorageEo itemStorageEo = ItemStorageEo.newInstance((Map)itemStorageDetailQueryReqDto.getExtFields());
            DtoHelper.dto2Eo((BaseVo)itemStorageDetailQueryReqDto, (BaseEo)itemStorageEo);
            QueryParamUtils.fillQueryCreateStartTime(itemStorageDetailQueryReqDto.getCreateBeginTime(), (BaseEo)itemStorageEo);
            QueryParamUtils.fillQueryCreateEndTime(itemStorageDetailQueryReqDto.getCreateEndTime(), (BaseEo)itemStorageEo);
            QueryParamUtils.fillQueryUpdateStartTime(itemStorageDetailQueryReqDto.getUpdateBeginTime(), (BaseEo)itemStorageEo);
            QueryParamUtils.fillQueryUpdateEndTime(itemStorageDetailQueryReqDto.getUpdateEndTime(), (BaseEo)itemStorageEo);
            PageInfo eoPageInfo = this.itemStorageDas.selectPage((BaseEo)itemStorageEo, pageNum, pageSize);
            PageInfo dtoPageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList itemStorageDetailQueryRespDtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), itemStorageDetailQueryRespDtoList, ItemStorageDetailQueryRespDto.class);
            for (ItemStorageDetailQueryRespDto detailDto : itemStorageDetailQueryRespDtoList) {
                detailDto.setAvaNum(this.itemStorageUtils.queryItemStorage(detailDto.getShopId(), detailDto.getSkuId()));
            }
            dtoPageInfo.setList(itemStorageDetailQueryRespDtoList);
            return dtoPageInfo;
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
    }

    @Override
    public ItemStorageDetailQueryRespDto queryItemStorageDetail(Long id, Long instanceId, Long tenantId) {
        if (instanceId != null && tenantId != null && id != null) {
            ItemStorageEo itemStorageEo = (ItemStorageEo)this.itemStorageDas.selectByPrimaryKey(id);
            ItemStorageDetailQueryRespDto itemStorageDetailQueryRespDto = new ItemStorageDetailQueryRespDto();
            if (itemStorageEo != null && instanceId.equals(itemStorageEo.getInstanceId()) && tenantId.equals(itemStorageEo.getTenantId())) {
                DtoHelper.eo2Dto((BaseEo)itemStorageEo, (BaseVo)itemStorageDetailQueryRespDto);
                itemStorageDetailQueryRespDto.setAvaNum(this.itemStorageUtils.queryItemStorage(itemStorageEo.getShopId(), itemStorageEo.getSkuId()));
                return itemStorageDetailQueryRespDto;
            }
            return itemStorageDetailQueryRespDto;
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
    }

    @Override
    public List<BundleItemStorageDto> queryBundleItemStorage(Long itemId, Long shopId) {
        List itemSkuEoList;
        ArrayList bundleItemStorageDtoList = Lists.newArrayList();
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (itemEo != null && itemEo.getType() != null && ItemTypeEnum.BUNDLE.getType() == itemEo.getType() && CollectionUtils.isNotEmpty((Collection)(itemSkuEoList = this.itemSkuDas.selectByItemId(itemId)))) {
            itemSkuEoList.forEach(itemSkuEo -> {
                BundleItemStorageDto bundleItemStorageDto = new BundleItemStorageDto();
                bundleItemStorageDto.setShopId(shopId);
                bundleItemStorageDto.setItemId(itemId);
                bundleItemStorageDto.setSkuId(itemSkuEo.getId());
                Long shelfAmount = this.getBundleItemSkuStorage(shopId, itemSkuEo.getId());
                bundleItemStorageDto.setShelfAmount(shelfAmount);
                bundleItemStorageDtoList.add(bundleItemStorageDto);
            });
        }
        return bundleItemStorageDtoList;
    }
}

