/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemStorageExtService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.RItemBundleDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.RItemBundleEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IItemStorageExtServiceImpl
implements IItemStorageExtService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Resource
    private RItemBundleDas rItemBundleDas;
    @Resource
    private ICacheService cacheService;
    @Value(value="${item.query.redis.timeout:300}")
    private Integer queryTimeout;

    @Override
    public List<ItemStorageQueryRespDto> queryItemStorage(ItemStorageQueryReqDto itemStorageQueryReqDto) {
        this.logger.info("\u67e5\u8be2\u865a\u62df\u5e93\u5b58\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)itemStorageQueryReqDto));
        if (null == itemStorageQueryReqDto) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ArrayList<ItemStorageQueryRespDto> itemStorageQueryRespDtoList = new ArrayList<ItemStorageQueryRespDto>();
        if (CollectionUtils.isEmpty((Collection)itemStorageQueryReqDto.getSkuIds())) {
            throw new BizException("\u5546\u54c1sku\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        if (null == itemStorageQueryReqDto.getShopId()) {
            throw new BizException("\u5e97\u94faID\u4e0d\u5b58\u5728!");
        }
        Long shopId = itemStorageQueryReqDto.getShopId();
        itemStorageQueryReqDto.getSkuIds().forEach(skuId -> {
            String cacheKey = "queryItemStorage_" + Long.toString(shopId) + "_" + Long.toString(skuId);
            ItemStorageQueryRespDto itemStorageQueryRespDto = (ItemStorageQueryRespDto)this.cacheService.getCache("item_storage_", cacheKey, ItemStorageQueryRespDto.class);
            if (null != itemStorageQueryRespDto) {
                itemStorageQueryRespDtoList.add(itemStorageQueryRespDto);
            } else {
                itemStorageQueryRespDto = new ItemStorageQueryRespDto();
                itemStorageQueryRespDto.setShopId(shopId);
                itemStorageQueryRespDto.setSkuId(skuId);
                ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"id", skuId)).one();
                if (null == itemSkuEo) {
                    itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
                } else {
                    ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)itemSkuEo.getItemId())).one();
                    if (null == itemEo) {
                        itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
                    } else {
                        itemStorageQueryRespDto.setItemId(itemEo.getId());
                        if (ItemTypeEnum.BUNDLE.getType() == itemEo.getType()) {
                            Long avaNum = this.getBundleSkuStorage(shopId, (Long)skuId, itemEo.getId());
                            itemStorageQueryRespDto.setAvaNum(avaNum);
                        } else {
                            List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().eq((Object)"shop_id", (Object)shopId)).eq((Object)"item_id", (Object)itemEo.getId())).eq((Object)"sku_id", skuId)).orderByDesc((Object)"inventory_effective_date")).list();
                            ItemStorageEo itemStorageEo = new ItemStorageEo();
                            if (CollectionUtils.isNotEmpty((Collection)itemStorageEos)) {
                                itemStorageEo = (ItemStorageEo)itemStorageEos.get(0);
                                itemStorageQueryRespDto.setInventoryEffectiveDate(DateUtil.getDateFormat((Date)itemStorageEo.getInventoryEffectiveDate(), (String)"yyyy-MM-dd"));
                                itemStorageQueryRespDto.setAvaNum(Long.valueOf(itemStorageEo.getBalance() == null ? 0L : itemStorageEo.getBalance()));
                            } else {
                                itemStorageQueryRespDto.setAvaNum(Long.valueOf(0L));
                            }
                        }
                    }
                }
                this.cacheService.setCache("item_storage_", cacheKey, (Object)itemStorageQueryRespDto, this.queryTimeout.intValue());
                itemStorageQueryRespDtoList.add(itemStorageQueryRespDto);
            }
        });
        this.logger.info("\u865a\u62df\u5e93\u5b58\u6570\u636eitemStorageQueryRespDtoList\uff1a{}", (Object)JSON.toJSONString(itemStorageQueryRespDtoList));
        return itemStorageQueryRespDtoList;
    }

    private Long getBundleSkuStorage(Long shopId, Long skuId, Long itemId) {
        Long avaNum = 0L;
        this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u5e93\u5b58\uff1ashopId={}, skuId={}, itemId={}", new Object[]{shopId, skuId, itemId});
        List<RItemBundleEo> itemBundleEos = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", new Object[]{itemId})).list();
        itemBundleEos.forEach(v -> {
            List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().eq((Object)"shop_id", (Object)shopId)).eq((Object)"item_id", (Object)v.getSubItemId())).eq((Object)"sku_id", (Object)v.getSubSkuId())).orderByDesc((Object)"update_time")).list();
            ItemStorageEo itemStorageEo = new ItemStorageEo();
            if (CollectionUtils.isNotEmpty((Collection)itemStorageEos)) {
                itemStorageEo = (ItemStorageEo)itemStorageEos.get(0);
                Long num = itemStorageEo.getBalance() / (long)v.getNum().intValue();
                v.setNum(Integer.valueOf(num.intValue()));
            } else {
                v.setNum(Integer.valueOf(0));
            }
        });
        itemBundleEos = itemBundleEos.stream().sorted(Comparator.comparing(RItemBundleEo::getNum)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemBundleEos)) {
            RItemBundleEo itemBundleEo = (RItemBundleEo)itemBundleEos.get(0);
            avaNum = itemBundleEo.getNum() == null ? 0L : (long)itemBundleEo.getNum().intValue();
        }
        return avaNum;
    }
}

