/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemSkuAuthReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yx.tcbj.center.api.IItemSkuAuthApi;
import com.yx.tcbj.center.dao.eo.ItemSkuAuthEo;
import com.yx.tcbj.center.dao.mapper.ItemSkuAuthMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemSkuAuthApiImpl
implements IItemSkuAuthApi {
    private static final Logger logger = LoggerFactory.getLogger(ItemSkuAuthApiImpl.class);
    @Resource
    private ItemSkuAuthMapper itemSkuAuthMapper;
    @Resource
    private IContext context;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> batchUpdateSkuAuthStatus(List<Long> skuIds, Long organizationId, Integer authStatus) {
        if (CollectionUtils.isEmpty(skuIds) || organizationId == null || authStatus == null) {
            logger.warn("\u6279\u91cf\u66f4\u65b0SKU\u6388\u6743\u72b6\u6001\u53c2\u6570\u4e0d\u5b8c\u6574: skuIds={}, organizationId={}, authStatus={}", new Object[]{skuIds, organizationId, authStatus});
            return RestResponse.VOID;
        }
        try {
            logger.info("\u5f00\u59cb\u6279\u91cf\u66f4\u65b0SKU\u6388\u6743\u72b6\u6001: skuIds={}, organizationId={}, authStatus={}", new Object[]{skuIds, organizationId, authStatus});
            List existingRecords = this.itemSkuAuthMapper.selectBySkuIdsAndOrgId(skuIds, organizationId);
            Map<Long, ItemSkuAuthEo> existingMap = existingRecords.stream().collect(Collectors.toMap(ItemSkuAuthEo::getSkuId, record -> record));
            ArrayList<ItemSkuAuthEo> recordsToSave = new ArrayList<ItemSkuAuthEo>();
            String currentUser = this.getCurrentUser();
            Date now = new Date();
            for (Long skuId : skuIds) {
                ItemSkuAuthEo record2 = existingMap.get(skuId);
                if (record2 != null) {
                    record2.setAuthStatus(authStatus);
                    record2.setUpdatePerson(currentUser);
                    record2.setUpdateTime(now);
                } else {
                    record2 = new ItemSkuAuthEo();
                    record2.setSkuId(skuId);
                    record2.setOrganizationId(organizationId);
                    record2.setAuthStatus(authStatus);
                    record2.setStatus(Integer.valueOf(1));
                    record2.setInstanceId(Long.valueOf(1L));
                    record2.setTenantId(Long.valueOf(1L));
                    record2.setDr(0);
                    record2.setCreatePerson(currentUser);
                    record2.setCreateTime(now);
                    record2.setUpdatePerson(currentUser);
                    record2.setUpdateTime(now);
                }
                recordsToSave.add(record2);
            }
            if (!recordsToSave.isEmpty()) {
                this.itemSkuAuthMapper.batchInsertOrUpdate(recordsToSave);
                logger.info("\u6210\u529f\u6279\u91cf\u66f4\u65b0{}\u6761SKU\u6388\u6743\u8bb0\u5f55", (Object)recordsToSave.size());
            }
            return RestResponse.VOID;
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u66f4\u65b0SKU\u6388\u6743\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u6279\u91cf\u66f4\u65b0SKU\u6388\u6743\u72b6\u6001\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public RestResponse<Map<Long, Integer>> querySkuAuthStatus(List<Long> skuIds, Long organizationId) {
        if (CollectionUtils.isEmpty(skuIds) || organizationId == null) {
            logger.warn("\u67e5\u8be2SKU\u6388\u6743\u72b6\u6001\u53c2\u6570\u4e0d\u5b8c\u6574: skuIds={}, organizationId={}", skuIds, (Object)organizationId);
            return new RestResponse(new HashMap());
        }
        try {
            List authStatusMapList = this.itemSkuAuthMapper.selectSkuAuthStatusMap(skuIds, organizationId);
            HashMap<Long, Integer> authStatusMap = new HashMap<Long, Integer>();
            authStatusMapList.forEach(r -> authStatusMap.put(Long.valueOf((String)r.get("skuId")), Integer.valueOf((String)r.get("authStatus"))));
            for (Long skuId : skuIds) {
                authStatusMap.putIfAbsent(skuId, 0);
            }
            logger.debug("\u67e5\u8be2SKU\u6388\u6743\u72b6\u6001: skuIds={}, organizationId={}, result={}", new Object[]{skuIds, organizationId, authStatusMap});
            return new RestResponse(authStatusMap);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2SKU\u6388\u6743\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2SKU\u6388\u6743\u72b6\u6001\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public RestResponse<List<Long>> queryAuthorizedSkuIds(Long organizationId) {
        if (organizationId == null) {
            logger.warn("\u67e5\u8be2\u5df2\u6388\u6743SKU\u5217\u8868\u53c2\u6570\u4e0d\u5b8c\u6574: organizationId={}", (Object)organizationId);
            return new RestResponse(new ArrayList());
        }
        try {
            List authorizedSkuIds = this.itemSkuAuthMapper.selectAuthorizedSkuIdsByOrgId(organizationId);
            logger.debug("\u67e5\u8be2\u5df2\u6388\u6743SKU\u5217\u8868: organizationId={}, result={}", (Object)organizationId, (Object)authorizedSkuIds);
            return new RestResponse((Object)authorizedSkuIds);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5df2\u6388\u6743SKU\u5217\u8868\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u5df2\u6388\u6743SKU\u5217\u8868\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> createOrUpdateSkuAuth(ItemSkuAuthReqDto reqDto) {
        if (reqDto == null || CollectionUtils.isEmpty((Collection)reqDto.getSkuIds()) || reqDto.getOrganizationId() == null) {
            logger.warn("\u521b\u5efa\u6216\u66f4\u65b0SKU\u6388\u6743\u8bb0\u5f55\u53c2\u6570\u4e0d\u5b8c\u6574: {}", (Object)reqDto);
            return RestResponse.VOID;
        }
        return this.batchUpdateSkuAuthStatus(reqDto.getSkuIds(), reqDto.getOrganizationId(), reqDto.getAuthStatus());
    }

    private String getCurrentUser() {
        try {
            Long userId = this.context.userId();
            return userId != null ? String.valueOf(userId) : "system";
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u5f53\u524d\u7528\u6237ID\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c", (Throwable)e);
            return "system";
        }
    }
}

