/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ItemAuthConfigDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ItemAuthConfigEo;
import com.yx.tcbj.center.api.dto.request.ItemAuthConfigMessageDto;
import com.yx.tcbj.center.biz.service.IItemAuthConfigExtService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemAuthConfigExtServiceImpl
implements IItemAuthConfigExtService {
    private static final Logger logger = LoggerFactory.getLogger(ItemAuthConfigExtServiceImpl.class);
    @Resource
    private ItemAuthConfigDas itemAuthConfigDas;

    @Override
    public void handleAuthConfigChange(ItemAuthConfigMessageDto messageDto) {
        logger.info("\u63a5\u6536\u5230\u5546\u54c1\u6388\u6743\u914d\u7f6e\u53d8\u66f4\u6d88\u606f\uff1ashopCode={}, enable={}", (Object)messageDto.getShopCode(), (Object)messageDto.getEnable());
        if (messageDto.getShopCode() == null || messageDto.getShopCode().trim().isEmpty()) {
            logger.error("\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        try {
            if (messageDto.getEnable() == 1) {
                this.addItemAuthConfig(messageDto.getShopCode());
            } else if (messageDto.getEnable() == 0) {
                this.deleteItemAuthConfig(messageDto.getShopCode());
            } else {
                logger.warn("\u65e0\u6548\u7684\u542f\u7528\u72b6\u6001\uff1a{}", (Object)messageDto.getEnable());
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5546\u54c1\u6388\u6743\u914d\u7f6e\u53d8\u66f4\u5931\u8d25", (Throwable)e);
        }
    }

    private void addItemAuthConfig(String shopCode) {
        logger.info("\u5f00\u59cb\u4e3a\u5e97\u94fa{}\u589e\u52a0\u5546\u54c1\u6388\u6743\u914d\u7f6e", (Object)shopCode);
        try {
            this.addItemAuthConfigRecord(shopCode);
            logger.info("\u5e97\u94fa{}\u7684\u5546\u54c1\u6388\u6743\u914d\u7f6e\u589e\u52a0\u6210\u529f", (Object)shopCode);
        }
        catch (Exception e) {
            logger.error("\u4e3a\u5e97\u94fa{}\u589e\u52a0\u5546\u54c1\u6388\u6743\u914d\u7f6e\u5931\u8d25", (Object)shopCode, (Object)e);
        }
    }

    private void addItemAuthConfigRecord(String shopCode) {
        logger.info("\u5f00\u59cb\u4e3a\u5e97\u94fa{}\u589e\u52a0it_item_auth_config\u914d\u7f6e", (Object)shopCode);
        ItemAuthConfigEo configEo = new ItemAuthConfigEo();
        configEo.setOrganizationId(Long.valueOf(1L));
        configEo.setThirdPartyId(shopCode);
        this.itemAuthConfigDas.insert((BaseEo)configEo);
        logger.info("\u5e97\u94fa{}\u7684it_item_auth_config\u914d\u7f6e\u589e\u52a0\u6210\u529f", (Object)shopCode);
    }

    private void deleteItemAuthConfig(String shopCode) {
        logger.info("\u5f00\u59cb\u4e3a\u5e97\u94fa{}\u5220\u9664\u5546\u54c1\u6388\u6743\u914d\u7f6e", (Object)shopCode);
        try {
            this.deleteItemAuthConfigRecord(shopCode);
            logger.info("\u5e97\u94fa{}\u7684\u5546\u54c1\u6388\u6743\u914d\u7f6e\u5220\u9664\u6210\u529f", (Object)shopCode);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5e97\u94fa{}\u7684\u5546\u54c1\u6388\u6743\u914d\u7f6e\u5931\u8d25", (Object)shopCode, (Object)e);
        }
    }

    private void deleteItemAuthConfigRecord(String shopCode) {
        logger.info("\u5f00\u59cb\u4e3a\u5e97\u94fa{}\u5220\u9664it_item_auth_config\u914d\u7f6e", (Object)shopCode);
        try {
            List configList = ((ExtQueryChainWrapper)this.itemAuthConfigDas.filter().eq((Object)"thirdPartyId", (Object)shopCode)).list();
            if (configList != null && !configList.isEmpty()) {
                for (ItemAuthConfigEo configEo : configList) {
                    this.itemAuthConfigDas.deleteById(configEo.getId());
                }
                logger.info("\u5e97\u94fa{}\u7684it_item_auth_config\u914d\u7f6e\u5220\u9664\u6210\u529f", (Object)shopCode);
            } else {
                logger.info("\u5e97\u94fa{}\u6ca1\u6709\u627e\u5230it_item_auth_config\u914d\u7f6e\u8bb0\u5f55", (Object)shopCode);
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5e97\u94fa{}\u7684it_item_auth_config\u914d\u7f6e\u5931\u8d25", (Object)shopCode, (Object)e);
        }
    }
}

