/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.util;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.UpdateItemPirceCacheDto;
import com.yx.tcbj.center.biz.mq.processor.ItemUpdatePriceProcessor;
import com.yx.tcbj.center.biz.service.query.IItemCenterQueryService;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ItemPriceCacheUtil {
    private static final Logger logger = LoggerFactory.getLogger(ItemUpdatePriceProcessor.class);
    private static String UPDATE_ITEM_PRICE_CACHE_PREFIX = "UPDATE_ITEM_PRICE:";
    private static String CACHE_SAMLL_B = "_SmallB1:";
    private static String CACHE_BIG_B_ORGINFO = "_BigBOrgInfo1:";
    private static String CACHE_ITEM_INFO = "_LongCode1:";
    private static String CACHE_SHOP = "_ShopDto1:";
    private static String CACHE_ORG_BIG_B = "_BigB1:";
    @Resource
    private ICacheService cacheService;
    @Value(value="${update.item.price.cache.expirde:3600}")
    private Integer expired;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemCenterQueryService itemCenterQueryService;

    public CustomerRespDto getSmallCustomerDto(String thirdPartyId) {
        String key = UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_SAMLL_B + thirdPartyId;
        String cache = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isEmpty((CharSequence)cache)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds((List)Lists.newArrayList((Object[])new String[]{thirdPartyId})));
            if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
                CustomerRespDto respDto = (CustomerRespDto)customerRespDtos.get(0);
                logger.info("\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5c0fb\u5ba2\u6237\u4fe1\u606f:{}", (Object)JacksonUtil.toJson((Object)respDto));
                this.cacheService.setCache(key, JSONObject.toJSONString((Object)respDto), (Object)this.expired);
                return respDto;
            }
            return null;
        }
        logger.info("\u7f13\u5b58\u4e2d\u83b7\u53d6\u5c0fb\u5ba2\u6237\u4fe1\u606f:{}", (Object)cache);
        return (CustomerRespDto)JSONObject.parseObject((String)cache, CustomerRespDto.class);
    }

    public OrganizationDto getBigCustomerOrgInfoDto(String code) {
        String key = UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_BIG_B_ORGINFO + code;
        String data = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isEmpty((CharSequence)data)) {
            List organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.queryInfoByCodeList((List)Lists.newArrayList((Object[])new String[]{code})));
            if (CollectionUtils.isNotEmpty((Collection)organizationDtos)) {
                OrganizationDto respDto = (OrganizationDto)organizationDtos.get(0);
                logger.info("\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u5927b\u7ec4\u7ec7\u4fe1\u606f:{}", (Object)JacksonUtil.toJson((Object)respDto));
                this.cacheService.setCache(key, JSONObject.toJSONString((Object)respDto), (Object)this.expired);
                return respDto;
            }
            return null;
        }
        logger.info("\u7f13\u5b58\u4e2d\u83b7\u53d6\u5927b\u7ec4\u7ec7\u4fe1\u606f:{}", (Object)data);
        return (OrganizationDto)JSONObject.parseObject((String)data, OrganizationDto.class);
    }

    public UpdateItemPirceCacheDto getItemInfoByLongCode(String easNo) {
        String key = UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_ITEM_INFO + easNo;
        String serviceCache = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isEmpty((CharSequence)serviceCache)) {
            ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"long_code", (Object)easNo)).one();
            if (itemEo != null) {
                ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"item_id", (Object)itemEo.getId())).one();
                if (itemSkuEo != null) {
                    UpdateItemPirceCacheDto itemPirceCacheDto = new UpdateItemPirceCacheDto();
                    itemPirceCacheDto.setItemId(itemEo.getId());
                    itemPirceCacheDto.setSkuId(itemSkuEo.getId());
                    logger.info("\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u83b7\u53d6\u5546\u54c1\u4fe1\u606f:{}", (Object)JacksonUtil.toJson((Object)itemPirceCacheDto));
                    this.cacheService.setCache(key, JSONObject.toJSONString((Object)itemPirceCacheDto), (Object)this.expired);
                    return itemPirceCacheDto;
                }
                return null;
            }
            return null;
        }
        logger.info("\u7f13\u5b58\u4e2d\u83b7\u53d6\u83b7\u53d6\u5546\u54c1\u4fe1\u606f:{}", (Object)serviceCache);
        return (UpdateItemPirceCacheDto)JSONObject.parseObject((String)serviceCache, UpdateItemPirceCacheDto.class);
    }

    public ShopToBListRespDto getShopDtoByOrgId(Long orgId) {
        String key = UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_SHOP + orgId;
        String cache = (String)this.cacheService.getCache(key, String.class);
        if (StringUtils.isEmpty((CharSequence)cache)) {
            ShopToBQueryReqDto reqDto = new ShopToBQueryReqDto();
            reqDto.setOrganizationIdList((List)Lists.newArrayList((Object[])new Long[]{orgId}));
            reqDto.setPageSize(1);
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryPage(reqDto));
            if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                ShopToBListRespDto shopBaseDto = (ShopToBListRespDto)pageInfo.getList().get(0);
                logger.info("\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f:{}", (Object)JacksonUtil.toJson((Object)shopBaseDto));
                this.cacheService.setCache(key, JSONObject.toJSONString((Object)shopBaseDto), (Object)this.expired);
                return shopBaseDto;
            }
            return null;
        }
        logger.info("\u7f13\u5b58\u4e2d\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f:{}", (Object)cache);
        return (ShopToBListRespDto)JSONObject.parseObject((String)cache, ShopToBListRespDto.class);
    }

    public Map<String, UpdateItemPirceCacheDto> getItemDataMap(List<String> easNoList) {
        Map<String, UpdateItemPirceCacheDto> data = this.getItemDataMapByCache(easNoList);
        if (CollectionUtils.isEmpty(easNoList)) {
            return data;
        }
        List itemSkuList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().select(new String[]{"id", "item_id", "code"}).in((Object)"code", easNoList)).list();
        if (CollectionUtils.isEmpty((Collection)itemSkuList)) {
            return data;
        }
        Map skuIdMap = itemSkuList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o, o1) -> o));
        skuIdMap.keySet().parallelStream().forEach(sku -> {
            ItemSkuEo itemSkuEo = (ItemSkuEo)skuIdMap.get(sku);
            if (itemSkuEo != null) {
                UpdateItemPirceCacheDto cacheDto = new UpdateItemPirceCacheDto();
                cacheDto.setItemId(itemSkuEo.getItemId());
                cacheDto.setSkuId(sku);
                data.put(itemSkuEo.getCode(), cacheDto);
                this.cacheService.hset(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_ITEM_INFO, itemSkuEo.getCode(), (Object)JSONObject.toJSONString((Object)cacheDto));
            }
        });
        return data;
    }

    public Map<String, ItemSkuEo> getSkuDataMap(List<String> easNoList) {
        if (CollectionUtils.isEmpty(easNoList)) {
            return null;
        }
        List itemSkuList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().select(new String[]{"id", "item_id"}).in((Object)"code", easNoList)).list();
        if (CollectionUtils.isEmpty((Collection)itemSkuList)) {
            return null;
        }
        Map<String, ItemSkuEo> skuIdMap = itemSkuList.stream().collect(Collectors.toMap(StdItemSkuEo::getCode, Function.identity(), (o, o1) -> o));
        return skuIdMap;
    }

    private Map<String, UpdateItemPirceCacheDto> getItemDataMapByCache(List<String> easNoList) {
        HashMap<String, UpdateItemPirceCacheDto> dataMap = new HashMap<String, UpdateItemPirceCacheDto>(10);
        ArrayList removeNos = new ArrayList();
        easNoList.iterator().forEachRemaining(no -> {
            String data = (String)this.cacheService.hget(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_ITEM_INFO, no, String.class);
            if (!StringUtils.isEmpty((CharSequence)data)) {
                dataMap.put((String)no, (UpdateItemPirceCacheDto)JSONObject.parseObject((String)data, UpdateItemPirceCacheDto.class));
                removeNos.add(no);
            }
        });
        if (!removeNos.isEmpty()) {
            easNoList.removeAll(removeNos);
        }
        return dataMap;
    }

    public Map<String, Long> getApplierCustomerIdMap(List<String> thirdPartyIds) {
        Map<String, Long> applierCustomerIdMap = this.getApplierCustomerIdMapByCache(thirdPartyIds);
        if (CollectionUtils.isEmpty(thirdPartyIds)) {
            return applierCustomerIdMap;
        }
        List customerRespDtos = (List)this.customerQueryApi.queryByThirdPartyIds(thirdPartyIds).getData();
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            return applierCustomerIdMap;
        }
        Map<String, Long> dpApplier = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getThirdPartyId, BaseRespDto::getId, (o, o1) -> o));
        dpApplier.forEach((k, v) -> {
            applierCustomerIdMap.put((String)k, (Long)v);
            this.cacheService.hset(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_SAMLL_B, k, (Object)String.valueOf(v));
        });
        return applierCustomerIdMap;
    }

    private Map<String, Long> getApplierCustomerIdMapByCache(List<String> thirdPartyIds) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>(10);
        ArrayList removeNos = new ArrayList();
        thirdPartyIds.iterator().forEachRemaining(partyId -> {
            String data = (String)this.cacheService.hget(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_SAMLL_B, partyId, String.class);
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            dataMap.put((String)partyId, Long.valueOf(data));
            removeNos.add(partyId);
        });
        if (!removeNos.isEmpty()) {
            thirdPartyIds.removeAll(removeNos);
        }
        return dataMap;
    }

    public Map<String, Long> getBigCodeOrgIdMap(List<String> codes) {
        Map<String, Long> orgCodeIdMap = this.getBigCodeOrgIdMapByCache(codes);
        if (CollectionUtils.isEmpty(codes)) {
            return orgCodeIdMap;
        }
        List organizationDtos = (List)this.bizOrganizationQueryApi.queryInfoByCodeList(codes).getData();
        if (CollectionUtils.isEmpty((Collection)organizationDtos)) {
            return orgCodeIdMap;
        }
        Map<String, Long> dbOrgCodeIdMap = organizationDtos.stream().collect(Collectors.toMap(OrganizationDto::getCode, OrganizationDto::getId, (o, o1) -> o));
        dbOrgCodeIdMap.forEach((k, v) -> {
            orgCodeIdMap.put((String)k, (Long)v);
            this.cacheService.hset(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_BIG_B_ORGINFO, k, (Object)String.valueOf(v));
        });
        return dbOrgCodeIdMap;
    }

    private Map<String, Long> getBigCodeOrgIdMapByCache(List<String> codes) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>(10);
        ArrayList removeNos = new ArrayList();
        codes.iterator().forEachRemaining(code -> {
            String data = (String)this.cacheService.hget(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_BIG_B_ORGINFO, code, String.class);
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            dataMap.put((String)code, Long.valueOf(data));
            removeNos.add(code);
        });
        if (!removeNos.isEmpty()) {
            codes.removeAll(removeNos);
        }
        return dataMap;
    }

    public Map<Long, Long> getOrgListCustomerIdMap(List<Long> orgIds) {
        Map<Long, Long> orgListCustomerIdMap = this.getOrgListCustomerIdMapByCache(orgIds);
        if (CollectionUtils.isEmpty(orgIds)) {
            return orgListCustomerIdMap;
        }
        List customerList = (List)this.customerQueryApi.queryCustomerByOrgId(orgIds).getData();
        Map<Long, Long> dbOrgListCustomerIdMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, BaseRespDto::getId, (o, o1) -> o));
        dbOrgListCustomerIdMap.forEach((k, v) -> {
            orgListCustomerIdMap.put((Long)k, (Long)v);
            this.cacheService.hset(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_ORG_BIG_B, String.valueOf(k), (Object)String.valueOf(v));
        });
        return orgListCustomerIdMap;
    }

    private Map<Long, Long> getOrgListCustomerIdMapByCache(List<Long> orgIds) {
        HashMap<Long, Long> dataMap = new HashMap<Long, Long>(10);
        ArrayList removeNos = new ArrayList();
        orgIds.iterator().forEachRemaining(code -> {
            String data = (String)this.cacheService.hget(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_ORG_BIG_B, String.valueOf(code), String.class);
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            dataMap.put((Long)code, Long.valueOf(data));
            removeNos.add(code);
        });
        if (!removeNos.isEmpty()) {
            orgIds.removeAll(removeNos);
        }
        return dataMap;
    }

    public Map<String, ShopDto> getShopMap(String code) {
        ShopDto shopDto = (ShopDto)this.cacheService.getCache(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_SHOP, code, ShopDto.class);
        if (shopDto == null) {
            shopDto = (ShopDto)this.shopQueryApi.queryByCode(code).getData();
            if (shopDto == null || shopDto.getSellerId() == 0L) {
                return null;
            }
            this.cacheService.setCache(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_SHOP, code, (Object)shopDto);
        }
        HashMap<String, ShopDto> map = new HashMap<String, ShopDto>(10);
        map.put(code, shopDto);
        return map;
    }

    private Map<Long, TwoTuple<Long, String>> getShopMapByCache(List<Long> orgIds) {
        HashMap<Long, TwoTuple<Long, String>> dataMap = new HashMap<Long, TwoTuple<Long, String>>(10);
        ArrayList removeNos = new ArrayList();
        orgIds.iterator().forEachRemaining(code -> {
            String data = (String)this.cacheService.hget(UPDATE_ITEM_PRICE_CACHE_PREFIX + CACHE_SHOP, String.valueOf(code), String.class);
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            JSONObject json = JSONObject.parseObject((String)data);
            TwoTuple twoTuple = new TwoTuple((Object)json.getLong("first"), (Object)json.getString("second"));
            dataMap.put((Long)code, (TwoTuple<Long, String>)twoTuple);
            removeNos.add(code);
        });
        if (!removeNos.isEmpty()) {
            orgIds.removeAll(removeNos);
        }
        return dataMap;
    }
}

