/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.IExchangeBalanceAccountExtApi;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ExchangeAccountUseExtReq;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.InitExchangeAccountExtReqDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.IExchangeBalanceAccountApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeAccountUseReq;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.InitExchangeAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeBalanceAccountExtApiImpl
implements IExchangeBalanceAccountExtApi {
    private static final Logger log = LoggerFactory.getLogger(ExchangeBalanceAccountExtApiImpl.class);
    @Resource
    private IExchangeBalanceAccountService exchangeBalanceAccountService;
    @Resource
    private IExchangeBalanceAccountApi exchangeBalanceAccountApi;
    @Resource
    private ExternalApiHelp externalApiHelp;

    public RestResponse<Long> initExchangeAccount(InitExchangeAccountExtReqDto initExchangeAccountReqDto) {
        log.info("initExchangeAccount==>{}", JSON.toJSON((Object)initExchangeAccountReqDto));
        String thirdPartyId = initExchangeAccountReqDto.getThirdPartyId();
        if (Objects.isNull(initExchangeAccountReqDto.getCustomerId())) {
            AssertUtils.notEmpty(thirdPartyId, "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{thirdPartyId}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            initExchangeAccountReqDto.setCustomerId(customerRespDtos.get(0).getId());
        }
        return this.exchangeBalanceAccountApi.initExchangeAccount((InitExchangeAccountReqDto)initExchangeAccountReqDto);
    }

    public RestResponse<Void> useExchangeBalanceAccount(ExchangeAccountUseExtReq exchangeAccountUseReq) {
        String thirdPartyId = exchangeAccountUseReq.getThirdPartyId();
        if (Objects.isNull(exchangeAccountUseReq.getCustomerId())) {
            AssertUtils.notEmpty(thirdPartyId, "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{thirdPartyId}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            exchangeAccountUseReq.setCustomerId(customerRespDtos.get(0).getId());
        }
        exchangeAccountUseReq.setTurnoverChangeTypeEnum(this.getEnumByType(exchangeAccountUseReq.getTurnoverChangeTypeStr()));
        this.exchangeBalanceAccountService.useExchangeBalanceAccount((ExchangeAccountUseReq)exchangeAccountUseReq);
        return RestResponse.VOID;
    }

    private TurnoverChangeTypeEnum getEnumByType(String type) {
        for (TurnoverChangeTypeEnum value : TurnoverChangeTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return null;
    }

    public RestResponse<Void> rollbackExchangeAccount(ExchangeBalanceRollBackReqDto rollBackReqDto) {
        this.exchangeBalanceAccountService.rollbackExchangeAccount(rollBackReqDto);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updExchangeBalanceAccount(ExchangeAccountUseExtReq exchangeAccountUseReq) {
        String thirdPartyId = exchangeAccountUseReq.getThirdPartyId();
        if (Objects.isNull(exchangeAccountUseReq.getCustomerId())) {
            AssertUtils.notEmpty(thirdPartyId, "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{thirdPartyId}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            exchangeAccountUseReq.setCustomerId(customerRespDtos.get(0).getId());
        }
        ExchangeBalanceRollBackReqDto rollBackReqDto = new ExchangeBalanceRollBackReqDto();
        rollBackReqDto.setOrderNo(exchangeAccountUseReq.getOrderNo());
        rollBackReqDto.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.CANCEL_ORDER);
        this.exchangeBalanceAccountService.rollbackExchangeAccount(rollBackReqDto);
        exchangeAccountUseReq.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.SUBMIT_ORDER);
        this.exchangeBalanceAccountService.useExchangeBalanceAccount((ExchangeAccountUseReq)exchangeAccountUseReq);
        return RestResponse.VOID;
    }
}

