/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.EngineActivityTypeTobEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.OverlapSourceEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityBizExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ItemActivityTagExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ActivityListBizExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ShopExtDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IActivityBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityBizExtServiceImpl
implements IActivityBizExtService {
    private static final Logger log = LoggerFactory.getLogger(ActivityBizExtServiceImpl.class);
    @Autowired
    private IActivityPreviewService activityPreviewService;
    @Autowired
    private ExternalApiHelp externalApiHelp;
    @Autowired
    private IActivityExtQueryService activityExtQueryService;

    @Override
    public PromotionCouponRespDto queryActivityByItem(ItemActivityTagExtQueryReqDto itemActivityTagQueryReqDto) {
        List<CustomerRespDto> customerRespDtos;
        List<ItemRespDto> itemRespDtos;
        if (CollectionUtils.isNotEmpty((Collection)itemActivityTagQueryReqDto.getShopCodeList())) {
            ShopQueryDto shopQueryDto = new ShopQueryDto();
            shopQueryDto.setCodes(itemActivityTagQueryReqDto.getShopCodeList());
            List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(itemActivityTagQueryReqDto.getShopCodeList());
            if (CollectionUtils.isNotEmpty(shopDtoList)) {
                List shopIdList = shopDtoList.stream().map(ShopDto::getId).collect(Collectors.toList());
                itemActivityTagQueryReqDto.setShopIdList(shopIdList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)itemActivityTagQueryReqDto.getItemCodeList()) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(itemActivityTagQueryReqDto.getItemCodeList()))) {
            List itemIdList = itemRespDtos.stream().map(ItemRespDto::getId).collect(Collectors.toList());
            itemActivityTagQueryReqDto.setItemIdList(itemIdList);
        }
        if (StringUtils.isNotEmpty((CharSequence)itemActivityTagQueryReqDto.getThirdPartyId()) && CollectionUtils.isNotEmpty(customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{itemActivityTagQueryReqDto.getThirdPartyId()})))) {
            itemActivityTagQueryReqDto.setCustomerId(customerRespDtos.get(0).getId());
        }
        return this.activityPreviewService.queryActivityByItem((ItemActivityTagQueryReqDto)itemActivityTagQueryReqDto);
    }

    @Override
    public List<ActivityListBizExtRespDto> queryExchangeActivityByCustomer(ActivityBizExtQueryReqDto queryReqDto) {
        AssertUtils.notEmpty(queryReqDto.getShopCode(), "\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(queryReqDto.getThirdPartyId(), "\u5ba2\u6237-\u7b2c\u4e09\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getShopCode())) {
            List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(Lists.newArrayList((Object[])new String[]{queryReqDto.getShopCode()}));
            AssertUtils.notEmpty(shopDtoList, "\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
            queryReqDto.setShopId(shopDtoList.get(0).getId());
        }
        CustomerRespDto customerRespDto = new CustomerRespDto();
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getThirdPartyId())) {
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{queryReqDto.getThirdPartyId()}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            customerRespDto = customerRespDtos.get(0);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getActivityTypeStr())) {
            EngineActivityTypeTobEnum engineActivityTypeTobEnum = EngineActivityTypeTobEnum.fromName((String)queryReqDto.getActivityTypeStr());
            AssertUtils.notNull(engineActivityTypeTobEnum, "\u6d3b\u52a8\u7c7b\u578b\u53c2\u6570\u4e0d\u6b63\u786e");
            queryReqDto.setActivityType(engineActivityTypeTobEnum.getName());
            queryReqDto.setActivityTemplateId(engineActivityTypeTobEnum.getCode());
        } else {
            ArrayList activityTemplateIds = OverlapSourceEnum.TIME_DISCOUNT.getCode().equals(queryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : (OverlapSourceEnum.EXCHANGE.getCode().equals(queryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}));
            queryReqDto.setActivityTemplateIds((List)activityTemplateIds);
        }
        queryReqDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.ACTIVATE.getKey()}));
        log.info("\u67e5\u8be2\u6d3b\u52a8\u5165\u53c2={}", JSON.toJSON((Object)queryReqDto));
        PageInfo activityListRespDtoPageInfo = this.activityExtQueryService.queryActivityPage((ActivityExtDto)queryReqDto, Integer.valueOf(1), Integer.valueOf(2000));
        log.info("\u67e5\u8be2\u6d3b\u52a8\u7ed3\u679c={}", JSON.toJSON((Object)activityListRespDtoPageInfo));
        List activityRespDtos = activityListRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)activityRespDtos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            Boolean validateTargetCustomer = this.activityPreviewService.validateTargetCustomer(activityRespDto.getId(), customerRespDto.getId(), customerRespDto);
            if (!validateTargetCustomer.booleanValue()) continue;
            ActivityListBizExtRespDto activityListBizExtRespDto = new ActivityListBizExtRespDto();
            CubeBeanUtils.copyProperties((Object)activityListBizExtRespDto, (Object)activityRespDto, (String[])new String[0]);
            respDtoList.add(activityListBizExtRespDto);
        }
        return respDtoList;
    }

    @Override
    public ShopExtDto queryShopByCode(String code) {
        AssertUtils.notEmpty(code, "\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(Lists.newArrayList((Object[])new String[]{code}));
        if (CollectionUtils.isEmpty(shopDtoList)) {
            return null;
        }
        ShopExtDto shopExtDto = new ShopExtDto();
        CubeBeanUtils.copyProperties((Object)shopExtDto, (Object)shopDtoList.get(0), (String[])new String[0]);
        return shopExtDto;
    }
}

