/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.EngineActivityTypeTobEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.OverlapSourceEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.BaseActivityTobDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityBizExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ItemActivityTagExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.ExchangeRuleContent;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.GExchange;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ActivityListBizExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ShopExtDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.response.ExchangeBalanceAdvanceRespDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IActivityBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IExchangeBalanceAdvanceService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceAccountDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceAccountEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityBizExtServiceImpl
implements IActivityBizExtService {
    private static final Logger log = LoggerFactory.getLogger(ActivityBizExtServiceImpl.class);
    @Autowired
    private IActivityPreviewService activityPreviewService;
    @Autowired
    private ExternalApiHelp externalApiHelp;
    @Autowired
    private IActivityExtQueryService activityExtQueryService;
    @Resource
    private ExchangeBalanceAccountDas exchangeBalanceAccountDas;
    @Resource
    private IExchangeBalanceAdvanceService exchangeBalanceAdvanceService;
    @Autowired
    private IConditionService conditionService;

    @Override
    public PromotionCouponRespDto queryActivityByItem(ItemActivityTagExtQueryReqDto itemActivityTagQueryReqDto) {
        List<CustomerRespDto> customerRespDtos;
        List<ItemRespDto> itemRespDtos;
        if (CollectionUtils.isNotEmpty((Collection)itemActivityTagQueryReqDto.getShopCodeList())) {
            ShopQueryDto shopQueryDto = new ShopQueryDto();
            shopQueryDto.setCodes(itemActivityTagQueryReqDto.getShopCodeList());
            List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(itemActivityTagQueryReqDto.getShopCodeList());
            if (CollectionUtils.isNotEmpty(shopDtoList)) {
                List shopIdList = shopDtoList.stream().map(ShopDto::getId).collect(Collectors.toList());
                itemActivityTagQueryReqDto.setShopIdList(shopIdList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)itemActivityTagQueryReqDto.getItemCodeList()) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(itemActivityTagQueryReqDto.getItemCodeList()))) {
            List itemIdList = itemRespDtos.stream().map(ItemRespDto::getId).collect(Collectors.toList());
            itemActivityTagQueryReqDto.setItemIdList(itemIdList);
        }
        if (StringUtils.isNotEmpty((CharSequence)itemActivityTagQueryReqDto.getThirdPartyId()) && CollectionUtils.isNotEmpty(customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{itemActivityTagQueryReqDto.getThirdPartyId()})))) {
            itemActivityTagQueryReqDto.setCustomerId(customerRespDtos.get(0).getId());
        }
        return this.activityPreviewService.queryActivityByItem((ItemActivityTagQueryReqDto)itemActivityTagQueryReqDto);
    }

    @Override
    public List<ActivityListBizExtRespDto> queryExchangeActivityByCustomer(ActivityBizExtQueryReqDto queryReqDto) {
        AssertUtils.notEmpty(queryReqDto.getShopCode(), "\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(queryReqDto.getThirdPartyId(), "\u5ba2\u6237-\u7b2c\u4e09\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getShopCode())) {
            List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(Lists.newArrayList((Object[])new String[]{queryReqDto.getShopCode()}));
            AssertUtils.notEmpty(shopDtoList, "\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
            queryReqDto.setShopId(shopDtoList.get(0).getId());
        }
        CustomerRespDto customerRespDto = new CustomerRespDto();
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getThirdPartyId())) {
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{queryReqDto.getThirdPartyId()}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            customerRespDto = customerRespDtos.get(0);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getActivityTypeStr())) {
            EngineActivityTypeTobEnum engineActivityTypeTobEnum = EngineActivityTypeTobEnum.fromName((String)queryReqDto.getActivityTypeStr());
            AssertUtils.notNull(engineActivityTypeTobEnum, "\u6d3b\u52a8\u7c7b\u578b\u53c2\u6570\u4e0d\u6b63\u786e");
            queryReqDto.setActivityType(engineActivityTypeTobEnum.getName());
            queryReqDto.setActivityTemplateId(engineActivityTypeTobEnum.getCode());
        } else {
            ArrayList activityTemplateIds = OverlapSourceEnum.TIME_DISCOUNT.getCode().equals(queryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : (OverlapSourceEnum.EXCHANGE.getCode().equals(queryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}));
            queryReqDto.setActivityTemplateIds((List)activityTemplateIds);
        }
        queryReqDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.ACTIVATE.getKey()}));
        log.info("\u67e5\u8be2\u6d3b\u52a8\u5165\u53c2={}", JSON.toJSON((Object)queryReqDto));
        PageInfo activityListRespDtoPageInfo = this.activityExtQueryService.queryActivityPage((ActivityExtDto)queryReqDto, Integer.valueOf(1), Integer.valueOf(2000));
        log.info("\u67e5\u8be2\u6d3b\u52a8\u7ed3\u679c={}", JSON.toJSON((Object)activityListRespDtoPageInfo));
        List activityRespDtos = activityListRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)activityRespDtos)) {
            return Lists.newArrayList();
        }
        List<Long> activityIds = activityRespDtos.stream().map(ActivityRespDto::getId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper balanceAccountQuery = new LambdaQueryWrapper();
        balanceAccountQuery.in(ExchangeBalanceAccountEo::getActivityId, activityIds);
        balanceAccountQuery.eq(ExchangeBalanceAccountEo::getCustomerId, (Object)customerRespDto.getId());
        List exchangeBalanceAccountEos = this.exchangeBalanceAccountDas.getMapper().selectList((Wrapper)balanceAccountQuery);
        Map<Object, Object> balanceAccountMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)exchangeBalanceAccountEos)) {
            balanceAccountMap = exchangeBalanceAccountEos.stream().collect(Collectors.toMap(ExchangeBalanceAccountEo::getActivityId, Function.identity(), (k1, k2) -> k1));
        }
        List<ExchangeBalanceAdvanceRespDto> exchangeBalanceAdvanceRespDtos = this.exchangeBalanceAdvanceService.queryActivityIdAndCustomerId(activityIds, customerRespDto.getId());
        Map<Object, Object> balanceAdvanceMap = new HashMap();
        if (CollectionUtils.isNotEmpty(exchangeBalanceAdvanceRespDtos)) {
            balanceAdvanceMap = exchangeBalanceAdvanceRespDtos.stream().collect(Collectors.groupingBy(ExchangeBalanceAdvanceRespDto::getActivityId));
        }
        List<ConditionRespDto> conditionRespDtoList = this.queryConditions(activityIds, 1196944771412880296L);
        Map<Long, List<ConditionRespDto>> activityMap = conditionRespDtoList.stream().collect(Collectors.groupingBy(ConditionRespDto::getActivityId));
        ArrayList respDtoList = Lists.newArrayList();
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            Boolean validateTargetCustomer = this.activityPreviewService.validateTargetCustomer(activityRespDto.getId(), customerRespDto.getId(), customerRespDto);
            if (!validateTargetCustomer.booleanValue()) continue;
            ActivityListBizExtRespDto activityListBizExtRespDto = new ActivityListBizExtRespDto();
            CubeBeanUtils.copyProperties((Object)activityListBizExtRespDto, (Object)activityRespDto, (String[])new String[0]);
            Long activityTemplateId = activityRespDto.getActivityTemplateId();
            if (Objects.equals(activityTemplateId, EngineActivityTypeTobEnum.EXCHANGE_ACTIVITY.getCode())) {
                List<ConditionRespDto> conditionList;
                if (balanceAccountMap.containsKey(activityRespDto.getId())) {
                    ExchangeBalanceAccountEo exchangeBalanceAccountEo = (ExchangeBalanceAccountEo)balanceAccountMap.get(activityRespDto.getId());
                    activityListBizExtRespDto.setExchangeRemaining(exchangeBalanceAccountEo.getAvailableBalance());
                    activityListBizExtRespDto.setExchangeTotal(exchangeBalanceAccountEo.getAvailableBalance());
                }
                if (balanceAdvanceMap.containsKey(activityRespDto.getId())) {
                    List balanceAdvanceRespDtos = (List)balanceAdvanceMap.get(activityRespDto.getId());
                    BigDecimal advanceAmount = exchangeBalanceAdvanceRespDtos.stream().map(ExchangeBalanceAdvanceRespDto::getAdvanceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    activityListBizExtRespDto.setAdvanceTotal(advanceAmount);
                    activityListBizExtRespDto.setAdvanceRemaining(advanceAmount);
                }
                if (CollectionUtils.isNotEmpty(conditionList = activityMap.get(activityRespDto.getId()))) {
                    ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
                    this.parse(conditionList.get(0), exchangeActivityDto);
                    activityListBizExtRespDto.setExchangeActivityDtos(exchangeActivityDto);
                    if (CollectionUtils.isNotEmpty((Collection)exchangeActivityDto.getPromotionContents())) {
                        ExchangeRuleContent exchangeRuleContent = (ExchangeRuleContent)exchangeActivityDto.getPromotionContents().get(0);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u6d3b\u52a8\u5546\u54c1\u603b");
                        stringBuffer.append(exchangeRuleContent.getUnit() == 1 ? "\u91d1\u989d" : "\u6570\u91cf");
                        stringBuffer.append("\u6ee1");
                        stringBuffer.append(exchangeRuleContent.getThreshold());
                        stringBuffer.append(exchangeRuleContent.getUnit() == 1 ? "\u5143" : "\u4ef6");
                        if (Objects.nonNull(exchangeRuleContent.getIsOrderScale()) && Objects.nonNull(exchangeRuleContent.getOrderScale())) {
                            stringBuffer.append("\u4e14\u8ba2\u5355\u91d1\u989d\u6ee1");
                            stringBuffer.append(exchangeRuleContent.getOrderScale());
                            stringBuffer.append("\u5143");
                        }
                        stringBuffer.append("\uff0c\u9001");
                        stringBuffer.append(exchangeRuleContent.getDiscount());
                        stringBuffer.append(exchangeRuleContent.getDiscountScale() == 2 ? "%" : "");
                        stringBuffer.append(exchangeRuleContent.getDiscountUnit() == 1 ? "\u5143" : "\u4ef6");
                        stringBuffer.append("\u6362\u8d2d\u989d\u5ea6;");
                        activityListBizExtRespDto.setPromotioncontents(stringBuffer.toString());
                    }
                }
            }
            respDtoList.add(activityListBizExtRespDto);
        }
        return respDtoList;
    }

    public <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
        exchangeActivityDto.setPromotionMethod(exchangeRule.getPromotionMethod());
        exchangeActivityDto.setPromotionCondition(exchangeRule.getPromotionCondition());
        exchangeActivityDto.setThresholdType(exchangeRule.getThresholdType());
        exchangeActivityDto.setPromotionType(exchangeRule.getPromotionType());
        ArrayList exchangeRuleContents = new ArrayList();
        exchangeRule.getExcRuleContents().stream().forEach(contents -> {
            ExchangeRuleContent exchangeRuleContent = new ExchangeRuleContent();
            CubeBeanUtils.copyProperties((Object)exchangeRuleContent, (Object)contents, (String[])new String[0]);
            List exchangeItems = BeanCopierUtils.copyList((List)contents.getExchangeItems(), GExchange.class);
            exchangeRuleContent.setExchangeItems(exchangeItems);
            exchangeRuleContents.add(exchangeRuleContent);
        });
        exchangeActivityDto.setPromotionContents(exchangeRuleContents);
    }

    @Override
    public ShopExtDto queryShopByCode(String code) {
        AssertUtils.notEmpty(code, "\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(Lists.newArrayList((Object[])new String[]{code}));
        if (CollectionUtils.isEmpty(shopDtoList)) {
            return null;
        }
        ShopExtDto shopExtDto = new ShopExtDto();
        CubeBeanUtils.copyProperties((Object)shopExtDto, (Object)shopDtoList.get(0), (String[])new String[0]);
        return shopExtDto;
    }

    public List<ConditionRespDto> queryConditions(List<Long> acIds, long conditionTemplateId) {
        return acIds.parallelStream().flatMap(id -> {
            ConditionReqDto queryDto = new ConditionReqDto();
            queryDto.setActivityId(id);
            if (conditionTemplateId > 0L) {
                queryDto.setConditionTemplateId(Long.valueOf(conditionTemplateId));
            }
            return this.conditionService.queryConditionList(queryDto).stream();
        }).collect(Collectors.toList());
    }
}

