/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityItemExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ActivityItemExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IActivityItemBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityItemBizExtServiceImpl
implements IActivityItemBizExtService {
    private static final Logger log = LoggerFactory.getLogger(ActivityItemBizExtServiceImpl.class);
    @Autowired
    private IActivityItemService activityItemService;
    @Resource
    private ExternalApiHelp externalApiHelp;

    @Override
    public List<ActivityItemExtRespDto> queryActivityItem(ActivityItemExtQueryReqDto queryReqDto) {
        List<ItemSkuRespDto> itemSkuCodes;
        List<ItemRespDto> itemRespDtos;
        List<ShopDto> shopDtoList;
        log.info("ActivityItemBizExtServiceImpl.queryActivityItem=>{}", JSON.toJSON((Object)queryReqDto));
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getShopCode()) && CollectionUtils.isNotEmpty(shopDtoList = this.externalApiHelp.getShopByCodes(Lists.newArrayList((Object[])new String[]{queryReqDto.getShopCode()})))) {
            queryReqDto.setShopId(shopDtoList.get(0).getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getItemCode()) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(Lists.newArrayList((Object[])new String[]{queryReqDto.getItemCode()})))) {
            queryReqDto.setItemId(itemRespDtos.get(0).getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getSkuCode()) && CollectionUtils.isNotEmpty(itemSkuCodes = this.externalApiHelp.getItemSkuCodes(Lists.newArrayList((Object[])new String[]{queryReqDto.getSkuCode()})))) {
            queryReqDto.setSkuId(itemSkuCodes.get(0).getId());
        }
        List activityItemList = this.activityItemService.queryActivityItem((ActivityItemQueryReqDto)queryReqDto);
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)activityItemList)) {
            return resultList;
        }
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)activityItemList, ActivityItemExtRespDto.class);
        Set<Long> shopIdSet = resultList.stream().map(ActivityItemRespDto::getShopId).collect(Collectors.toSet());
        Set<Long> itemIdSet = resultList.stream().map(ActivityItemRespDto::getItemId).collect(Collectors.toSet());
        Set<Long> skuIdSet = resultList.stream().map(ActivityItemRespDto::getSkuId).collect(Collectors.toSet());
        Map<Long, ShopDto> shopMap = this.externalApiHelp.getShopMapById(shopIdSet);
        Map<Long, ItemRespDto> itemMap = this.externalApiHelp.getItemMapById(itemIdSet);
        Map<Long, ItemSkuRespDto> customerMap = this.externalApiHelp.getItemSkuMapById(skuIdSet);
        for (ActivityItemExtRespDto extDto : resultList) {
            if (shopMap.containsKey(extDto.getShopId())) {
                extDto.setShopCode(shopMap.get(extDto.getShopId()).getCode());
            }
            if (itemMap.containsKey(extDto.getItemId())) {
                extDto.setItemCode(itemMap.get(extDto.getItemId()).getCode());
            }
            if (!customerMap.containsKey(extDto.getSkuId())) continue;
            extDto.setSkuCode(customerMap.get(extDto.getSkuId()).getCode());
        }
        return resultList;
    }
}

