/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.ExchangeAdvanceStatusEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.request.ExchangeBalanceAdvanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.request.ExchangeBalanceAdvanceReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.response.ExchangeBalanceAdvanceRespDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IExchangeBalanceAdvanceService;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.NoGreateUtil;
import com.dtyunxi.yundt.cube.center.promotion.dao.das.ExchangeBalanceAdvanceDas;
import com.dtyunxi.yundt.cube.center.promotion.dao.eo.ExchangeBalanceAdvanceEo;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.common.constants.TaskStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ExchangeBalanceTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeStatementChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceAccountDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceStatementDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceTurnoverDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceAccountEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceStatementEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceTurnoverEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeBalanceAdvanceServiceImpl
implements IExchangeBalanceAdvanceService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeBalanceAdvanceServiceImpl.class);
    @Resource
    private ExchangeBalanceAdvanceDas exchangeBalanceAdvanceDas;
    @Resource
    private ExchangeBalanceAccountDas exchangeBalanceAccountDas;
    @Resource
    private ExchangeBalanceStatementDas exchangeBalanceStatementDas;
    @Resource
    private ExchangeBalanceTurnoverDas exchangeBalanceTurnoverDas;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ICustomerQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addExchangeBalanceAdvance(ExchangeBalanceAdvanceReqDto addReqDto) {
        log.info("\u65b0\u589e\u9884\u652f\u989d\u5ea6\u5165\u53c2={}", JSON.toJSON((Object)addReqDto));
        Date now = new Date();
        this.verifyParam(addReqDto);
        addReqDto.setAdvanceTime(now);
        addReqDto.setAdvanceGrantTime(addReqDto.getAdvanceGrantTime() != null ? addReqDto.getAdvanceGrantTime() : DateUtils.addSeconds((Date)now, (int)-1));
        if (Objects.isNull(addReqDto.getOrganizationId())) {
            CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(addReqDto.getCustomerId()));
            AssertUtils.notNull(customerRespDto, "\u5f53\u524d\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            addReqDto.setOrganizationId(customerRespDto.getMerchantId());
        }
        LambdaQueryWrapper accountWarpper = new LambdaQueryWrapper();
        accountWarpper.eq(ExchangeBalanceAccountEo::getActivityId, (Object)addReqDto.getActivityId());
        accountWarpper.eq(ExchangeBalanceAccountEo::getCustomerId, (Object)addReqDto.getCustomerId());
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.getMapper().selectOne((Wrapper)accountWarpper);
        ExchangeBalanceAdvanceEo advanceEo = new ExchangeBalanceAdvanceEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)advanceEo);
        advanceEo.setStatus(ExchangeAdvanceStatusEnum.WAIT_GRANT.getStatus());
        if (Objects.nonNull(exchangeBalanceAccountEo)) {
            advanceEo.setExchangeAccountId(exchangeBalanceAccountEo.getId());
        }
        advanceEo.setAdvanceNo(this.noGreateUtil.generateNo("HGYZ", 5));
        this.exchangeBalanceAdvanceDas.insert((BaseEo)advanceEo);
        if (advanceEo.getAdvanceGrantTime().before(new Date())) {
            this.issue(advanceEo.getAdvanceNo());
        } else {
            this.createTask("advanceIssueTask", "\u6362\u8d2d\u9884\u652f\u53d1\u653e\u5b9a\u65f6\u4efb\u52a1", advanceEo.getAdvanceNo(), advanceEo.getAdvanceGrantTime());
        }
        return advanceEo.getId();
    }

    private void createTask(String bizCode, String bizName, String advanceNo, Date taskTime) {
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setAppCode(this.appCode);
        taskAndBizCreateReqDto.setBizCode(bizCode);
        taskAndBizCreateReqDto.setBizName(bizName);
        taskAndBizCreateReqDto.setParams(advanceNo);
        taskAndBizCreateReqDto.setScheduleExpression(DateUtil.date2Cron((Date)taskTime));
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setTaskDesc("");
        taskAndBizCreateReqDto.setTaskName("\u6362\u8d2d\u9884\u652f\u53d1\u653e\u5b9a\u65f6\u4efb\u52a1" + advanceNo);
        taskAndBizCreateReqDto.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreateReqDto.setTenantId(Long.valueOf(-1L));
        Long taskId = (Long)RestResponseHelper.extractData((RestResponse)this.taskApi.addWithBiz(taskAndBizCreateReqDto));
        RestResponseHelper.extractData((RestResponse)this.taskApi.enableById(taskId, "{}"));
    }

    @Override
    public void delete(Long id) {
        ExchangeBalanceAdvanceEo advanceEo = (ExchangeBalanceAdvanceEo)this.exchangeBalanceAdvanceDas.selectByPrimaryKey(id);
        AssertUtils.notNull(advanceEo, "\u9884\u652f\u5355\u4e0d\u5b58\u5728");
        AssertUtils.isTrue(ExchangeAdvanceStatusEnum.WAIT_GRANT.getStatus().equals(advanceEo.getStatus()), "\u5f85\u53d1\u653e\u9884\u652f\u5355\u624d\u5141\u8bb8\u5220\u9664");
        this.exchangeBalanceAdvanceDas.logicDeleteById(id);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName("\u6362\u8d2d\u9884\u652f\u53d1\u653e\u5b9a\u65f6\u4efb\u52a1" + advanceEo.getAdvanceNo());
        PageInfo issueTaskPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApi.queryByPage(JSON.toJSONString((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(10)));
        if (issueTaskPage != null && CollectionUtil.isNotEmpty((Collection)issueTaskPage.getList())) {
            for (TaskQueryRespDto task : issueTaskPage.getList()) {
                if (Objects.equals(task.getStatus(), TaskStatusEnum.ENABLE.getCode())) {
                    this.taskApi.disableById(task.getId(), "{}");
                }
                this.taskApi.removeById(task.getId(), "{}");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void issue(String advanceNo) {
        BigDecimal oldUsedBalance;
        BigDecimal oldBalance;
        BigDecimal availableBalance;
        log.info("\u5f00\u59cb\u9884\u652f\u989d\u5ea6\u53d1\u653e\uff1a{}", (Object)advanceNo);
        Date now = new Date();
        ExchangeBalanceAdvanceEo exchangeBalanceAdvanceEo = new ExchangeBalanceAdvanceEo();
        exchangeBalanceAdvanceEo.setAdvanceNo(advanceNo);
        ExchangeBalanceAdvanceEo advanceEo = (ExchangeBalanceAdvanceEo)this.exchangeBalanceAdvanceDas.selectOne((BaseEo)exchangeBalanceAdvanceEo);
        AssertUtils.notNull(advanceEo, "\u989d\u5ea6\u9884\u652f\u5355\u4e0d\u5b58\u5728\uff0c\u53d1\u653e\u5931\u8d25");
        AssertUtils.isTrue(ExchangeAdvanceStatusEnum.WAIT_GRANT.getStatus().equals(advanceEo.getStatus()), "\u5f85\u53d1\u653e\u9884\u652f\u5355\u624d\u5141\u8bb8\u53d1\u653e");
        AssertUtils.isTrue(advanceEo.getAdvanceGrantTime().before(now), "\u672a\u5230\u53d1\u653e\u65f6\u95f4");
        ExchangeBalanceAccountEo accountEo = null;
        if (Objects.nonNull(advanceEo.getExchangeAccountId())) {
            LambdaQueryWrapper accountWarpper = new LambdaQueryWrapper();
            accountWarpper.eq(BaseEo::getId, (Object)advanceEo.getExchangeAccountId());
            accountEo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.getMapper().selectOne((Wrapper)accountWarpper);
        }
        int row = 0;
        if (Objects.isNull(accountEo)) {
            accountEo = new ExchangeBalanceAccountEo();
            accountEo.setActivityId(advanceEo.getActivityId());
            accountEo.setAdvanceSurplusBalance(advanceEo.getAdvanceAmount());
            accountEo.setAdvanceTotalBalance(advanceEo.getAdvanceAmount());
            accountEo.setCustomerCode(advanceEo.getCustomerCode());
            accountEo.setCustomerId(advanceEo.getCustomerId());
            accountEo.setCustomerName(advanceEo.getCustomerName());
            accountEo.setOrganizationId(advanceEo.getOrganizationId());
            accountEo.setAvailableBalance(BigDecimal.ZERO);
            accountEo.setUsedBalance(BigDecimal.ZERO);
            row = this.exchangeBalanceAccountDas.insert((BaseEo)accountEo);
            availableBalance = accountEo.getAdvanceSurplusBalance();
            oldBalance = BigDecimal.ZERO;
            oldUsedBalance = BigDecimal.ZERO;
        } else {
            ExchangeBalanceAccountEo updateEo = new ExchangeBalanceAccountEo();
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)accountEo.getId())).eq((Object)"available_balance", (Object)accountEo.getAvailableBalance());
            updateEo.setAdvanceSurplusBalance(accountEo.getAdvanceSurplusBalance().add(advanceEo.getAdvanceAmount()));
            updateEo.setAdvanceTotalBalance(accountEo.getAdvanceTotalBalance().add(advanceEo.getAdvanceAmount()));
            availableBalance = updateEo.getAdvanceSurplusBalance();
            oldBalance = accountEo.getAdvanceTotalBalance();
            row = this.exchangeBalanceAccountDas.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
            oldUsedBalance = accountEo.getAdvanceTotalBalance().subtract(accountEo.getAdvanceSurplusBalance());
        }
        ExchangeBalanceAdvanceEo advanceUpdateEo = new ExchangeBalanceAdvanceEo();
        advanceUpdateEo.setId(advanceEo.getId());
        if (Objects.isNull(advanceEo.getExchangeAccountId())) {
            advanceUpdateEo.setExchangeAccountId(accountEo.getId());
        }
        advanceUpdateEo.setStatus(advanceEo.getAdvanceSendBackTime() != null ? ExchangeAdvanceStatusEnum.WAIT_RETURN.getStatus() : ExchangeAdvanceStatusEnum.NO_NEED_RETURN.getStatus());
        if (row == 0) {
            advanceUpdateEo.setStatus(ExchangeAdvanceStatusEnum.GRANT_FAIL.getStatus());
        } else {
            ExchangeBalanceTurnoverEo exchangeBalanceTurnoverEo = new ExchangeBalanceTurnoverEo();
            exchangeBalanceTurnoverEo.setBalanceAccountId(accountEo.getId());
            exchangeBalanceTurnoverEo.setActivityId(accountEo.getActivityId());
            exchangeBalanceTurnoverEo.setCustomerId(accountEo.getCustomerId());
            exchangeBalanceTurnoverEo.setCustomerCode(accountEo.getCustomerCode());
            exchangeBalanceTurnoverEo.setCustomerName(accountEo.getCustomerName());
            exchangeBalanceTurnoverEo.setOrderNo(advanceEo.getAdvanceNo());
            exchangeBalanceTurnoverEo.setChangeType(TurnoverChangeTypeEnum.ADVANCE_GRANT.getType());
            exchangeBalanceTurnoverEo.setStatus(Integer.valueOf(0));
            exchangeBalanceTurnoverEo.setOrganizationId(accountEo.getOrganizationId());
            exchangeBalanceTurnoverEo.setOldBalance(oldBalance);
            exchangeBalanceTurnoverEo.setChangeBalance(advanceEo.getAdvanceAmount());
            exchangeBalanceTurnoverEo.setNewBalance(availableBalance);
            exchangeBalanceTurnoverEo.setOldUsedBalance(oldUsedBalance);
            exchangeBalanceTurnoverEo.setChangeUsedBalance(oldUsedBalance);
            exchangeBalanceTurnoverEo.setNewUsedBalance(oldUsedBalance);
            exchangeBalanceTurnoverEo.setBalanceType(ExchangeBalanceTypeEnum.ADVANCE.getKey());
            this.exchangeBalanceTurnoverDas.insert((BaseEo)exchangeBalanceTurnoverEo);
            ExchangeBalanceStatementEo statementEo = new ExchangeBalanceStatementEo();
            statementEo.setBalanceAccountId(accountEo.getId());
            statementEo.setActivityId(accountEo.getActivityId());
            statementEo.setCustomerId(accountEo.getCustomerId());
            statementEo.setCustomerCode(accountEo.getCustomerCode());
            statementEo.setCustomerName(accountEo.getCustomerName());
            statementEo.setOrderNo(advanceEo.getAdvanceNo());
            statementEo.setOrganizationId(accountEo.getOrganizationId());
            statementEo.setChangeType(ExchangeStatementChangeTypeEnum.ADVANCE_GRANT.getType());
            statementEo.setOldBalance(oldBalance);
            statementEo.setChangeBalance(advanceEo.getAdvanceAmount());
            statementEo.setNewBalance(availableBalance);
            statementEo.setBalanceType(ExchangeBalanceTypeEnum.ADVANCE.getKey());
            this.exchangeBalanceStatementDas.insert((BaseEo)statementEo);
        }
        this.exchangeBalanceAdvanceDas.updateSelective((BaseEo)advanceUpdateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void back(String advanceNo) {
        log.info("\u5f00\u59cb\u9884\u652f\u989d\u5ea6\u5f52\u8fd8\uff1a{}", (Object)advanceNo);
        Date now = new Date();
        ExchangeBalanceAdvanceEo exchangeBalanceAdvanceEo = new ExchangeBalanceAdvanceEo();
        exchangeBalanceAdvanceEo.setAdvanceNo(advanceNo);
        ExchangeBalanceAdvanceEo advanceEo = (ExchangeBalanceAdvanceEo)this.exchangeBalanceAdvanceDas.selectOne((BaseEo)exchangeBalanceAdvanceEo);
        AssertUtils.notNull(advanceEo, "\u989d\u5ea6\u9884\u652f\u5355\u4e0d\u5b58\u5728\uff0c\u5f52\u8fd8\u5931\u8d25");
        AssertUtils.isTrue(ExchangeAdvanceStatusEnum.WAIT_RETURN.getStatus().equals(advanceEo.getStatus()), "\u5f85\u5f52\u8fd8\u9884\u652f\u5355\u624d\u5141\u8bb8\u5f52\u8fd8");
        AssertUtils.isTrue(advanceEo.getAdvanceSendBackTime().before(now), "\u672a\u5230\u5f52\u8fd8\u65f6\u95f4");
        LambdaQueryWrapper accountWarpper = new LambdaQueryWrapper();
        accountWarpper.eq(BaseEo::getId, (Object)advanceEo.getExchangeAccountId());
        ExchangeBalanceAccountEo accountEo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.getMapper().selectOne((Wrapper)accountWarpper);
        AssertUtils.notNull(accountEo, "\u5f53\u524d\u5ba2\u6237\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u4e0d\u5b58\u5728,\u989d\u5ea6\u5f52\u8fd8\u5931\u8d25");
        ExchangeBalanceAccountEo updateEo = new ExchangeBalanceAccountEo();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)accountEo.getId())).eq((Object)"available_balance", (Object)accountEo.getAvailableBalance());
        updateEo.setAvailableBalance(accountEo.getAvailableBalance().subtract(advanceEo.getAdvanceAmount()));
        int row = this.exchangeBalanceAccountDas.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
        ExchangeBalanceAdvanceEo advanceUpdateEo = new ExchangeBalanceAdvanceEo();
        advanceUpdateEo.setId(advanceEo.getId());
        advanceUpdateEo.setStatus(ExchangeAdvanceStatusEnum.ALREADY_RETURN.getStatus());
        if (row == 0) {
            advanceUpdateEo.setStatus(ExchangeAdvanceStatusEnum.BACK_FAIL.getStatus());
        } else {
            ExchangeBalanceTurnoverEo exchangeBalanceTurnoverEo = new ExchangeBalanceTurnoverEo();
            exchangeBalanceTurnoverEo.setBalanceAccountId(accountEo.getId());
            exchangeBalanceTurnoverEo.setActivityId(accountEo.getActivityId());
            exchangeBalanceTurnoverEo.setCustomerId(accountEo.getCustomerId());
            exchangeBalanceTurnoverEo.setCustomerCode(accountEo.getCustomerCode());
            exchangeBalanceTurnoverEo.setCustomerName(accountEo.getCustomerName());
            exchangeBalanceTurnoverEo.setOrderNo(advanceEo.getAdvanceNo());
            exchangeBalanceTurnoverEo.setChangeType(TurnoverChangeTypeEnum.ADVANCE_BACK.getType());
            exchangeBalanceTurnoverEo.setStatus(Integer.valueOf(0));
            exchangeBalanceTurnoverEo.setOrganizationId(accountEo.getOrganizationId());
            exchangeBalanceTurnoverEo.setOldBalance(accountEo.getAvailableBalance());
            exchangeBalanceTurnoverEo.setChangeBalance(advanceEo.getAdvanceAmount());
            exchangeBalanceTurnoverEo.setNewBalance(updateEo.getAvailableBalance());
            exchangeBalanceTurnoverEo.setOldUsedBalance(accountEo.getUsedBalance());
            exchangeBalanceTurnoverEo.setChangeUsedBalance(accountEo.getUsedBalance());
            exchangeBalanceTurnoverEo.setNewUsedBalance(accountEo.getUsedBalance());
            this.exchangeBalanceTurnoverDas.insert((BaseEo)exchangeBalanceTurnoverEo);
            ExchangeBalanceStatementEo statementEo = new ExchangeBalanceStatementEo();
            statementEo.setBalanceAccountId(accountEo.getId());
            statementEo.setActivityId(accountEo.getActivityId());
            statementEo.setCustomerId(accountEo.getCustomerId());
            statementEo.setCustomerCode(accountEo.getCustomerCode());
            statementEo.setCustomerName(accountEo.getCustomerName());
            statementEo.setOrderNo(advanceEo.getAdvanceNo());
            statementEo.setOrganizationId(accountEo.getOrganizationId());
            statementEo.setChangeType(ExchangeStatementChangeTypeEnum.ADVANCE_BACK.getType());
            statementEo.setOldBalance(accountEo.getAvailableBalance());
            statementEo.setChangeBalance(advanceEo.getAdvanceAmount());
            statementEo.setNewBalance(updateEo.getAvailableBalance());
            this.exchangeBalanceStatementDas.insert((BaseEo)statementEo);
        }
        this.exchangeBalanceAdvanceDas.updateSelective((BaseEo)advanceUpdateEo);
    }

    private void verifyParam(ExchangeBalanceAdvanceReqDto addReqDto) {
        Date now = new Date();
        AssertUtils.notNull(addReqDto.getActivityId(), "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(addReqDto.getCustomerId(), "\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull(addReqDto.getAdvanceAmount(), "\u9884\u652f\u989d\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue(BigDecimal.ZERO.compareTo(addReqDto.getAdvanceAmount()) <= 0, "\u9884\u652f\u989d\u5ea6\u5fc5\u987b\u4f4d\u6b63\u6570");
        AssertUtils.isTrue(addReqDto.getAdvanceAmount().stripTrailingZeros().scale() <= 2, "\u9884\u652f\u989d\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u4e24\u4f4d\u5c0f\u6570");
        AssertUtils.notNull(addReqDto.getAdvanceMode(), "\u989d\u5ea6\u53d1\u653e\u65f6\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue(YesOrNoEnum.YES.getCode().equals(addReqDto.getAdvanceMode()) || addReqDto.getAdvanceGrantTime() != null, "\u5b9a\u65f6\u53d1\u653e\u989d\u5ea6\uff0c\u989d\u5ea6\u53d1\u653e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public void modifyExchangeBalanceAdvance(ExchangeBalanceAdvanceReqDto modifyReqDto) {
        log.info("\u4fee\u6539\u9884\u652f\u989d\u5ea6\u5165\u53c2={}", JSON.toJSON((Object)modifyReqDto));
        ExchangeBalanceAdvanceEo exchangeBalanceAdvanceEo = new ExchangeBalanceAdvanceEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)exchangeBalanceAdvanceEo);
        this.exchangeBalanceAdvanceDas.updateSelective((BaseEo)exchangeBalanceAdvanceEo);
    }

    @Override
    public ExchangeBalanceAdvanceRespDto queryById(Long id) {
        ExchangeBalanceAdvanceEo exchangeBalanceAdvanceEo = (ExchangeBalanceAdvanceEo)((ExtQueryChainWrapper)this.exchangeBalanceAdvanceDas.filter().eq((Object)"id", (Object)id)).one();
        ExchangeBalanceAdvanceRespDto exchangeBalanceAdvanceRespDto = new ExchangeBalanceAdvanceRespDto();
        DtoHelper.eo2Dto((BaseEo)exchangeBalanceAdvanceEo, (BaseVo)exchangeBalanceAdvanceRespDto);
        return exchangeBalanceAdvanceRespDto;
    }

    @Override
    public PageInfo<ExchangeBalanceAdvanceRespDto> queryByPage(ExchangeBalanceAdvanceQueryReqDto queryReqDto) {
        ExchangeBalanceAdvanceEo exchangeBalanceAdvanceEo = new ExchangeBalanceAdvanceEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)exchangeBalanceAdvanceEo, (String[])new String[]{"customerName", "customerCode", "advanceNo"});
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.exchangeBalanceAdvanceDas.filter().setEntity((Object)exchangeBalanceAdvanceEo)).ge(queryReqDto.getAdvanceGrantTimeStart() != null, (Object)"advance_grant_time", (Object)queryReqDto.getAdvanceGrantTimeStart())).le(queryReqDto.getAdvanceGrantTimeEnd() != null, (Object)"advance_grant_time", (Object)queryReqDto.getAdvanceGrantTimeEnd())).ge(queryReqDto.getAdvanceSendBackTimeStart() != null, (Object)"advance_send_back_time", (Object)queryReqDto.getAdvanceSendBackTimeStart())).le(queryReqDto.getAdvanceSendBackTimeEnd() != null, (Object)"advance_send_back_time", (Object)queryReqDto.getAdvanceSendBackTimeEnd())).ge(queryReqDto.getAdvanceTimeStart() != null, (Object)"advance_time", (Object)queryReqDto.getAdvanceTimeStart())).le(queryReqDto.getAdvanceTimeEnd() != null, (Object)"advance_time", (Object)queryReqDto.getAdvanceTimeEnd())).like(StringUtils.isNotBlank((String)queryReqDto.getCustomerName()), (Object)"customer_name", (Object)queryReqDto.getCustomerName())).like(StringUtils.isNotBlank((String)queryReqDto.getCustomerCode()), (Object)"customer_code", (Object)queryReqDto.getCustomerCode())).like(StringUtils.isNotBlank((String)queryReqDto.getAdvanceNo()), (Object)"advance_no", (Object)queryReqDto.getAdvanceNo())).orderByDesc((Object)"create_time")).page(queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ExchangeBalanceAdvanceRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ExchangeBalanceAdvanceRespDto> queryList(ExchangeBalanceAdvanceQueryReqDto queryReqDto) {
        ExchangeBalanceAdvanceEo exchangeBalanceAdvanceEo = new ExchangeBalanceAdvanceEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)exchangeBalanceAdvanceEo, (String[])new String[]{"customerName", "customerCode", "advanceNo"});
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)exchangeBalanceAdvanceEo);
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.ge(queryReqDto.getAdvanceGrantTimeStart() != null, ExchangeBalanceAdvanceEo::getAdvanceGrantTime, (Object)queryReqDto.getAdvanceGrantTimeStart())).le(queryReqDto.getAdvanceGrantTimeEnd() != null, ExchangeBalanceAdvanceEo::getAdvanceGrantTime, (Object)queryReqDto.getAdvanceGrantTimeEnd())).ge(queryReqDto.getAdvanceSendBackTimeStart() != null, ExchangeBalanceAdvanceEo::getAdvanceSendBackTime, (Object)queryReqDto.getAdvanceSendBackTimeStart())).le(queryReqDto.getAdvanceSendBackTimeEnd() != null, ExchangeBalanceAdvanceEo::getAdvanceSendBackTime, (Object)queryReqDto.getAdvanceSendBackTimeEnd())).ge(queryReqDto.getAdvanceTimeStart() != null, ExchangeBalanceAdvanceEo::getAdvanceTime, (Object)queryReqDto.getAdvanceTimeStart())).le(queryReqDto.getAdvanceTimeEnd() != null, ExchangeBalanceAdvanceEo::getAdvanceTime, (Object)queryReqDto.getAdvanceTimeEnd())).like(StringUtils.isNotBlank((String)queryReqDto.getCustomerName()), ExchangeBalanceAdvanceEo::getCustomerName, (Object)queryReqDto.getCustomerName())).like(StringUtils.isNotBlank((String)queryReqDto.getCustomerCode()), ExchangeBalanceAdvanceEo::getCustomerCode, (Object)queryReqDto.getCustomerCode())).like(StringUtils.isNotBlank((String)queryReqDto.getAdvanceNo()), ExchangeBalanceAdvanceEo::getAdvanceNo, (Object)queryReqDto.getAdvanceNo());
        List exchangeBalanceAdvanceEos = this.exchangeBalanceAdvanceDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<ExchangeBalanceAdvanceRespDto> dtoList = new ArrayList<ExchangeBalanceAdvanceRespDto>();
        DtoHelper.eoList2DtoList((Collection)exchangeBalanceAdvanceEos, dtoList, ExchangeBalanceAdvanceRespDto.class);
        return dtoList;
    }

    @Override
    public List<ExchangeBalanceAdvanceRespDto> queryActivityIdAndCustomerId(List<Long> activityIdList, Long customerId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ExchangeBalanceAdvanceEo::getActivityId, activityIdList);
        queryWrapper.eq(ExchangeBalanceAdvanceEo::getCustomerId, (Object)customerId);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        List exchangeBalanceAdvanceEos = this.exchangeBalanceAdvanceDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<ExchangeBalanceAdvanceRespDto> dtoList = new ArrayList<ExchangeBalanceAdvanceRespDto>();
        DtoHelper.eoList2DtoList((Collection)exchangeBalanceAdvanceEos, dtoList, ExchangeBalanceAdvanceRespDto.class);
        return dtoList;
    }
}

