/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BranchQueryItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BranchItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.EngineActivityTypeEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.EngineActivityTypeTobEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.EngineBizParamsDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.EngineItemBizParamsDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityBizExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.EngineActivityBizReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.ExchangeRuleContent;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ActivityListBizExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ExcActivityExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.PreviewActivityExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.PreviewCouponExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.PromotionActivityExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IActivityBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IEngineBizService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IExtlItemService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ExchangeActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PreviewActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ValidType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.SimpleCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ExchangeBalanceTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActivityEngineClient;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BigDecimalUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceStatementDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceTurnoverDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceTurnoverEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EngineBizServiceImpl
implements IEngineBizService {
    private static final Logger log = LoggerFactory.getLogger(EngineBizServiceImpl.class);
    @Autowired
    private ActivityEngineClient client;
    @Autowired
    private IActivityPreviewService activityPreviewService;
    @Autowired
    private IExtlItemService extlItemService;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private ExternalApiHelp externalApiHelp;
    @Resource
    private IExchangeBalanceAccountService exchangeBalanceAccountService;
    @Resource
    private IActivityBizExtService activityBizExtService;
    @Resource
    private ExchangeBalanceStatementDas exchangeBalanceStatementDas;
    @Resource
    private ExchangeBalanceTurnoverDas exchangeBalanceTurnoverDas;

    @Override
    public EngineParams promotionExecute(EngineBizParamsDto dto) {
        String checkPoint = StringUtils.isEmpty((CharSequence)dto.getCheckPoint()) ? "REVIEW_ACTIVITY" : dto.getCheckPoint();
        dto.setPreviewActivity(Boolean.valueOf(true));
        if (Objects.isNull(dto.getCustomerId())) {
            AssertUtils.notEmpty(dto.getThirdPartyId(), "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{dto.getThirdPartyId()}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            dto.setCustomerId(customerRespDtos.get(0).getId());
        }
        List<EngineActivityBizReqDto> activityList = this.getPromotionActivityList(dto);
        this.activityListSort(dto, activityList);
        EngineParams engineParams = this.getPreRequestParam(dto);
        engineParams.setValidType(Objects.isNull(dto.getValidType()) ? ValidType.NO_THROW_EXCEPTION : dto.getValidType());
        log.info("\u4e0d\u629b\u5f02\u5e38\u68c0\u67e5\u70b9\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
        this.client.defineCheckpoint(checkPoint).execute(engineParams);
        return engineParams;
    }

    @Override
    public PreviewActivityExtRespDto previewActivity(EngineBizParamsDto dto) {
        List exchangeActivityRespDtos;
        log.info("\u9884\u89c8\u6d3b\u52a8\u4fe1\u606f-->{}", (Object)JSON.toJSONString((Object)dto));
        if (Objects.isNull(dto.getCustomerId())) {
            AssertUtils.notEmpty(dto.getThirdPartyId(), "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{dto.getThirdPartyId()}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            dto.setCustomerId(customerRespDtos.get(0).getId());
        }
        ArrayList statusList = Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.ACTIVATE.getKey()});
        if (dto.getActivityStatusEnd().booleanValue()) {
            statusList.add(ActivityStatusEnum.FINISH.getKey());
        }
        PreviewActivityExtRespDto previewActivityExtRespDto = new PreviewActivityExtRespDto();
        String shopCode = dto.getShopCode();
        ActivityBizExtQueryReqDto queryReqDto = new ActivityBizExtQueryReqDto();
        queryReqDto.setShopCode(shopCode);
        queryReqDto.setThirdPartyId(dto.getThirdPartyId());
        queryReqDto.setActivityStatus((List)statusList);
        Optional.ofNullable(dto.getActivity()).map(OrderActivityInfoJoinReqDto::getActivityList).map(r -> r.stream().map(EngineActivityBizReqDto::getActivityId).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((ActivityBizExtQueryReqDto)queryReqDto).setActivityIds(arg_0));
        List selectActivityIds = Optional.ofNullable(queryReqDto.getActivityIds()).orElse(new ArrayList());
        List<ActivityListBizExtRespDto> activityListBizExtRespDtos = this.activityBizExtService.queryExchangeActivityByCustomer(queryReqDto);
        HashMap balanceOrderMap = new HashMap();
        Optional.ofNullable(dto.getOrderNo()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).ifPresent(r -> {
            List exchangeBalanceStatementEos = ((ExtQueryChainWrapper)this.exchangeBalanceTurnoverDas.filter().eq((Object)"order_no", (Object)dto.getOrderNo())).list();
            ArrayList arrayList = Lists.newArrayList((Object[])new String[]{ExchangeBalanceTypeEnum.ADVANCE.getKey()});
            Map<Long, BigDecimal> tempMap = exchangeBalanceStatementEos.stream().filter(d -> arrayList.contains(d.getBalanceType())).collect(Collectors.groupingBy(ExchangeBalanceTurnoverEo::getActivityId, Collectors.mapping(ExchangeBalanceTurnoverEo::getChangeBalance, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            balanceOrderMap.putAll(tempMap);
            Map<Long, BigDecimal> advanceMap = exchangeBalanceStatementEos.stream().filter(d -> arrayList.contains(d.getBalanceType())).collect(Collectors.groupingBy(ExchangeBalanceTurnoverEo::getBalanceAccountId, Collectors.mapping(ExchangeBalanceTurnoverEo::getChangeBalance, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            advanceMap.forEach((k, v) -> ServiceContext.getContext().setAttachment("order_advance_" + k, (v.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : v).toString()));
            Map<Long, BigDecimal> exchangeMap = exchangeBalanceStatementEos.stream().filter(d -> ExchangeBalanceTypeEnum.EXCHANGE.getKey().equals(d.getBalanceType())).collect(Collectors.groupingBy(ExchangeBalanceTurnoverEo::getBalanceAccountId, Collectors.mapping(ExchangeBalanceTurnoverEo::getChangeBalance, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            exchangeMap.forEach((k, v) -> ServiceContext.getContext().setAttachment("order_exchange_" + k, (v.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : v).toString()));
            Map<Long, BigDecimal> freezeMap = exchangeBalanceStatementEos.stream().filter(d -> ExchangeBalanceTypeEnum.FREEZE.getKey().equals(d.getBalanceType())).collect(Collectors.groupingBy(ExchangeBalanceTurnoverEo::getBalanceAccountId, Collectors.mapping(ExchangeBalanceTurnoverEo::getChangeBalance, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> useFreezeMap = exchangeBalanceStatementEos.stream().filter(d -> ExchangeBalanceTypeEnum.ACCUMULATIVE_FREEZE.getKey().equals(d.getBalanceType())).collect(Collectors.groupingBy(ExchangeBalanceTurnoverEo::getBalanceAccountId, Collectors.mapping(ExchangeBalanceTurnoverEo::getChangeBalance, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            log.info("\u67e5\u8be2\u5230\u672c\u5355\u51bb\u7ed3:{}", (Object)JSONObject.toJSONString(freezeMap));
            freezeMap.forEach((k, v) -> ServiceContext.getContext().setAttachment("order_freeze_" + k, BigDecimalUtils.subtract((BigDecimal)v, (BigDecimal)useFreezeMap.getOrDefault(k, BigDecimal.ZERO)).toString()));
            ServiceContext.getContext().setAttachment("hasOrder", "1");
        });
        if (CollectionUtils.isNotEmpty(activityListBizExtRespDtos)) {
            ArrayList activityExtRespDtoListAll = Lists.newArrayList();
            for (ActivityListBizExtRespDto activityListBizExtRespDto : activityListBizExtRespDtos) {
                PromotionActivityExtRespDto promotionActivityExtRespDto = new PromotionActivityExtRespDto();
                CubeBeanUtils.copyProperties((Object)promotionActivityExtRespDto, (Object)activityListBizExtRespDto, (String[])new String[0]);
                promotionActivityExtRespDto.setActivityId(activityListBizExtRespDto.getId());
                this.calAccountInfo(dto, promotionActivityExtRespDto, BigDecimal.ZERO, this.ofBigDecimalZero((BigDecimal)balanceOrderMap.get(activityListBizExtRespDto.getId())));
                activityExtRespDtoListAll.add(promotionActivityExtRespDto);
            }
            previewActivityExtRespDto.setActivityList((List)activityExtRespDtoListAll);
        }
        if (CollectionUtils.isEmpty((Collection)dto.getEngineItemList())) {
            return previewActivityExtRespDto;
        }
        List<EngineActivityBizReqDto> activityList = this.getPromotionActivityList(dto);
        this.activityListSort(dto, activityList);
        EngineParams engineParams = this.getPreRequestParam(dto);
        List itemVos = engineParams.getItems().stream().filter(e -> ExchangeEnum.NO.getType().equals(e.getExchange())).collect(Collectors.toList());
        engineParams.setItems(itemVos);
        engineParams.setValidType(ValidType.NO_THROW_EXCEPTION);
        log.info("\u53ef\u7528\u6d3b\u52a8\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
        PreviewActivityRespDto previewActivityRespDto = this.activityPreviewService.previewActivity(engineParams);
        log.info("\u53ef\u7528\u6d3b\u52a8\u7ed3\u679c\uff1a{}", JSON.toJSON((Object)previewActivityRespDto));
        if (Objects.nonNull(previewActivityRespDto) && CollectionUtils.isNotEmpty((Collection)previewActivityRespDto.getActivityList())) {
            this.client.defineCheckpoint("REVIEW_ACTIVITY").execute(engineParams);
            log.info("\u9884\u89c8\u6d3b\u52a8\u53c2\u6570\uff1a{}", JSON.toJSON((Object)engineParams));
        }
        previewActivityExtRespDto.setExchangeActivityRespDtos(engineParams.getExchangeActivityRespDtos());
        Map<Object, Object> orderGiftBalanceMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)engineParams.getExchangeActivityRespDtos()) && CollectionUtils.isNotEmpty(exchangeActivityRespDtos = engineParams.getExchangeActivityRespDtos().stream().filter(d -> Objects.nonNull(d.getDiscount())).collect(Collectors.toList()))) {
            orderGiftBalanceMap = exchangeActivityRespDtos.stream().collect(Collectors.toMap(ExchangeActivityRespDto::getActivityId, ExchangeActivityRespDto::getDiscount, (k1, k2) -> {
                k1 = this.ofBigDecimalZero((BigDecimal)k1).add(this.ofBigDecimalZero((BigDecimal)k2));
                return k1;
            }));
        }
        if (Objects.nonNull(previewActivityRespDto)) {
            List<Object> activityExtRespDtoList = Lists.newArrayList();
            List<Object> activityIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)previewActivityRespDto.getActivityList())) {
                List promotionActivityList = previewActivityRespDto.getActivityList();
                if (CollectionUtils.isNotEmpty(promotionActivityList = promotionActivityList.stream().filter(r -> CollectionUtils.isEmpty((Collection)selectActivityIds) || selectActivityIds.contains(r.getActivityId())).collect(Collectors.toList()))) {
                    activityIds = promotionActivityList.stream().map(ActivityRespDto::getId).distinct().collect(Collectors.toList());
                    List<ConditionRespDto> conditionRespDtoList = this.activityBizExtService.queryConditions(activityIds, 1196944771412880296L);
                    Map<Long, List<ConditionRespDto>> activityMap = conditionRespDtoList.stream().collect(Collectors.groupingBy(ConditionRespDto::getActivityId));
                    for (PromotionActivityRespDto promotionActivityRespDto : previewActivityRespDto.getActivityList()) {
                        if (CollectionUtils.isNotEmpty((Collection)selectActivityIds) && !selectActivityIds.contains(promotionActivityRespDto.getActivityId())) continue;
                        PromotionActivityExtRespDto promotionActivityExtRespDto = new PromotionActivityExtRespDto();
                        CubeBeanUtils.copyProperties((Object)promotionActivityExtRespDto, (Object)promotionActivityRespDto, (String[])new String[0]);
                        promotionActivityExtRespDto.setActivityId(promotionActivityRespDto.getId());
                        Long activityTemplateId = promotionActivityRespDto.getActivityTemplateId();
                        if (Objects.equals(activityTemplateId, EngineActivityTypeTobEnum.EXCHANGE_ACTIVITY.getCode())) {
                            BigDecimal orderGiftBalance = (BigDecimal)orderGiftBalanceMap.get(promotionActivityRespDto.getActivityId());
                            log.info("\u672c\u5355\u53c2\u4e0e\u6d3b\u52a8 {} \u8d60\u9001\u989d\u5ea6 {}", (Object)promotionActivityRespDto.getActivityId(), (Object)orderGiftBalance);
                            this.setExchangeActivityInfo(dto, activityMap, promotionActivityExtRespDto, orderGiftBalance, this.ofBigDecimalZero((BigDecimal)balanceOrderMap.get(promotionActivityRespDto.getId())));
                        }
                        activityExtRespDtoList.add(promotionActivityExtRespDto);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)previewActivityExtRespDto.getActivityList())) {
                for (PromotionActivityExtRespDto promotionActivityRespDto : previewActivityExtRespDto.getActivityList()) {
                    if (CollectionUtils.isNotEmpty((Collection)activityIds) && activityIds.contains(promotionActivityRespDto.getActivityId()) || CollectionUtils.isNotEmpty((Collection)selectActivityIds) && !selectActivityIds.contains(promotionActivityRespDto.getActivityId())) continue;
                    activityExtRespDtoList.add(promotionActivityRespDto);
                }
            }
            activityExtRespDtoList = activityExtRespDtoList.stream().filter(d -> statusList.contains(d.getActivityStatus())).collect(Collectors.toList());
            previewActivityExtRespDto.setActivityList((List)activityExtRespDtoList);
            ArrayList previewCouponExtRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)previewActivityRespDto.getCouponList())) {
                CubeBeanUtils.copyCollection((Collection)previewCouponExtRespDtoList, (Collection)previewActivityRespDto.getCouponList(), PreviewCouponExtRespDto.class);
            }
            previewActivityExtRespDto.setCouponList((List)previewCouponExtRespDtoList);
            ArrayList excActivityExtRespDtoList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)previewActivityRespDto.getExcActivityList())) {
                CubeBeanUtils.copyCollection((Collection)excActivityExtRespDtoList, (Collection)previewActivityRespDto.getExcActivityList(), ExcActivityExtRespDto.class);
            }
            previewActivityExtRespDto.setExcActivityList((List)excActivityExtRespDtoList);
        }
        return previewActivityExtRespDto;
    }

    private void setExchangeActivityInfo(EngineBizParamsDto dto, Map<Long, List<ConditionRespDto>> activityMap, PromotionActivityExtRespDto activityListBizExtRespDto, BigDecimal orderGiftBalance, BigDecimal advanceNum) {
        this.calAccountInfo(dto, activityListBizExtRespDto, StringUtils.isEmpty((CharSequence)ServiceContext.getContext().getAttachment("hasOrder")) ? orderGiftBalance : BigDecimal.ZERO, advanceNum);
        List<ConditionRespDto> conditionList = activityMap.get(activityListBizExtRespDto.getId());
        if (CollectionUtils.isNotEmpty(conditionList)) {
            ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
            this.activityBizExtService.parse(conditionList.get(0), exchangeActivityDto);
            activityListBizExtRespDto.setExchangeActivityDtos(exchangeActivityDto);
            if (CollectionUtils.isNotEmpty((Collection)exchangeActivityDto.getPromotionContents())) {
                ExchangeRuleContent exchangeRuleContent = (ExchangeRuleContent)exchangeActivityDto.getPromotionContents().get(0);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u6d3b\u52a8\u5546\u54c1\u603b");
                stringBuffer.append(exchangeRuleContent.getUnit() == 1 ? "\u91d1\u989d" : "\u6570\u91cf");
                stringBuffer.append("\u6ee1");
                stringBuffer.append(exchangeRuleContent.getThreshold());
                stringBuffer.append(exchangeRuleContent.getUnit() == 1 ? "\u5143" : "\u4ef6");
                if (Objects.nonNull(exchangeRuleContent.getIsOrderScale()) && Objects.nonNull(exchangeRuleContent.getOrderScale())) {
                    stringBuffer.append("\u4e14\u8ba2\u5355\u91d1\u989d\u6ee1");
                    stringBuffer.append(exchangeRuleContent.getOrderScale());
                    stringBuffer.append("\u5143");
                }
                stringBuffer.append("\uff0c\u9001");
                stringBuffer.append(exchangeRuleContent.getDiscount());
                stringBuffer.append(exchangeRuleContent.getDiscountScale() == 2 ? "%" : "");
                stringBuffer.append(exchangeRuleContent.getDiscountUnit() == 1 ? "\u5143" : "\u4ef6");
                stringBuffer.append("\u6362\u8d2d\u989d\u5ea6;");
                activityListBizExtRespDto.setPromotioncontents(stringBuffer.toString());
            }
        }
    }

    private void calAccountInfo(EngineBizParamsDto dto, PromotionActivityExtRespDto activityListBizExtRespDto, BigDecimal orderGiftBalance, BigDecimal advanceNum) {
        log.info("\u67e5\u8be2\u989d\u5ea6\u8d26\u6237\u5165\u53c2 {} {}", (Object)activityListBizExtRespDto.getId(), (Object)dto.getCustomerId());
        ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = this.exchangeBalanceAccountService.queryByActivityIdAndCustomerIdAndIgnoreOrder(activityListBizExtRespDto.getId(), dto.getCustomerId(), BigDecimal.valueOf(-1L).multiply(advanceNum));
        if (Objects.nonNull(exchangeBalanceAccountRespDto)) {
            log.info("\u67e5\u8be2\u5230\u6362\u8d2d\u989d\u5ea6\u8d26\u6237 {}", (Object)JSON.toJSONString((Object)exchangeBalanceAccountRespDto));
            activityListBizExtRespDto.setExchangeRemaining(exchangeBalanceAccountRespDto.getAvailableBalance());
            activityListBizExtRespDto.setExchangeTotal(exchangeBalanceAccountRespDto.getTotalBalance());
            activityListBizExtRespDto.setAdvanceTotal(exchangeBalanceAccountRespDto.getAdvanceTotalBalance());
            activityListBizExtRespDto.setFreeze(exchangeBalanceAccountRespDto.getFreeze());
            activityListBizExtRespDto.setAdvanceRemaining(exchangeBalanceAccountRespDto.getAdvanceSurplusBalance());
            activityListBizExtRespDto.setTotalAvailableBalance(exchangeBalanceAccountRespDto.getTotalAvailableBalance());
            activityListBizExtRespDto.setAdvanceReturn(exchangeBalanceAccountRespDto.isAdvanceReturn());
            activityListBizExtRespDto.setDiscountUnit(exchangeBalanceAccountRespDto.getDiscountUnit());
            activityListBizExtRespDto.setDiscountUnitName(exchangeBalanceAccountRespDto.getDiscountUnitName());
            activityListBizExtRespDto.setPreviewAvailableBalance(this.setPreviewExtDto(exchangeBalanceAccountRespDto, orderGiftBalance));
        } else {
            log.info("\u67e5\u8be2\u4e0d\u5230\u989d\u5ea6\u8d26\u6237 {}", (Object)activityListBizExtRespDto.getId());
            activityListBizExtRespDto.setExchangeRemaining(BigDecimal.ZERO);
            activityListBizExtRespDto.setExchangeTotal(BigDecimal.ZERO);
            activityListBizExtRespDto.setAdvanceTotal(BigDecimal.ZERO);
            activityListBizExtRespDto.setAdvanceRemaining(BigDecimal.ZERO);
            activityListBizExtRespDto.setTotalAvailableBalance(BigDecimal.ZERO);
            activityListBizExtRespDto.setFreeze(BigDecimal.ZERO);
            activityListBizExtRespDto.setAdvanceReturn(false);
            activityListBizExtRespDto.setDiscountUnit(null);
            activityListBizExtRespDto.setDiscountUnitName(null);
            activityListBizExtRespDto.setPreviewAvailableBalance(this.ofBigDecimalZero(orderGiftBalance));
        }
    }

    private BigDecimal setPreviewExtDto(ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto, BigDecimal orderBalance) {
        log.info("\u8d26\u6237\u53ef\u7528\u989d\u5ea6 {} \u672c\u5355\u8d60\u9001\u989d\u5ea6 {} {}", new Object[]{exchangeBalanceAccountRespDto.getTotalAvailableBalance(), orderBalance, exchangeBalanceAccountRespDto.getId()});
        BigDecimal totalAvailableBalance = this.ofBigDecimalZero(exchangeBalanceAccountRespDto.getTotalAvailableBalance()).add(this.ofBigDecimalZero(orderBalance));
        return this.ofBigDecimalZero(totalAvailableBalance);
    }

    private BigDecimal ofBigDecimalZero(BigDecimal num) {
        return Objects.isNull(num) ? BigDecimal.ZERO : num;
    }

    public List<EngineActivityBizReqDto> convertOrderActivityInfoReqDtos(EngineBizParamsDto dto) {
        List activityList = dto.getActivity().getActivityList();
        if (CollectionUtils.isEmpty((Collection)activityList)) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Long> set = new HashSet<Long>();
        ArrayList<EngineActivityBizReqDto> newActivityList = new ArrayList<EngineActivityBizReqDto>(activityList.size());
        for (EngineActivityBizReqDto activityBizReqDto : activityList) {
            if (CollectionUtils.isNotEmpty((Collection)activityBizReqDto.getCouponIds())) {
                newActivityList.add(activityBizReqDto);
                List couponIds = dto.getCouponIdsMap().computeIfAbsent(activityBizReqDto.getActivityId().toString(), k -> Lists.newArrayList());
                couponIds.add(Long.valueOf((String)activityBizReqDto.getCouponIds().get(0)));
                continue;
            }
            if (!set.add(activityBizReqDto.getActivityId())) continue;
            newActivityList.add(activityBizReqDto);
            if (activityBizReqDto.getType() != null && activityBizReqDto.getType() != 6) continue;
            dto.getItemActivityIds().add(activityBizReqDto.getActivityId());
        }
        return newActivityList.stream().map(orderActivityBizReqDto -> {
            EngineActivityBizReqDto orderActivityInfoReqDto = new EngineActivityBizReqDto();
            orderActivityInfoReqDto.setType(orderActivityBizReqDto.getType());
            if (orderActivityBizReqDto.getActivityGroupId() != null) {
                orderActivityInfoReqDto.setType(Integer.valueOf(1));
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(orderActivityBizReqDto.getActivityGroupId().toString());
                orderActivityInfoReqDto.setActivityItemIds(list);
            }
            if (CollectionUtils.isNotEmpty((Collection)orderActivityBizReqDto.getCouponIds())) {
                orderActivityInfoReqDto.setType(ActivityConstant.COUPON_ACTIVITY);
                orderActivityInfoReqDto.setActivityItemIds(orderActivityBizReqDto.getCouponIds());
            }
            orderActivityInfoReqDto.setActivityId(orderActivityBizReqDto.getActivityId());
            return orderActivityInfoReqDto;
        }).collect(Collectors.toList());
    }

    private void activityListSort(EngineBizParamsDto dto, List<EngineActivityBizReqDto> activityList) {
        if (dto.getActivity() == null) {
            OrderActivityInfoJoinReqDto orderJoinActivityBizReqDto = new OrderActivityInfoJoinReqDto();
            orderJoinActivityBizReqDto.setActivityList(new ArrayList());
            dto.setActivity(orderJoinActivityBizReqDto);
        } else {
            List oldActivityList = dto.getActivity().getActivityList();
            if (CollectionUtils.isNotEmpty((Collection)oldActivityList)) {
                ArrayList newList = Lists.newArrayList();
                for (EngineActivityBizReqDto oldDto : oldActivityList) {
                    if (EngineActivityTypeEnum.PROMOTION.getCode().equals(oldDto.getType()) || EngineActivityTypeEnum.COUPON.getCode().equals(oldDto.getType()) || EngineActivityTypeTobEnum.SECKILL_TOB_ACTIVITY.getName().equals(oldDto.getActivityType())) continue;
                    oldDto.setSort(EngineActivityTypeTobEnum.getSortByName((String)oldDto.getActivityType()).intValue());
                    newList.add(oldDto);
                }
                dto.getActivity().setActivityList((List)newList);
            }
        }
        if (CollectionUtils.isNotEmpty(activityList)) {
            dto.getActivity().getActivityList().addAll(activityList);
        }
        log.info("\u9884\u89c8\u63a5\u53e3\u6d3b\u52a8\u6392\u5e8f\u524d\uff1a{}", (Object)JSON.toJSONString((Object)dto.getActivity().getActivityList()));
        if (CollectionUtils.isNotEmpty((Collection)dto.getActivity().getActivityList())) {
            List activitySortedList = dto.getActivity().getActivityList().stream().filter(e -> !EngineActivityTypeTobEnum.SECKILL_TOB_ACTIVITY.getName().equals(e.getActivityType())).sorted(Comparator.comparing(EngineActivityBizReqDto::getSort).reversed()).collect(Collectors.toList());
            dto.getActivity().setActivityList(activitySortedList);
        }
        log.info("\u9884\u89c8\u63a5\u53e3\u6d3b\u52a8\u6392\u5e8f\u540e\uff1a{}", (Object)JSON.toJSONString((Object)dto.getActivity().getActivityList()));
        this.clearCombinationActivity(dto);
        log.info("\u8fc7\u6ee4\u6389\u5355\u4e70\u7684\u4f18\u60e0\u5957\u88c5\u5546\u54c1\u540e\uff1a{}", (Object)JSON.toJSONString((Object)dto.getActivity().getActivityList()));
        if (dto.getActivity() != null && CollectionUtils.isNotEmpty((Collection)dto.getActivity().getActivityList())) {
            OrderActivityInfoJoinReqDto activity = new OrderActivityInfoJoinReqDto();
            List<EngineActivityBizReqDto> newActivityList = this.convertOrderActivityInfoReqDtos(dto);
            activity.setActivityList(newActivityList);
            dto.setActivity(activity);
        }
    }

    public <T extends EngineParams> void clearCombinationActivity(EngineBizParamsDto engineBizParamsDto) {
        List activityList = engineBizParamsDto.getActivity().getActivityList();
        Map<Long, EngineActivityBizReqDto> activityMap = activityList.stream().collect(Collectors.toMap(EngineActivityBizReqDto::getActivityId, activity -> activity, (e1, e2) -> e1));
        List activitys = activityList.stream().map(EngineActivityBizReqDto::getActivityId).collect(Collectors.toList());
        List allCombinationIds = activityList.stream().filter(activity -> EngineActivityTypeTobEnum.COMBINATION_ACTIVITY.getName().equals(activity.getActivityType())).map(EngineActivityBizReqDto::getActivityId).collect(Collectors.toList());
        List itemCombinationIds = engineBizParamsDto.getEngineItemList().stream().filter(dto -> dto.getIsCombinedPackage() == 1).map(EngineItemBizParamsDto::getCombinedPackageActivityId).distinct().collect(Collectors.toList());
        ArrayList newActivityList = Lists.newArrayList();
        for (Long activityId : activitys) {
            if (allCombinationIds.contains(activityId) && !itemCombinationIds.contains(activityId)) continue;
            newActivityList.add(activityMap.get(activityId));
        }
        engineBizParamsDto.getActivity().setActivityList((List)newActivityList);
    }

    private List<EngineActivityBizReqDto> getPromotionActivityList(EngineBizParamsDto dto) {
        List<ItemRespDto> itemRespDtos;
        List<ItemSkuRespDto> itemSkuRespDtoList;
        List<ShopDto> shopDtoList;
        List engineItemList = dto.getEngineItemList();
        Set shopCodeSet = engineItemList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getShopCode())).map(EngineItemBizParamsDto::getShopCode).collect(Collectors.toSet());
        Set skuCodeSet = engineItemList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getSkuCode())).map(EngineItemBizParamsDto::getSkuCode).collect(Collectors.toSet());
        Set itemCodeSet = engineItemList.stream().filter(d -> StringUtils.isNotEmpty((CharSequence)d.getItemCode())).map(EngineItemBizParamsDto::getItemCode).collect(Collectors.toSet());
        Map<Object, Object> shopMap = new HashMap();
        Map<Object, Object> itemSkuMap = new HashMap();
        Map<Object, Object> itemMap = new HashMap();
        if (CollectionUtils.isNotEmpty(shopCodeSet) && CollectionUtils.isNotEmpty(shopDtoList = this.externalApiHelp.getShopByCodes(new ArrayList<String>(shopCodeSet)))) {
            shopMap = shopDtoList.stream().collect(Collectors.toMap(ShopDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtils.isNotEmpty(skuCodeSet) && CollectionUtils.isNotEmpty(itemSkuRespDtoList = this.externalApiHelp.getItemSkuCodes(new ArrayList<String>(skuCodeSet)))) {
            itemSkuMap = itemSkuRespDtoList.stream().collect(Collectors.toMap(ItemSkuRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtils.isNotEmpty(itemCodeSet) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(new ArrayList<String>(itemCodeSet)))) {
            itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList itemIds = Lists.newArrayList();
        HashSet<Long> shopIdSet = new HashSet<Long>();
        ArrayList dimensionList = Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.COUPON.getKey(), ActivityDimensionEnum.ITEM.getKey()});
        for (EngineItemBizParamsDto itemBizParamsDto : engineItemList) {
            if (!ExchangeEnum.NO.getType().equals(itemBizParamsDto.getExchange())) continue;
            if (!shopMap.containsKey(itemBizParamsDto.getShopCode())) {
                throw new BizException("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728" + itemBizParamsDto.getShopCode());
            }
            itemBizParamsDto.setShopId(((ShopDto)shopMap.get(itemBizParamsDto.getShopCode())).getId());
            shopIdSet.add(itemBizParamsDto.getShopId());
            if (!itemMap.containsKey(itemBizParamsDto.getItemCode())) {
                throw new BizException("\u5546\u54c1item\u4fe1\u606f\u4e0d\u5b58\u5728" + itemBizParamsDto.getItemCode());
            }
            ItemRespDto itemRespDto = (ItemRespDto)itemMap.get(itemBizParamsDto.getItemCode());
            itemBizParamsDto.setItemId(itemRespDto.getId());
            itemBizParamsDto.setItemType(itemRespDto.getType());
            itemBizParamsDto.setBusType(itemRespDto.getBusType());
            itemIds.add(itemBizParamsDto.getItemId());
            if (itemSkuMap.containsKey(itemBizParamsDto.getSkuCode())) {
                itemBizParamsDto.setSkuId(((ItemSkuRespDto)itemSkuMap.get(itemBizParamsDto.getSkuCode())).getId());
                continue;
            }
            throw new BizException("\u5546\u54c1SKU\u4fe1\u606f\u4e0d\u5b58\u5728" + itemBizParamsDto.getSkuCode());
        }
        this.getItemOnShelf(engineItemList);
        ArrayList shopIdsDistinct = new ArrayList(shopIdSet);
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setItemIdList((List)itemIds);
        queryReqDto.setShopIdList(shopIdsDistinct);
        queryReqDto.setDimensionList((List)dimensionList);
        queryReqDto.setCustomerId(dto.getCustomerId());
        Optional.ofNullable(dto.getActivity()).map(OrderActivityInfoJoinReqDto::getActivityList).map(r -> r.stream().map(EngineActivityBizReqDto::getActivityId).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((ItemActivityTagQueryReqDto)queryReqDto).setActivityIdList(arg_0));
        List<EngineActivityBizReqDto> activityBizList = Lists.newArrayList();
        if (Objects.nonNull(dto.getActivity()) && CollectionUtils.isNotEmpty((Collection)dto.getActivity().getActivityList())) {
            activityBizList = dto.getActivity().getActivityList();
        }
        if (dto.getMatchActivity().booleanValue()) {
            EngineActivityBizReqDto activityBizReqDto;
            Long shopId;
            PromotionCouponRespDto promotionCouponRespDto = this.activityPreviewService.queryActivityByItem(queryReqDto);
            List promotionActivityIds = promotionCouponRespDto.getPromotionActivityIds();
            List activityRespDtos = promotionCouponRespDto.getActivityRespDtos();
            List couponList = promotionCouponRespDto.getCouponList();
            Long l = shopId = !CollectionUtils.isEmpty(shopIdsDistinct) && shopIdsDistinct.size() == 1 ? (Long)shopIdsDistinct.get(0) : null;
            if (CollectionUtils.isNotEmpty((Collection)activityRespDtos)) {
                for (ActivityRespDto activityRespDto : activityRespDtos) {
                    activityBizReqDto = new EngineActivityBizReqDto();
                    activityBizReqDto.setActivityId(activityRespDto.getId());
                    activityBizReqDto.setType(EngineActivityTypeEnum.PROMOTION.getCode());
                    EngineActivityTypeTobEnum activityTypeTobEnum = EngineActivityTypeTobEnum.fromCode((Long)activityRespDto.getActivityTemplateId());
                    activityBizReqDto.setActivityType(activityTypeTobEnum != null ? activityTypeTobEnum.getName() : null);
                    activityBizReqDto.setSort(activityTypeTobEnum != null ? activityTypeTobEnum.getSort() : -1);
                    activityBizReqDto.setShopId(shopId);
                    activityBizList.add(activityBizReqDto);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)couponList)) {
                for (SimpleCouponRespDto simpleCouponRespDto : couponList) {
                    activityBizReqDto = new EngineActivityBizReqDto();
                    activityBizReqDto.setActivityId(simpleCouponRespDto.getActivityId());
                    activityBizReqDto.setCouponIds((List)Lists.newArrayList((Object[])new String[]{simpleCouponRespDto.getCouponId().toString()}));
                    activityBizReqDto.setType(EngineActivityTypeEnum.COUPON.getCode());
                    activityBizReqDto.setSort(EngineActivityTypeTobEnum.COUPON_TOB_ACTIVITY.getSort().intValue());
                    activityBizReqDto.setShopId(shopId);
                    activityBizList.add(activityBizReqDto);
                }
            }
        }
        return activityBizList;
    }

    private void getItemOnShelf(List<EngineItemBizParamsDto> engineItemList) {
        List shelfReqDtos = engineItemList.stream().map(orderItemInfoDto -> {
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            shelfReqDto.setBusType(orderItemInfoDto.getBusType());
            shelfReqDto.setItemType(orderItemInfoDto.getItemType());
            shelfReqDto.setItemId(orderItemInfoDto.getItemId());
            shelfReqDto.setShopId(orderItemInfoDto.getShopId());
            shelfReqDto.setSkuId(orderItemInfoDto.getSkuId());
            return shelfReqDto;
        }).collect(Collectors.toList());
        BranchQueryItemReqDto branchQueryItemReqDto = new BranchQueryItemReqDto();
        branchQueryItemReqDto.setShelfItemList(shelfReqDtos);
        BranchItemRespDto branchItemRespDto = (BranchItemRespDto)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.branchQueryItem(branchQueryItemReqDto));
        Map<Object, Object> itemShelfMap = Maps.newHashMap();
        Map<Object, Object> itemDetailMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)branchItemRespDto.getItemShelfList())) {
            itemShelfMap = branchItemRespDto.getItemShelfList().stream().collect(Collectors.toMap(s -> s.getShopId() + "_" + s.getSkuId(), Function.identity(), (k1, k2) -> k1));
        }
        if (CollectionUtils.isNotEmpty((Collection)branchItemRespDto.getItemDetailList())) {
            itemDetailMap = branchItemRespDto.getItemDetailList().stream().collect(Collectors.toMap(s -> s.getItem().getId(), Function.identity(), (k1, k2) -> k1));
        }
        for (EngineItemBizParamsDto item : engineItemList) {
            String key = item.getShopId() + "_" + item.getSkuId();
            if (itemShelfMap.containsKey(key)) {
                ItemShelfRespDto onSelfInfo = (ItemShelfRespDto)itemShelfMap.get(key);
                item.setShelfId(onSelfInfo.getId().toString());
            }
            if (!itemDetailMap.containsKey(item.getItemId())) continue;
            ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)itemDetailMap.get(item.getItemId());
            item.setSellerId(String.valueOf(itemDetailRespDto.getItem().getSellerId()));
            item.setSubType(itemDetailRespDto.getItem().getSubType());
            item.setItemDetail(JSON.toJSONString((Object)itemDetailRespDto));
        }
    }

    private EngineParams getPreRequestParam(EngineBizParamsDto dto) {
        EngineParams engineParams = new EngineParams();
        this.dealJoinActivityByType(engineParams, dto.getActivity());
        engineParams.setUserId(dto.getCustomerId());
        engineParams.setActivityFlag(Boolean.valueOf(true));
        engineParams.setActivityStockFlag(dto.getActivityStockFlag());
        List<ItemVo> itemList = this.changeToItemVoList(dto, 0);
        engineParams.setItems(itemList);
        engineParams.setUseExchangeAccount(dto.isUseExchangeAccount());
        return engineParams;
    }

    private void dealJoinActivityByType(EngineParams engineParams, OrderActivityInfoJoinReqDto orderActivityInfoJoinReqDto) {
        if (null == orderActivityInfoJoinReqDto || CollectionUtils.isEmpty((Collection)orderActivityInfoJoinReqDto.getActivityList())) {
            return;
        }
        List list = orderActivityInfoJoinReqDto.getActivityList().stream().map(orderActivityInfoReqDto -> (long)orderActivityInfoReqDto.getActivityId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        engineParams.setActivityId(((Long)list.get(0)).longValue());
        engineParams.setActivityIds(list);
        for (EngineActivityBizReqDto orderActivityInfoReqDto2 : orderActivityInfoJoinReqDto.getActivityList()) {
            List activityItemIds;
            if (Integer.valueOf(ActivityConstant.COUPON_ACTIVITY).equals(orderActivityInfoReqDto2.getType())) {
                activityItemIds = orderActivityInfoReqDto2.getActivityItemIds();
                if (CollectionUtils.isEmpty((Collection)activityItemIds)) {
                    throw new BizException("\u4f18\u60e0\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List couponIds = activityItemIds.stream().map(activityItemId -> Long.valueOf(activityItemId)).collect(Collectors.toList());
                ActivityCoupon activityCoupon = new ActivityCoupon();
                activityCoupon.setCouponIds(couponIds);
                activityCoupon.setActivityId(orderActivityInfoReqDto2.getActivityId());
                engineParams.getActivityCouponList().add(activityCoupon);
            }
            if (!Integer.valueOf(1).equals(orderActivityInfoReqDto2.getType()) || CollectionUtils.isEmpty((Collection)(activityItemIds = orderActivityInfoReqDto2.getActivityItemIds()))) continue;
            engineParams.getExtendsAttribute().put("activity_group_id", Long.valueOf((String)activityItemIds.get(0)));
        }
    }

    private List<ItemVo> changeToItemVoList(EngineBizParamsDto dto, Integer gift) {
        List<ItemVo> itemList = dto.getEngineItemList().stream().filter(tradeItemReqDto -> tradeItemReqDto.getGift().equals(gift)).map(tradeItemReqDto -> {
            ItemVo itemVo = new ItemVo();
            itemVo.setPrice(Objects.nonNull(tradeItemReqDto.getItemMarketPrice()) ? tradeItemReqDto.getItemMarketPrice() : tradeItemReqDto.getItemPrice());
            itemVo.setOrigPrice(Objects.nonNull(tradeItemReqDto.getItemMarketPrice()) ? tradeItemReqDto.getItemMarketPrice() : tradeItemReqDto.getItemOrigPrice());
            itemVo.setSkuId(tradeItemReqDto.getSkuId() + "");
            itemVo.setNum(tradeItemReqDto.getItemNum().intValue());
            itemVo.setExchange(tradeItemReqDto.getExchange());
            itemVo.setShopId(tradeItemReqDto.getShopId() + "");
            itemVo.setItemId(tradeItemReqDto.getItemId() + "");
            itemVo.setSellerId(tradeItemReqDto.getSellerId());
            itemVo.setShelfId(tradeItemReqDto.getShelfId());
            ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)JSONObject.parseObject((String)tradeItemReqDto.getItemDetail(), ItemDetailRespDto.class);
            ArrayList brands = Lists.newArrayList((Object[])new Long[]{itemDetailRespDto.getItem().getBrandId()});
            itemVo.setItemBrands((List)brands);
            List<Long> dirList = this.extlItemService.getBackAndParentDirIdList(itemDetailRespDto);
            itemVo.setItemCategory(dirList);
            itemVo.setExchangeActivityId(tradeItemReqDto.getExchangeActivityId());
            itemVo.setIsCombinedPackage(tradeItemReqDto.getIsCombinedPackage());
            itemVo.setCombinedPackageActivityId(tradeItemReqDto.getCombinedPackageActivityId());
            return itemVo;
        }).collect(Collectors.toList());
        return itemList;
    }
}

