/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.request.ExchangeAccountImportInfoReqDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IActivityImportService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeStatementChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceAccountDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceStatementDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceTurnoverDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceAccountEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceStatementEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceTurnoverEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityImportServiceImpl
implements IActivityImportService {
    @Resource
    private ExchangeBalanceAccountDas exchangeBalanceAccountDas;
    @Resource
    private ExchangeBalanceStatementDas exchangeBalanceStatementDas;
    @Resource
    private ExchangeBalanceTurnoverDas exchangeBalanceTurnoverDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchImportExchangeAccount(ExchangeAccountImportInfoReqDto exchangeAccountImportInfoReqDto) {
        List customerIds = exchangeAccountImportInfoReqDto.getBalanceAccountReqDtos().stream().map(ExchangeBalanceAccountReqDto::getCustomerId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(ExchangeBalanceAccountEo::getActivityId, (Object)exchangeAccountImportInfoReqDto.getActivityId())).in(ExchangeBalanceAccountEo::getCustomerId, customerIds);
        List exchangeBalanceAccountEos = this.exchangeBalanceAccountDas.getMapper().selectList((Wrapper)wrapper);
        Map accountMap = exchangeBalanceAccountEos.stream().collect(Collectors.toMap(ExchangeBalanceAccountEo::getCustomerId, Function.identity(), (e1, e2) -> e1));
        ArrayList addEos = Lists.newArrayList();
        ArrayList updateEos = Lists.newArrayList();
        ArrayList turnoverEos = Lists.newArrayList();
        ArrayList statementEos = Lists.newArrayList();
        for (ExchangeBalanceAccountReqDto balanceAccountReqDto : exchangeAccountImportInfoReqDto.getBalanceAccountReqDtos()) {
            ExchangeBalanceAccountEo exchangeBalanceAccountEo = (ExchangeBalanceAccountEo)accountMap.get(balanceAccountReqDto.getCustomerId());
            if (exchangeBalanceAccountEo == null) {
                exchangeBalanceAccountEo = new ExchangeBalanceAccountEo();
                BeanUtil.copyProperties((Object)balanceAccountReqDto, (Object)exchangeBalanceAccountEo, (String[])new String[0]);
                addEos.add(exchangeBalanceAccountEo);
                continue;
            }
            ExchangeBalanceAccountEo updateEo = new ExchangeBalanceAccountEo();
            updateEo.setId(exchangeBalanceAccountEo.getId());
            updateEo.setAvailableBalance(exchangeBalanceAccountEo.getAvailableBalance().add(balanceAccountReqDto.getAvailableBalance()));
            updateEo.setUsedBalance(exchangeBalanceAccountEo.getUsedBalance().add(balanceAccountReqDto.getUsedBalance()));
            updateEos.add(updateEo);
            ExchangeBalanceTurnoverEo exchangeBalanceTurnoverEo = new ExchangeBalanceTurnoverEo();
            exchangeBalanceTurnoverEo.setBalanceAccountId(exchangeBalanceAccountEo.getId());
            exchangeBalanceTurnoverEo.setActivityId(exchangeBalanceAccountEo.getActivityId());
            exchangeBalanceTurnoverEo.setCustomerId(exchangeBalanceAccountEo.getCustomerId());
            exchangeBalanceTurnoverEo.setCustomerCode(exchangeBalanceAccountEo.getCustomerCode());
            exchangeBalanceTurnoverEo.setCustomerName(exchangeBalanceAccountEo.getCustomerName());
            exchangeBalanceTurnoverEo.setOrderNo("");
            exchangeBalanceTurnoverEo.setChangeType(TurnoverChangeTypeEnum.IMPORT.getType());
            exchangeBalanceTurnoverEo.setStatus(Integer.valueOf(0));
            exchangeBalanceTurnoverEo.setOrganizationId(exchangeBalanceAccountEo.getOrganizationId());
            exchangeBalanceTurnoverEo.setOldBalance(exchangeBalanceAccountEo.getAvailableBalance());
            exchangeBalanceTurnoverEo.setChangeBalance(balanceAccountReqDto.getAvailableBalance());
            exchangeBalanceTurnoverEo.setNewBalance(balanceAccountReqDto.getAvailableBalance().add(exchangeBalanceAccountEo.getAvailableBalance()));
            exchangeBalanceTurnoverEo.setOldUsedBalance(exchangeBalanceAccountEo.getUsedBalance());
            exchangeBalanceTurnoverEo.setChangeUsedBalance(balanceAccountReqDto.getUsedBalance());
            exchangeBalanceTurnoverEo.setNewUsedBalance(balanceAccountReqDto.getUsedBalance().add(exchangeBalanceAccountEo.getUsedBalance()));
            turnoverEos.add(exchangeBalanceTurnoverEo);
            ExchangeBalanceStatementEo statementEo = new ExchangeBalanceStatementEo();
            statementEo.setBalanceAccountId(exchangeBalanceAccountEo.getId());
            statementEo.setActivityId(exchangeBalanceAccountEo.getActivityId());
            statementEo.setCustomerId(exchangeBalanceAccountEo.getCustomerId());
            statementEo.setCustomerCode(exchangeBalanceAccountEo.getCustomerCode());
            statementEo.setCustomerName(exchangeBalanceAccountEo.getCustomerName());
            statementEo.setOrderNo("");
            statementEo.setOrganizationId(exchangeBalanceAccountEo.getOrganizationId());
            statementEo.setChangeType(ExchangeStatementChangeTypeEnum.IMPORT.getType());
            statementEo.setOldBalance(exchangeBalanceAccountEo.getAvailableBalance());
            statementEo.setChangeBalance(balanceAccountReqDto.getAvailableBalance());
            statementEo.setNewBalance(updateEo.getAvailableBalance());
            statementEo.setRemark("\u6362\u8d2d\u6d3b\u52a8\u989d\u5ea6\u5bfc\u5165\u521d\u59cb\u5316");
            statementEos.add(statementEo);
        }
        if (CollectionUtil.isNotEmpty((Collection)addEos)) {
            this.exchangeBalanceAccountDas.insertBatch((List)addEos);
            for (ExchangeBalanceAccountEo addEo : addEos) {
                ExchangeBalanceTurnoverEo exchangeBalanceTurnoverEo = new ExchangeBalanceTurnoverEo();
                exchangeBalanceTurnoverEo.setBalanceAccountId(addEo.getId());
                exchangeBalanceTurnoverEo.setActivityId(addEo.getActivityId());
                exchangeBalanceTurnoverEo.setCustomerId(addEo.getCustomerId());
                exchangeBalanceTurnoverEo.setCustomerCode(addEo.getCustomerCode());
                exchangeBalanceTurnoverEo.setCustomerName(addEo.getCustomerName());
                exchangeBalanceTurnoverEo.setOrderNo("");
                exchangeBalanceTurnoverEo.setChangeType(TurnoverChangeTypeEnum.IMPORT.getType());
                exchangeBalanceTurnoverEo.setChangeBalance(addEo.getAvailableBalance());
                exchangeBalanceTurnoverEo.setNewBalance(addEo.getAvailableBalance());
                exchangeBalanceTurnoverEo.setChangeUsedBalance(addEo.getUsedBalance());
                exchangeBalanceTurnoverEo.setNewUsedBalance(addEo.getUsedBalance());
                exchangeBalanceTurnoverEo.setStatus(Integer.valueOf(0));
                exchangeBalanceTurnoverEo.setOrganizationId(addEo.getOrganizationId());
                turnoverEos.add(exchangeBalanceTurnoverEo);
                ExchangeBalanceStatementEo statementEo = new ExchangeBalanceStatementEo();
                statementEo.setBalanceAccountId(addEo.getId());
                statementEo.setActivityId(addEo.getActivityId());
                statementEo.setCustomerId(addEo.getCustomerId());
                statementEo.setCustomerCode(addEo.getCustomerCode());
                statementEo.setCustomerName(addEo.getCustomerName());
                statementEo.setOrderNo("");
                statementEo.setOrganizationId(addEo.getOrganizationId());
                statementEo.setChangeType(ExchangeStatementChangeTypeEnum.IMPORT.getType());
                statementEo.setOldBalance(BigDecimal.ZERO);
                statementEo.setChangeBalance(addEo.getAvailableBalance());
                statementEo.setNewBalance(addEo.getAvailableBalance());
                statementEo.setRemark("\u6362\u8d2d\u6d3b\u52a8\u989d\u5ea6\u5bfc\u5165\u521d\u59cb\u5316");
                statementEos.add(statementEo);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)updateEos)) {
            updateEos.stream().sorted((account1, account2) -> account1.getId() - account2.getId() == 0L ? 0 : 1).forEach(account -> {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"id", (Object)account.getId());
                int row = this.exchangeBalanceAccountDas.getMapper().update(account, (Wrapper)updateWrapper);
                if (row != 1) {
                    throw new BizException("\u66f4\u65b0\u8d26\u6237\u5931\u8d25");
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)turnoverEos)) {
            this.exchangeBalanceTurnoverDas.insertBatch((List)turnoverEos);
        }
        if (CollectionUtil.isNotEmpty((Collection)statementEos)) {
            this.exchangeBalanceStatementDas.insertBatch((List)statementEos);
        }
    }
}

