/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IExtlItemService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class IExtlItemServiceImpl
implements IExtlItemService {
    @Resource
    private IDirectoryQueryApi directoryQueryApi;

    @Override
    public List<Long> getFrontAndParentDirIdList(ItemDetailRespDto itemDetailRespDto) {
        List dirList = null;
        if (CollectionUtils.isNotEmpty((Collection)itemDetailRespDto.getItemAttributesList())) {
            try {
                JSONObject jsonObject = JSON.parseObject((String)((ItemAttributesRespDto)itemDetailRespDto.getItemAttributesList().get(0)).getAttrs());
                dirList = JSON.parseArray((String)jsonObject.getString("frontDirList"), Long.class);
            }
            catch (Exception e) {
                throw new BizException("\u524d\u53f0\u7c7b\u76ee\u89e3\u6790\u9519\u8bef");
            }
        }
        ArrayList allDirList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dirList)) {
            for (Long dirId : dirList) {
                List<Long> parentIdList = this.getDirListParent(dirId);
                if (!CollectionUtils.isNotEmpty(parentIdList)) continue;
                allDirList.addAll(parentIdList);
            }
        }
        return allDirList;
    }

    @Override
    public List<Long> getBackAndParentDirIdList(ItemDetailRespDto itemDetailRespDto) {
        Long dirId;
        List<Long> parentIdList;
        ArrayList allDirList = Lists.newArrayList();
        if (Objects.nonNull(itemDetailRespDto.getItem()) && CollectionUtils.isNotEmpty(parentIdList = this.getDirListParent(dirId = itemDetailRespDto.getItem().getDirId()))) {
            allDirList.addAll(parentIdList);
        }
        return allDirList;
    }

    public Map<Long, String> getDirParent(Long dirId) {
        DirectoryItemRespDto directoryRespDto;
        Long reqParam = dirId;
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        Long parentId = -1L;
        while (parentId != null && parentId != 0L && !Objects.isNull(directoryRespDto = (DirectoryItemRespDto)this.directoryQueryApi.queryDirById(reqParam).getData()) && (parentId = directoryRespDto.getParentId()) != 0L) {
            resultMap.put(directoryRespDto.getId(), directoryRespDto.getName());
            reqParam = parentId;
        }
        return resultMap;
    }

    public List<Long> getDirListParent(Long dirId) {
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        Map<Long, String> dirMap = this.getDirParent(dirId);
        for (Map.Entry<Long, String> entry : dirMap.entrySet()) {
            dirIdList.add(entry.getKey());
        }
        Collections.reverse(dirIdList);
        return dirIdList;
    }
}

