/*
 * Decompiled with CFR 0.152.
 */
package com.yx.demo.center.promotion.biz.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPoiExportUtil {
    private static final Logger logger = LoggerFactory.getLogger(EasyPoiExportUtil.class);
    private static IObjectStorageService objectStorageService;
    private static String bucketName;
    private static String dir;

    public static <T> ExcelImportResult<T> importExcel(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setNeedVerfiy(true);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790excel\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessRuntimeException(e.getMessage());
        }
        return result;
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setKeyIndex(null);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage());
        }
        return result;
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Integer count, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setReadRows(count.intValue());
        params.setKeyIndex(null);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
        }
        catch (NoSuchElementException e) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception e) {
            throw new BusinessRuntimeException(e.getMessage());
        }
        return result;
    }

    public static <T> String getExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, String suffix) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        ExportParams params = new ExportParams(title, "", ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, tClass, (Collection)excelRespDtos);
        String url = EasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        return url;
    }

    public static <T> String exportByTemplate(String templateUrl, List<T> excelRespDtos, String excelName, String suffix, String title) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        TemplateExportParams params = new TemplateExportParams(templateUrl, new Integer[0]);
        HashMap map = new HashMap();
        ArrayList listMap = new ArrayList();
        excelRespDtos.forEach(dto -> {
            try {
                Map describe = BeanUtils.describe((Object)dto);
                listMap.add(describe);
            }
            catch (Exception e) {
                logger.error("\u5bf9\u8c61\u8f6c\u6362\u6210map\u5f02\u5e38");
                e.printStackTrace();
            }
        });
        map.put("maplist", listMap);
        Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
        String url = "";
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        url = EasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        return url;
    }

    public static String exportByMap(String fileName, ExportParams params, List<ExcelExportEntity> entityList, List<Map<String, Object>> list) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, entityList, list);
        return EasyPoiExportUtil.getFileUrl(fileName, downloadUrl, workbook, null, fileName);
    }

    private static String getFileUrl(String title, String downloadUrl, Workbook workbook, ByteArrayOutputStream fos, String fileName) {
        String url;
        if (dir == null) {
            dir = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.dir");
        }
        try {
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            objectStorageService.put(bucketName, fileName, (InputStream)byteArrayInputStream);
            url = downloadUrl + "/" + dir + fileName;
        }
        catch (IOException e) {
            logger.error(title + "\u5bfc\u51faexcel\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        return url;
    }

    public static String createFileUrl(String excelName, String suffix) {
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        String fileName = excelName + "." + suffix;
        return downloadUrl + "/" + fileName;
    }

    public static Boolean checkExists(String fileName) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        return objectStorageService.exists(bucketName, fileName);
    }
}

