/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.CouponTemplateBizExtReqDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.ICouponTemplateBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponTemplateBizExtServiceImpl
implements ICouponTemplateBizExtService {
    private static final Logger log = LoggerFactory.getLogger(CouponTemplateBizExtServiceImpl.class);
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private IContext context;

    @Override
    public List<CouponTemplateExtRespDto> queryByActivityIds(CouponTemplateBizExtReqDto reqDto) {
        AssertUtils.notEmpty(reqDto.getActivityIds(), "\u6d3b\u52a8id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.le((String)"receive_start_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date())));
        sqlFilterList.add(SqlFilter.ge((String)"receive_end_time", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date())));
        sqlFilterList.add(SqlFilter.in((String)"activityId", (Object)reqDto.getActivityIds()));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_type", (Object)CouponTypeEnum.COUPON.getType()));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_template_status", (Object)CouponTemplateStatusEnum.ACTIVATE.getStatus()));
        sqlFilterList.add(SqlFilter.in((String)"coupon_category", (Object)Lists.newArrayList((Object[])new Integer[]{CouponCategoryEnum.QUOTA_CASH.getCategory(), CouponCategoryEnum.DISCOUNT.getCategory()})));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        if (Objects.nonNull(reqDto.getCurrentUserOrgId())) {
            criteria.setFields((List)Lists.newArrayList((Object[])new String[]{reqDto.getCurrentUserOrgId().toString()}));
        }
        PageInfo pageInfoList = this.couponTemplateExtQueryService.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(reqDto.getActivityIds().size()));
        return pageInfoList.getList();
    }
}

