/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CustomerDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.rebate.api.dto.request.AddReturnsAdvanceQuotaReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.AddReturnsQuotaDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReduceReturnsQuotaDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsDictGroupRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaDetailRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaExportDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaRespDto;
import com.yx.tcbj.center.rebate.api.enums.ReturnsQuotaBusinessTypeEnum;
import com.yx.tcbj.center.rebate.biz.enums.ReturnsQuotaChangeTypeEnum;
import com.yx.tcbj.center.rebate.biz.enums.ReturnsQuotaTypeEnum;
import com.yx.tcbj.center.rebate.biz.excel.ExcelService;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaAccountService;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaService;
import com.yx.tcbj.center.rebate.biz.utils.BeanUtil;
import com.yx.tcbj.center.rebate.biz.utils.EasyPoiExportUtil;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaAccountDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaConfigGeneralDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaConfigSpecialDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaDetailDas;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaAccountEo;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaDetailEo;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaEo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReturnsQuotaServiceImpl
implements IReturnsQuotaService {
    private static final Logger logger = LoggerFactory.getLogger(ReturnsQuotaServiceImpl.class);
    @Resource
    private ReturnsQuotaAccountDas returnsQuotaAccountDas;
    @Resource
    private ReturnsQuotaDas returnsQuotaDas;
    @Resource
    private ReturnsQuotaDetailDas returnsQuotaDetailDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ExcelService excelService;
    @Resource
    private ReturnsQuotaConfigSpecialDas returnsQuotaConfigSpecialDas;
    @Resource
    private ReturnsQuotaConfigGeneralDas returnsQuotaConfigGeneralDas;
    @Resource
    private IReturnsQuotaAccountService returnsQuotaAccountService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILockService lockService;

    @Override
    public ReturnsQuotaRespDto queryById(Long id) {
        RestResponse customerRespDto;
        ReturnsQuotaEo returnsQuotaEo = (ReturnsQuotaEo)this.returnsQuotaDas.selectByPrimaryKey(id);
        ReturnsQuotaRespDto returnsQuotaRespDto = new ReturnsQuotaRespDto();
        DtoHelper.eo2Dto((BaseEo)returnsQuotaEo, (BaseVo)returnsQuotaRespDto);
        ReturnsQuotaAccountEo accountEo = (ReturnsQuotaAccountEo)this.returnsQuotaAccountDas.selectByPrimaryKey(returnsQuotaRespDto.getReturnsQuotaAccountId());
        if (accountEo != null) {
            returnsQuotaRespDto.setGeneralReturnsQuota(accountEo.getGeneralReturnsQuota());
            returnsQuotaRespDto.setAdvanceQuota(accountEo.getAdvanceQuota());
            returnsQuotaRespDto.setAdvanceUnbackQuota(accountEo.getAdvanceUnbackQuota());
            BigDecimal generalReturnsQuota = accountEo.getGeneralReturnsQuota() == null ? new BigDecimal("0") : accountEo.getGeneralReturnsQuota();
            BigDecimal advanceQuota = accountEo.getAdvanceQuota() == null ? new BigDecimal("0") : accountEo.getAdvanceQuota();
            returnsQuotaRespDto.setCurrentUsableQuota(generalReturnsQuota.add(advanceQuota));
        }
        if (ObjectUtil.isNotEmpty((Object)(customerRespDto = this.customerQueryApi.queryById(returnsQuotaRespDto.getCustomerId())))) {
            returnsQuotaRespDto.setCustomerName(((CustomerRespDto)customerRespDto.getData()).getName());
            returnsQuotaRespDto.setCustomerTypeName(((CustomerRespDto)customerRespDto.getData()).getCustomerTypeName());
            returnsQuotaRespDto.setCustomerCode(((CustomerRespDto)customerRespDto.getData()).getCode());
            returnsQuotaRespDto.setRegionName(((CustomerRespDto)customerRespDto.getData()).getRegionNames());
        }
        PageInfo<ReturnsQuotaDetailRespDto> pageInfo = this.quotaDetailPage(null, 1, 10, id);
        returnsQuotaRespDto.setDetailPageInfo(pageInfo);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        returnsQuotaRespDto.setYearDateStr(formatter.format(returnsQuotaRespDto.getStartDate()));
        return returnsQuotaRespDto;
    }

    @Override
    public PageInfo<ReturnsQuotaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        Map map = StringUtils.isNotEmpty((CharSequence)filter) ? (Map)JSON.parseObject((String)filter, Map.class) : new HashMap();
        map.put("auditStatus", AuditStatusEnum.AUDIT_PASS.getCode());
        map.put("type", 3);
        map.put("channel", 2);
        filter = JSON.toJSONString(map);
        RestResponse pageInfoRestResponse = this.customerExtQueryApi.queryByPage(filter, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfoRestResponse.getData(), (String[])new String[]{"list", "navigatepageNums"});
        List customerIds = ((PageInfo)pageInfoRestResponse.getData()).getList().stream().map(BaseRespDto::getId).collect(Collectors.toList());
        ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
        ArrayList<SqlFilter> yearSqlFilters = new ArrayList<SqlFilter>();
        yearSqlFilters.add(SqlFilter.in((String)"customerId", customerIds));
        yearSqlFilters.add(SqlFilter.eq((String)"status", (Object)1));
        returnsQuotaEo.setSqlFilters(yearSqlFilters);
        List returnsQuotaEoList = this.returnsQuotaDas.select((BaseEo)returnsQuotaEo);
        Integer defId = 0;
        ArrayList<ReturnsQuotaRespDto> dtoList = new ArrayList<ReturnsQuotaRespDto>();
        if (ObjectUtil.isNotEmpty((Object)pageInfoRestResponse.getData()) && CollectionUtil.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            for (CustomerRespDto customer : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                ReturnsQuotaRespDto dto = new ReturnsQuotaRespDto();
                for (ReturnsQuotaEo eo : returnsQuotaEoList) {
                    if (customer.getId().longValue() != eo.getCustomerId().longValue()) continue;
                    DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                    dto.setCumsumAddQuota(eo.getCumsumGeneralQuota().add(eo.getCumsumAdvanceQuota()));
                    break;
                }
                if (ObjectUtil.isEmpty((Object)dto.getId())) {
                    Integer n = defId;
                    defId = defId + 1;
                    Integer n2 = defId;
                    dto.setId(Long.valueOf(defId.longValue()));
                }
                dto.setCustomerId(customer.getId());
                dto.setCustomerName(customer.getName());
                dto.setCustomerTypeName(customer.getCustomerTypeName());
                dto.setCustomerCode(customer.getCode());
                dto.setRegionName(customer.getRegionNames());
                dtoList.add(dto);
            }
        }
        List accountIds = dtoList.stream().map(ReturnsQuotaRespDto::getReturnsQuotaAccountId).collect(Collectors.toList());
        ReturnsQuotaAccountEo accountEo = new ReturnsQuotaAccountEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", accountIds));
        accountEo.setSqlFilters(sqlFilters);
        List accountEoList = this.returnsQuotaAccountDas.select((BaseEo)accountEo);
        if (CollectionUtil.isNotEmpty((Collection)accountEoList)) {
            block2: for (ReturnsQuotaRespDto dto : dtoList) {
                if (ObjectUtil.isEmpty((Object)dto.getReturnsQuotaAccountId())) continue;
                for (ReturnsQuotaAccountEo eo : accountEoList) {
                    if (dto.getReturnsQuotaAccountId().longValue() != eo.getId().longValue()) continue;
                    dto.setCurrentUsableQuota(eo.getGeneralReturnsQuota().add(eo.getAdvanceQuota()));
                    continue block2;
                }
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ReturnsQuotaDetailRespDto> quotaDetailPage(String filter, Integer pageNum, Integer pageSize, Long returnsQuotaId) {
        ReturnsQuotaDetailEo returnsQuotaDetailEo = new ReturnsQuotaDetailEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (ObjectUtil.isEmpty((Object)returnsQuotaId)) {
            throw new BizException("\u5e74\u5ea6\u9000\u8d27\u989d\u5ea6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sqlFilters.add(SqlFilter.eq((String)"returns_quota_id", (Object)returnsQuotaId));
        Map map = (Map)JSON.parseObject((String)filter, Map.class);
        if (ObjectUtil.isNotEmpty((Object)map)) {
            if (ObjectUtil.isNotEmpty(map.get("quotaType"))) {
                sqlFilters.add(SqlFilter.eq((String)"quota_type", map.get("quotaType")));
            }
            if (ObjectUtil.isNotEmpty(map.get("changeType"))) {
                sqlFilters.add(SqlFilter.eq((String)"change_type", map.get("changeType")));
            }
            if (ObjectUtil.isNotEmpty(map.get("businessType"))) {
                sqlFilters.add(SqlFilter.eq((String)"business_type", map.get("businessType")));
            }
            if (ObjectUtil.isNotEmpty(map.get("startTime")) && ObjectUtil.isNotEmpty(map.get("endTime"))) {
                sqlFilters.add(SqlFilter.ge((String)"change_time", map.get("startTime")));
                sqlFilters.add(SqlFilter.le((String)"change_time", map.get("endTime")));
            }
        }
        returnsQuotaDetailEo.setSqlFilters(sqlFilters);
        returnsQuotaDetailEo.setOrderByDesc("create_time");
        returnsQuotaDetailEo.setOrderByDesc("business_type");
        PageInfo returnsQuotaDetailEoPageInfo = this.returnsQuotaDetailDas.selectPage((BaseEo)returnsQuotaDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)returnsQuotaDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)returnsQuotaDetailEoPageInfo.getList(), dtoList, ReturnsQuotaDetailRespDto.class);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            for (ReturnsQuotaDetailRespDto dto : dtoList) {
                dto.setQuotaTypeName(ReturnsQuotaTypeEnum.toName(dto.getQuotaType()));
                dto.setChangeTypeName(ReturnsQuotaChangeTypeEnum.toName(dto.getChangeType()));
                dto.setBusinessTypeName(ReturnsQuotaBusinessTypeEnum.toName((Integer)dto.getBusinessType()));
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void batchAddAdvanceQuota(AddReturnsAdvanceQuotaReqDto reqDto) {
        ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
        for (CustomerDto customer : reqDto.getCustomerList()) {
            ReturnsQuotaAccountEo returnsQuotaAccountEo = new ReturnsQuotaAccountEo();
            returnsQuotaAccountEo.setCustomerId(customer.getCustomerId());
            List accountEos = this.returnsQuotaAccountDas.select((BaseEo)returnsQuotaAccountEo);
            if (CollectionUtil.isEmpty((Collection)accountEos)) {
                throw new BizException("\u589e\u52a0\u9000\u8d27\u989d\u5ea6\u9884\u652f\u989d\u5ea6\u5f02\u5e38\uff1a\u8d26\u6237<" + customer.getCustomerName() + ">\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u9000\u8d27\u989d\u5ea6\u8d26\u6237");
            }
            if (accountEos.size() >= 2) {
                throw new BizException("\u589e\u52a0\u9000\u8d27\u989d\u5ea6\u9884\u652f\u989d\u5ea6\u5f02\u5e38\uff1a\u8d26\u6237<" + customer.getCustomerName() + ">\u9000\u8d27\u989d\u5ea6\u8d26\u6237\u51fa\u73b0\u591a\u4e2a");
            }
            ReturnsQuotaAccountEo accountEo = (ReturnsQuotaAccountEo)accountEos.get(0);
            returnsQuotaEo.setCustomerId(customer.getCustomerId());
            returnsQuotaEo.setStatus(Integer.valueOf(1));
            List select = this.returnsQuotaDas.select((BaseEo)returnsQuotaEo);
            if (CollectionUtil.isEmpty((Collection)select)) {
                throw new BizException("\u589e\u52a0\u9000\u8d27\u989d\u5ea6\u9884\u652f\u989d\u5ea6\u5f02\u5e38\uff1a\u8d26\u6237<" + customer.getCustomerName() + ">\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u5e74\u5ea6\u9000\u8d27\u989d\u5ea6\u8bb0\u5f55");
            }
            if (select.size() >= 2) {
                throw new BizException("\u589e\u52a0\u9000\u8d27\u989d\u5ea6\u9884\u652f\u989d\u5ea6\u5f02\u5e38\uff1a\u8d26\u6237<" + customer.getCustomerName() + ">\u5e74\u5ea6\u9000\u8d27\u989d\u5ea6\u8bb0\u5f55\u51fa\u73b0\u591a\u4e2a");
            }
            ReturnsQuotaEo eo = (ReturnsQuotaEo)select.get(0);
            this.returnsQuotaAccountDas.addAdvanceQuota(accountEo.getId(), reqDto.getAdvanceQuota());
            this.cacheService.delCache(this.returnsQuotaAccountDas.getCachePre() + accountEo.getId());
            this.returnsQuotaDas.addAdvanceQuota(eo.getId(), reqDto.getAdvanceQuota());
            this.cacheService.delCache(this.returnsQuotaDas.getCachePre() + eo.getId());
            ReturnsQuotaDetailEo returnsQuotaDetailEo = new ReturnsQuotaDetailEo();
            returnsQuotaDetailEo.setReturnsQuotaId(eo.getId());
            returnsQuotaDetailEo.setQuotaType(ReturnsQuotaTypeEnum.RETURN_QUOTA.getValue());
            returnsQuotaDetailEo.setQuotaAdjustBefore(accountEo.getAdvanceQuota().add(accountEo.getGeneralReturnsQuota()));
            returnsQuotaDetailEo.setQuotaAdjust(reqDto.getAdvanceQuota());
            returnsQuotaDetailEo.setQuotaAdjustAfter(accountEo.getAdvanceQuota().add(accountEo.getGeneralReturnsQuota()).add(reqDto.getAdvanceQuota()));
            returnsQuotaDetailEo.setChangeType(ReturnsQuotaChangeTypeEnum.ADD.getValue());
            returnsQuotaDetailEo.setBusinessType(reqDto.getBusinessType());
            returnsQuotaDetailEo.setChangeTime(new Date());
            returnsQuotaDetailEo.setRemarks(reqDto.getRemarks());
            returnsQuotaDetailEo.setAttachmentUrl(reqDto.getAttachmentUrl());
            this.returnsQuotaDetailDas.insert((BaseEo)returnsQuotaDetailEo);
        }
    }

    @Override
    public PageInfo<ReturnsQuotaRespDto> queryHistoryReturnsQuotaPage(String filter, Integer pageNum, Integer pageSize, Long customerId) {
        ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
        returnsQuotaEo.setCustomerId(customerId);
        PageInfo returnsQuotaEoPageInfo = this.returnsQuotaDas.selectPage((BaseEo)returnsQuotaEo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)returnsQuotaEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)returnsQuotaEoPageInfo.getList(), dtoList, ReturnsQuotaRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public String exportReturnsQuota(String filter) {
        PageInfo<ReturnsQuotaRespDto> returnsQuotaRespDtoPageInfo = this.queryByPage(filter, 1, 10000);
        List<ReturnsQuotaExportDto> list = BeanUtil.copyList(returnsQuotaRespDtoPageInfo.getList(), ReturnsQuotaExportDto.class);
        String title = "\u9000\u8d27\u989d\u5ea6\u8bb0\u5f55";
        String fileName = title + new Date().getTime();
        try {
            return EasyPoiExportUtil.getExportUrl(list, ReturnsQuotaExportDto.class, title, fileName, "xls");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    public List<ReturnsDictGroupRespDto> queryReturnsDict() {
        ArrayList<ReturnsDictGroupRespDto> list = new ArrayList<ReturnsDictGroupRespDto>();
        list.add(ReturnsQuotaBusinessTypeEnum.getDictList());
        list.add(ReturnsQuotaChangeTypeEnum.getDictList());
        list.add(ReturnsQuotaTypeEnum.getDictList());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deliverAddQuota(AddReturnsQuotaDto addReturnsQuotaDto) {
        ReturnsQuotaDetailEo detailEo;
        BigDecimal addQuota;
        BigDecimal originScale;
        Mutex mutex;
        block11: {
            block10: {
                logger.info("\u8ba2\u5355\u53d1\u8d27\u589e\u52a0\u9000\u8d27\u989d\u5ea6\uff1a{}", (Object)JSON.toJSONString((Object)addReturnsQuotaDto));
                mutex = null;
                try {
                    mutex = this.lockService.lock("DeliverAddQuota", addReturnsQuotaDto.getOrderNo(), 10, 10, TimeUnit.SECONDS);
                    ArrayList<SqlFilter> sqlFilterss = new ArrayList<SqlFilter>();
                    String params = ReturnsQuotaBusinessTypeEnum.SEND_OUT.getValue() + ReturnsQuotaBusinessTypeEnum.SEND_OUT_COUNTERACT.getValue() + "";
                    sqlFilterss.add(SqlFilter.in((String)"business_type", (Object)params));
                    sqlFilterss.add(SqlFilter.eq((String)"relation_order", (Object)addReturnsQuotaDto.getOrderNo()));
                    ReturnsQuotaDetailEo detailEoParams = new ReturnsQuotaDetailEo();
                    detailEoParams.setSqlFilters(sqlFilterss);
                    ReturnsQuotaDetailEo detailEo1 = (ReturnsQuotaDetailEo)this.returnsQuotaDetailDas.selectOne((BaseEo)detailEoParams);
                    if (!ObjectUtil.isNotEmpty((Object)detailEo1)) break block10;
                    logger.info("\u53d1\u8d27\u589e\u52a0\u9000\u8d27\u989d\u5ea6\uff0c\u8be5\u8ba2\u5355\u5df2\u5904\u7406\u5b8c\u6bd5\uff1a{}", (Object)JSONObject.toJSONString((Object)addReturnsQuotaDto));
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                return;
            }
            originScale = this.getCustomerReturnsQuota(addReturnsQuotaDto.getCustomerId());
            addReturnsQuotaDto.setScale(originScale.divide(new BigDecimal(100)));
            addQuota = addReturnsQuotaDto.getOrderAmount().multiply(addReturnsQuotaDto.getScale());
            if (BigDecimal.ZERO.compareTo(addQuota) < 0) break block11;
            logger.info("\u53d1\u8d27\u589e\u52a0\u989d\u5ea6\u4e3a\u96f6,\u4e0d\u589e\u52a0\u9000\u8d27\u989d\u5ea6");
            this.lockService.unlock(mutex);
            return;
        }
        logger.info("\u53d1\u8d27\u589e\u52a0\u9000\u8d27\u989d\u5ea6\uff1a{}", (Object)JSONObject.toJSONString((Object)addReturnsQuotaDto));
        ReturnsQuotaAccountEo accountEo = new ReturnsQuotaAccountEo();
        accountEo.setCustomerId(addReturnsQuotaDto.getCustomerId());
        ReturnsQuotaAccountEo returnsQuotaAccount = (ReturnsQuotaAccountEo)this.returnsQuotaAccountDas.selectOne((BaseEo)accountEo);
        if (ObjectUtil.isEmpty((Object)returnsQuotaAccount)) {
            throw new BizException("\u53d1\u8d27\u589e\u52a0\u9000\u8d27\u989d\u5ea6\u5f02\u5e38\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba2\u6237\u8d26\u53f7");
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.le((String)"start_date", (Object)addReturnsQuotaDto.getOrderTime()));
        sqlFilters.add(SqlFilter.ge((String)"end_date", (Object)addReturnsQuotaDto.getOrderTime()));
        sqlFilters.add(SqlFilter.eq((String)"customer_id", (Object)addReturnsQuotaDto.getCustomerId()));
        ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
        returnsQuotaEo.setSqlFilters(sqlFilters);
        ReturnsQuotaEo returnsQuota = (ReturnsQuotaEo)this.returnsQuotaDas.selectOne((BaseEo)returnsQuotaEo);
        if (ObjectUtil.isEmpty((Object)returnsQuota)) {
            throw new BizException("\u53d1\u8d27\u589e\u52a0\u9000\u8d27\u989d\u5ea6\u5f02\u5e38\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u5e74\u5ea6\u8bb0\u5f55");
        }
        returnsQuota.setOrderAmount(returnsQuota.getOrderAmount().add(addReturnsQuotaDto.getOrderAmount()));
        ArrayList<ReturnsQuotaDetailEo> detailEoLis = new ArrayList<ReturnsQuotaDetailEo>();
        if (returnsQuotaAccount.getAdvanceUnbackQuota() != null && returnsQuotaAccount.getAdvanceUnbackQuota().compareTo(BigDecimal.ZERO) != 0) {
            detailEo = new ReturnsQuotaDetailEo();
            detailEo.setQuotaAdjustBefore(returnsQuotaAccount.getAdvanceUnbackQuota());
            if (returnsQuotaAccount.getAdvanceUnbackQuota().compareTo(addQuota) > -1) {
                detailEo.setQuotaAdjust(addQuota);
                returnsQuotaAccount.setAdvanceUnbackQuota(returnsQuotaAccount.getAdvanceUnbackQuota().subtract(addQuota));
                addQuota = BigDecimal.ZERO;
            } else {
                detailEo.setQuotaAdjust(returnsQuotaAccount.getAdvanceUnbackQuota());
                addQuota = addQuota.subtract(returnsQuotaAccount.getAdvanceUnbackQuota());
                returnsQuotaAccount.setAdvanceUnbackQuota(BigDecimal.ZERO);
            }
            detailEo.setReturnsQuotaId(returnsQuota.getId());
            detailEo.setQuotaType(ReturnsQuotaTypeEnum.UN_ADVANCE_QUOTA.getValue());
            detailEo.setQuotaAdjustAfter(returnsQuotaAccount.getAdvanceUnbackQuota());
            detailEo.setChangeType(ReturnsQuotaChangeTypeEnum.REDUCE.getValue());
            detailEo.setBusinessType(ReturnsQuotaBusinessTypeEnum.SEND_OUT_COUNTERACT.getValue());
            detailEo.setRelationOrder(addReturnsQuotaDto.getOrderNo());
            detailEo.setChangeTime(new Date());
            detailEo.setScale(addReturnsQuotaDto.getScale());
            detailEoLis.add(detailEo);
        }
        if (addQuota.compareTo(BigDecimal.ZERO) == 1) {
            returnsQuota.setCumsumGeneralQuota(returnsQuota.getCumsumGeneralQuota().add(addQuota));
            returnsQuota.setCumsumUsableQuota(returnsQuota.getCumsumGeneralQuota().add(returnsQuota.getCumsumAdvanceQuota()));
            detailEo = new ReturnsQuotaDetailEo();
            detailEo.setReturnsQuotaId(returnsQuota.getId());
            detailEo.setQuotaType(ReturnsQuotaTypeEnum.RETURN_QUOTA.getValue());
            detailEo.setQuotaAdjustBefore(returnsQuotaAccount.getGeneralReturnsQuota().add(returnsQuotaAccount.getAdvanceQuota()));
            detailEo.setQuotaAdjust(addQuota);
            detailEo.setQuotaAdjustAfter(returnsQuotaAccount.getGeneralReturnsQuota().add(returnsQuotaAccount.getAdvanceQuota()).add(addQuota));
            detailEo.setChangeType(ReturnsQuotaChangeTypeEnum.ADD.getValue());
            detailEo.setBusinessType(ReturnsQuotaBusinessTypeEnum.SEND_OUT.getValue());
            detailEo.setRelationOrder(addReturnsQuotaDto.getOrderNo());
            detailEo.setChangeTime(new Date());
            detailEo.setScale(originScale);
            detailEoLis.add(detailEo);
            returnsQuotaAccount.setGeneralReturnsQuota(returnsQuotaAccount.getGeneralReturnsQuota().add(addQuota));
        }
        this.returnsQuotaAccountDas.update((BaseEo)returnsQuotaAccount);
        this.returnsQuotaDas.update((BaseEo)returnsQuota);
        this.returnsQuotaDetailDas.insertBatch(detailEoLis);
        this.lockService.unlock(mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnsReduceQuota(ReduceReturnsQuotaDto reduceReturnsQuotaDto) {
        Mutex mutex;
        block15: {
            logger.info("\u8ba2\u5355\u9000\u8d27\u6263\u51cf\u9000\u8d27\u989d\u5ea6\uff1a{}", (Object)JSON.toJSONString((Object)reduceReturnsQuotaDto));
            mutex = null;
            try {
                mutex = this.lockService.lock("ReturnsReduceQuota", reduceReturnsQuotaDto.getOrderNo(), 10, 10, TimeUnit.SECONDS);
                ReturnsQuotaDetailEo detailEoParams = new ReturnsQuotaDetailEo();
                detailEoParams.setRelationOrder(reduceReturnsQuotaDto.getOrderNo());
                detailEoParams.setBusinessType(ReturnsQuotaBusinessTypeEnum.RETURNS_TO_DEDUCT.getValue());
                ReturnsQuotaDetailEo detailEo1 = (ReturnsQuotaDetailEo)this.returnsQuotaDetailDas.selectOne((BaseEo)detailEoParams);
                if (!ObjectUtil.isNotEmpty((Object)detailEo1)) break block15;
                logger.info("\u9000\u8d27\u51cf\u5c11\u9000\u8d27\u989d\u5ea6\uff0c\u8be5\u8ba2\u5355\u5df2\u5904\u7406\u8fc7\uff1a{}", (Object)JSONObject.toJSONString((Object)reduceReturnsQuotaDto));
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
            return;
        }
        BigDecimal originScale = this.getCustomerReturnsQuota(reduceReturnsQuotaDto.getCustomerId());
        reduceReturnsQuotaDto.setScale(originScale.divide(new BigDecimal(100)));
        BigDecimal rebateAmount = reduceReturnsQuotaDto.getReturnsAmount();
        BigDecimal totalAmount = rebateAmount.add(reduceReturnsQuotaDto.getDeductionAmount());
        ReturnsQuotaAccountEo accountEo = this.getReturnsQuotaAccount(reduceReturnsQuotaDto.getCustomerId());
        BigDecimal usableQuota = accountEo.getAdvanceQuota().add(accountEo.getGeneralReturnsQuota());
        if (totalAmount.compareTo(usableQuota) > 0) {
            throw new BizException("\u6ca1\u6709\u8db3\u591f\u7684\u989d\u5ea6\u8fdb\u884c\u9000\u8d27");
        }
        ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
        returnsQuotaEo.setCustomerId(reduceReturnsQuotaDto.getCustomerId());
        returnsQuotaEo.setStatus(Integer.valueOf(1));
        ReturnsQuotaEo returnsQuota = (ReturnsQuotaEo)this.returnsQuotaDas.selectOne((BaseEo)returnsQuotaEo);
        if (ObjectUtil.isEmpty((Object)returnsQuota)) {
            throw new BizException("\u5f53\u524d\u6ca1\u6709\u5bf9\u5e94\u7684\u5e74\u5ea6\u8bb0\u5f55");
        }
        ArrayList<ReturnsQuotaDetailEo> detailEoList = new ArrayList<ReturnsQuotaDetailEo>();
        if (rebateAmount.compareTo(BigDecimal.ZERO) == 1) {
            ReturnsQuotaDetailEo rebateDetailRebate = new ReturnsQuotaDetailEo();
            rebateDetailRebate.setQuotaAdjustBefore(accountEo.getAdvanceQuota().add(accountEo.getGeneralReturnsQuota()));
            rebateDetailRebate.setQuotaAdjust(rebateAmount);
            if (accountEo.getAdvanceQuota().compareTo(BigDecimal.ZERO) == 1) {
                if (accountEo.getAdvanceQuota().compareTo(rebateAmount) > -1) {
                    accountEo.setAdvanceQuota(accountEo.getAdvanceQuota().subtract(rebateAmount));
                    rebateAmount = BigDecimal.ZERO;
                } else {
                    rebateAmount = rebateAmount.subtract(accountEo.getAdvanceQuota());
                    accountEo.setAdvanceQuota(BigDecimal.ZERO);
                }
            }
            if (accountEo.getGeneralReturnsQuota().compareTo(rebateAmount) <= -1) {
                throw new BizException("\u5f53\u524d\u989d\u5ea6\u4e0d\u8db3\u4ee5\u8fdb\u884c\u6263\u56de");
            }
            accountEo.setGeneralReturnsQuota(accountEo.getGeneralReturnsQuota().subtract(rebateAmount));
            rebateAmount = BigDecimal.ZERO;
            rebateDetailRebate.setQuotaAdjustAfter(accountEo.getAdvanceQuota().add(accountEo.getGeneralReturnsQuota()));
            rebateDetailRebate.setReturnsQuotaId(returnsQuota.getId());
            rebateDetailRebate.setQuotaType(ReturnsQuotaTypeEnum.RETURN_QUOTA.getValue());
            rebateDetailRebate.setChangeType(ReturnsQuotaChangeTypeEnum.REDUCE.getValue());
            rebateDetailRebate.setChangeTime(new Date());
            rebateDetailRebate.setBusinessType(ReturnsQuotaBusinessTypeEnum.RETURNS_TO_DEDUCT.getValue());
            rebateDetailRebate.setRelationOrder(reduceReturnsQuotaDto.getOrderNo());
            detailEoList.add(rebateDetailRebate);
        }
        if (reduceReturnsQuotaDto.getDeductionAmount().compareTo(BigDecimal.ZERO) == 1) {
            ReturnsQuotaDetailEo deductDetailRebate = new ReturnsQuotaDetailEo();
            deductDetailRebate.setQuotaAdjustBefore(accountEo.getAdvanceQuota().add(accountEo.getGeneralReturnsQuota()));
            deductDetailRebate.setQuotaAdjust(reduceReturnsQuotaDto.getDeductionAmount());
            if (accountEo.getAdvanceQuota().compareTo(BigDecimal.ZERO) == 1) {
                if (accountEo.getAdvanceQuota().compareTo(reduceReturnsQuotaDto.getDeductionAmount()) > -1) {
                    accountEo.setAdvanceQuota(accountEo.getAdvanceQuota().subtract(reduceReturnsQuotaDto.getDeductionAmount()));
                    reduceReturnsQuotaDto.setDeductionAmount(BigDecimal.ZERO);
                } else {
                    reduceReturnsQuotaDto.setDeductionAmount(reduceReturnsQuotaDto.getDeductionAmount().subtract(accountEo.getAdvanceQuota()));
                    accountEo.setAdvanceQuota(BigDecimal.ZERO);
                }
            }
            if (accountEo.getGeneralReturnsQuota().compareTo(reduceReturnsQuotaDto.getDeductionAmount()) <= -1) {
                throw new BizException("\u5f53\u524d\u989d\u5ea6\u4e0d\u8db3\u4ee5\u8fdb\u884c\u6263\u51cf");
            }
            accountEo.setGeneralReturnsQuota(accountEo.getGeneralReturnsQuota().subtract(reduceReturnsQuotaDto.getDeductionAmount()));
            reduceReturnsQuotaDto.setDeductionAmount(BigDecimal.ZERO);
            deductDetailRebate.setReturnsQuotaId(returnsQuota.getId());
            deductDetailRebate.setQuotaAdjustAfter(accountEo.getGeneralReturnsQuota().add(accountEo.getAdvanceQuota()));
            deductDetailRebate.setQuotaType(ReturnsQuotaTypeEnum.RETURN_QUOTA.getValue());
            deductDetailRebate.setChangeType(ReturnsQuotaChangeTypeEnum.REDUCE.getValue());
            deductDetailRebate.setChangeTime(new Date());
            deductDetailRebate.setBusinessType(ReturnsQuotaBusinessTypeEnum.RETURNS_TO_USE.getValue());
            deductDetailRebate.setRelationOrder(reduceReturnsQuotaDto.getOrderNo());
            detailEoList.add(deductDetailRebate);
        }
        returnsQuota.setCumsumUsedQuota(returnsQuota.getCumsumUsedQuota().add(totalAmount));
        this.returnsQuotaAccountDas.update((BaseEo)accountEo);
        this.returnsQuotaDas.update((BaseEo)returnsQuota);
        this.returnsQuotaDetailDas.insertBatch(detailEoList);
        this.lockService.unlock(mutex);
    }

    @Override
    public void syncCustomerChange(CustomerReqDto reqDto) {
        if (ObjectUtil.isEmpty((Object)reqDto.getId())) {
            return;
        }
        this.returnsQuotaDas.syncCustomerChange(reqDto.getId(), reqDto.getName(), reqDto.getCode());
    }

    private ReturnsQuotaAccountEo getReturnsQuotaAccount(Long customerId) {
        ReturnsQuotaAccountEo accountEo = new ReturnsQuotaAccountEo();
        accountEo.setCustomerId(customerId);
        ReturnsQuotaAccountEo returnsQuotaAccount = (ReturnsQuotaAccountEo)this.returnsQuotaAccountDas.selectOne((BaseEo)accountEo);
        if (ObjectUtil.isEmpty((Object)returnsQuotaAccount)) {
            throw new BizException("\u53d1\u8d27\u589e\u52a0\u9000\u8d27\u989d\u5ea6\u5f02\u5e38\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5ba2\u6237\u8d26\u53f7");
        }
        return returnsQuotaAccount;
    }

    private BigDecimal getCustomerReturnsQuota(Long customerId) {
        return this.returnsQuotaAccountService.queryCustomerScale(customerId);
    }
}

