/*
 * Decompiled with CFR 0.152.
 */
package com.yx.demo.center.xx.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerToBDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.yx.demo.center.xx.api.dto.request.SellerBizStatusReqDto;
import com.yx.demo.center.xx.api.enums.SellerStatusEnum;
import com.yx.demo.center.xx.biz.service.ISellerExtendsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SellerExtendsServiceImpl
implements ISellerExtendsService {
    private static final Logger logger = LoggerFactory.getLogger(SellerExtendsServiceImpl.class);
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private SellerToBDas sellerToBDas;
    @Resource
    private HttpServletRequest request;

    @Override
    public List<SellerToBListRespDto> queryByCurrentBrand() {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        if (ObjectUtils.isEmpty((Object)orgId)) {
            throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7");
        }
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("merchantId", orgId);
        List customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString(params)));
        logger.info("\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerList));
        if (CollectionUtils.isNotEmpty((Collection)customerList)) {
            List orgIds = customerList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
            SellerToBQueryReqDto reqDto = new SellerToBQueryReqDto();
            reqDto.setOrganizationIdList(orgIds);
            return this.sellerToBDas.queryPage(reqDto);
        }
        return new ArrayList<SellerToBListRespDto>();
    }

    @Override
    public void changeStatus(SellerBizStatusReqDto reqDto) {
        Assert.isTrue((!StringUtils.isBlank((CharSequence)reqDto.getCode()) ? 1 : 0) != 0, (String)"0001", (String)"\u5546\u5bb6\u7f16\u7801\u4e3a\u7a7a");
        Assert.isTrue((!StringUtils.isBlank((CharSequence)reqDto.getStatus()) ? 1 : 0) != 0, (String)"0001", (String)"\u53d8\u66f4\u72b6\u6001\u5f02\u5e38");
        SellerStatusEnum sellerStatusEnum = SellerStatusEnum.fromCode((String)reqDto.getStatus());
        Assert.isTrue((null != sellerStatusEnum ? 1 : 0) != 0, (String)"0001", (String)"\u6b64\u72b6\u6001\u4e0d\u5b58\u5728");
        SellerToBQueryReqDto sellerToBQueryReqDto = new SellerToBQueryReqDto();
        sellerToBQueryReqDto.setCode(reqDto.getCode());
        List sellerToBListRespDtos = this.sellerToBDas.queryPage(sellerToBQueryReqDto);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)sellerToBListRespDtos), (String)"0001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u63d0\u4ea4\u5546\u5bb6");
        SellerEo sellerEo = new SellerEo();
        sellerEo.setSellerBizStatus(sellerStatusEnum.getCode());
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.eq((String)"code", (Object)reqDto.getCode()));
        sellerEo.setSqlFilters((List)sqlFilters);
        int result = this.sellerToBDas.updateSelectiveSqlFilter((BaseEo)sellerEo);
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u4fee\u6539\u5546\u5bb6\u4e1a\u52a1\u72b6\u6001\u5931\u8d25");
    }
}

