/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.shop.api.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.UserInfoUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerAreaDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.mapper.SellerAreaMapper;
import com.dtyunxi.yundt.cube.center.shop.dao.mapper.SellerMapper;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IEmployeeExpandQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserOrgExpandQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.shop.api.dto.request.SellerExtQueryReqDto;
import com.yx.tcbj.center.shop.api.dto.request.SellerOrgQueryReqDto;
import com.yx.tcbj.center.shop.api.dto.response.SellerOrgRespDto;
import com.yx.tcbj.center.shop.api.service.query.ISellerExtQueryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SellerExtQueryServiceImpl
implements ISellerExtQueryService {
    private Logger logger = LoggerFactory.getLogger(SellerExtQueryServiceImpl.class);
    @Resource
    private SellerDas sellerDas;
    @Resource
    private SellerMapper sellerMapper;
    @Resource
    private IUserOrgExpandQueryApi userOrgExpandQueryApi;
    @Resource
    private IEmployeeExpandQueryApi employeeExpandQueryApi;
    @Resource
    private SellerAreaMapper sellerAreaMapper;
    @Resource
    private SellerAreaDas sellerAreaDas;

    @Override
    public List<SellerRespDto> queryBatchSellerList(SellerExtQueryReqDto queryReqDto) {
        this.logger.info("\u6279\u91cf\u67e5\u8be2\u5546\u5bb6\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        QueryWrapper queryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getIdList())) {
            queryWrapper.in((Object)"id", (Collection)queryReqDto.getIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getCodeList())) {
            queryWrapper.in((Object)"code", (Collection)queryReqDto.getCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getOrgIdList())) {
            queryWrapper.in((Object)"organization_id", (Collection)queryReqDto.getOrgIdList());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        List eoList = this.sellerMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return Lists.newArrayList();
        }
        ArrayList sellerRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)sellerRespDtos, SellerRespDto.class);
        return sellerRespDtos;
    }

    @Override
    public List<SellerOrgRespDto> querySellerOrgPage(SellerOrgQueryReqDto queryReqDto) {
        this.logger.info("querySellerOrgPage==>:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        Long userId = UserInfoUtil.getUserInfo();
        if (Objects.nonNull(queryReqDto.getUserId())) {
            userId = queryReqDto.getUserId();
        }
        ArrayList dtoList = Lists.newArrayList();
        if (null == userId) {
            return dtoList;
        }
        RestResponse orgInfoResp = this.employeeExpandQueryApi.getOrgInfoByUserId(userId);
        if (null == orgInfoResp || CollectionUtils.isEmpty((Collection)((Collection)orgInfoResp.getData()))) {
            return dtoList;
        }
        List orgIdList = ((List)orgInfoResp.getData()).stream().map(OrganizationDto::getId).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"organization_id", orgIdList);
        List eoList = this.sellerMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return dtoList;
        }
        Map orgInfoMap = ((List)orgInfoResp.getData()).stream().collect(Collectors.toMap(OrganizationDto::getId, Function.identity()));
        for (SellerEo eo : eoList) {
            SellerOrgRespDto dto = new SellerOrgRespDto();
            dto.setId(eo.getId());
            dto.setCode(eo.getCode());
            dto.setName(eo.getName());
            dto.setOrganizationId(eo.getOrganizationId());
            if (orgInfoMap.containsKey(eo.getOrganizationId())) {
                dto.setOrganizationCode(((OrganizationDto)orgInfoMap.get(eo.getOrganizationId())).getCode());
                dto.setOrganizationName(((OrganizationDto)orgInfoMap.get(eo.getOrganizationId())).getName());
            }
            dtoList.add(dto);
        }
        return dtoList;
    }
}

