package com.yx.tcbj.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.trade.api.dto.request.ExpressCompanyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
 * 物流公司信息服务接口
 *
 * @author by_liusong
 * @since 2022-05-17
 */
@Api(tags = {"物流公司信息服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-center-trade-api-IExpressCompanyApi",
        name = "yundt-cube-center-trade",
        path = "/v1/trade",
        url = "${yundt.cube.center.trade.api:}"
)
public interface IExpressCompanyApi {

    /**
     * 新增
     *
     * @param addReqDto 请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "物流公司信息新增", notes = "物流公司信息新增")
    RestResponse<Long> addExpressCompany(@RequestBody ExpressCompanyReqDto addReqDto);

    /**
     * 修改
     *
     * @param modifyReqDto 请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "物流公司信息修改", notes = "物流公司信息修改")
    RestResponse<Void> modifyExpressCompany(@RequestBody ExpressCompanyReqDto modifyReqDto);

    /**
     * 删除
     *
     * @param ids        删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "物流公司信息删除", notes = "物流公司信息删除")
    RestResponse<Void> removeExpressCompany(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
