/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.api.enums;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.user.api.enums.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.LocalDateTimeUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;

public enum TranslateEnum {
    YES_OR_NO{

        @Override
        public String translate(Object value) {
            return YesOrNoEnum.getDescByType((Integer)value);
        }
    }
    ,
    DEFAULT{

        @Override
        public String translate(Object value) {
            if (null == value) {
                return null;
            }
            return value.toString();
        }
    }
    ,
    DATE{

        @Override
        public String translate(Object value) {
            if (null == value) {
                return null;
            }
            if (value instanceof Date) {
                return new SimpleDateFormat(LocalDateTimeUtils.TimeEnum.DATE_FORMAT.getCode()).format((Date)value);
            }
            throw new BizException("DATE only use for java.util.date,{} is not", value.toString());
        }
    }
    ,
    ALL_DATE{

        @Override
        public String translate(Object value) {
            if (null == value) {
                return null;
            }
            if (value instanceof Date) {
                return new SimpleDateFormat(LocalDateTimeUtils.TimeEnum.ALL_DATE.getCode()).format((Date)value);
            }
            throw new BizException("DATE only use for java.util.date,{} is not", value.toString());
        }
    }
    ,
    LOCAL_DATE_TIME{

        @Override
        public String translate(Object value) {
            if (null == value) {
                return null;
            }
            if (value instanceof LocalDateTime) {
                return LocalDateTimeUtils.format((LocalDateTime)value);
            }
            throw new BizException("LocalDateTime only use for java.time.localDateTime,{} is not", value.toString());
        }
    }
    ,
    DECIMAL{

        @Override
        public String translate(Object value) {
            if (null == value) {
                return "0";
            }
            BigDecimal decimal = (BigDecimal)value;
            return decimal.stripTrailingZeros().toPlainString();
        }
    };


    public abstract String translate(Object var1);
}

