/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleAccessDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.boc.response.RoleDetailAndAccessRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.ChooseOrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.tcbj.OrgRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.tcbj.OrgRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IApplicationService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IBocAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgRoleService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IRoleService;
import com.dtyunxi.yundt.cube.center.user.dao.das.AccessDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeRoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.ResourceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleExpandDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleExpandEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdResourceEo;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeRoleEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OrgRoleServiceImpl
implements IOrgRoleService {
    private static final Logger logger = LoggerFactory.getLogger(OrgRoleServiceImpl.class);
    @Resource
    private IApplicationService applicationService;
    @Resource
    private IAccessService accessService;
    @Resource
    private RoleDas roleDas;
    @Resource
    private IBocAccessService bocAccessService;
    @Resource
    private EmployeeRoleDas employeeRoleDas;
    @Resource
    private IRoleService roleService;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private RoleExpandDas roleExpandDas;
    @Resource
    private AccessDas accessDas;
    @Resource
    private ResourceDas resourceDas;

    @Override
    public Long create(OrgRoleReqDto orgRoleReqDto) {
        if (orgRoleReqDto.getRoleType() == 2 && ObjectUtils.isEmpty((Object)orgRoleReqDto.getBelongOrgId())) {
            throw new BizException("-1", "\u666e\u901a\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u5fc5\u586b");
        }
        if (orgRoleReqDto.getRoleType() == 1) {
            orgRoleReqDto.setBelongOrgId(Long.valueOf(0L));
        }
        this.applicationService.assertAppInstanceExists(orgRoleReqDto.getInstanceId());
        Long tenantId = this.applicationService.queryTenantIdByAppInsId(orgRoleReqDto.getInstanceId());
        RoleExpandEo roleEo = new RoleExpandEo();
        DtoHelper.dto2Eo((BaseVo)orgRoleReqDto, (BaseEo)roleEo);
        Map<String, RoleEo> roleMap = this.getRoleMap(null, orgRoleReqDto.getBelongOrgId());
        this.checkOrgRoleNameRepeat(orgRoleReqDto.getName(), roleMap);
        String roleCode = orgRoleReqDto.getCode();
        if (StringUtils.isEmpty((CharSequence)roleCode)) {
            roleCode = this.getOrgRoleCode(roleMap);
        }
        roleEo.setCode(roleCode);
        roleEo.setIsEnableModify(Integer.valueOf(1));
        roleEo.setOrgId(Long.valueOf(1L));
        roleEo.setTenantId(tenantId);
        this.roleExpandDas.insert((BaseEo)roleEo);
        if (CollectionUtils.isNotEmpty((Collection)orgRoleReqDto.getAccessCodes())) {
            Set parentCodes;
            HashSet collectedCodes = new HashSet(orgRoleReqDto.getAccessCodes());
            List currentLevel = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"code", collectedCodes)).list();
            while (CollectionUtils.isNotEmpty((Collection)currentLevel) && !CollectionUtils.isEmpty(parentCodes = currentLevel.stream().map(StdResourceEo::getParentCode).filter(StringUtils::isNotBlank).filter(pc -> !"-1".equals(pc)).filter(pc -> !collectedCodes.contains(pc)).collect(Collectors.toSet()))) {
                collectedCodes.addAll(parentCodes);
                currentLevel = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"code", parentCodes)).list();
            }
            currentLevel = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"code", collectedCodes)).list();
            List currentLevel2 = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"parent_code", (Collection)orgRoleReqDto.getAccessCodes())).list();
            currentLevel.addAll(currentLevel2);
            Set collect = currentLevel.stream().map(r -> {
                AccessDto resourceEo = new AccessDto();
                resourceEo.setResourceId(r.getId());
                resourceEo.setResourceType(r.getType());
                return resourceEo;
            }).collect(Collectors.toSet());
            orgRoleReqDto.setAccessSet(collect);
        }
        if (CollectionUtils.isNotEmpty((Collection)orgRoleReqDto.getAccessSet())) {
            this.accessService.updateRoleResources(roleEo.getId(), orgRoleReqDto.getAccessSet());
        }
        return roleEo.getId();
    }

    @Override
    public void update(OrgRoleReqDto orgRoleReqDto) {
        if (ObjectUtils.isEmpty((Object)orgRoleReqDto) || ObjectUtils.isEmpty((Object)orgRoleReqDto.getId())) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(orgRoleReqDto.getId());
        if (ObjectUtils.isEmpty((Object)roleEo)) {
            throw new BizException("-1", "\u8be5\u7ec4\u7ec7\u89d2\u8272\u5df2\u4e0d\u5b58\u5728");
        }
        if (roleEo.getIsEnableModify() == 0) {
            throw new BizException("-1", "\u8be5\u7ec4\u7ec7\u89d2\u8272\u4e3a\u7cfb\u7edf\u9884\u7f6e\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91");
        }
        if (orgRoleReqDto.getRoleType() == 2 && ObjectUtils.isEmpty((Object)orgRoleReqDto.getBelongOrgId())) {
            throw new BizException("-1", "\u666e\u901a\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u5fc5\u586b");
        }
        if (orgRoleReqDto.getRoleType() == 1) {
            orgRoleReqDto.setBelongOrgId(Long.valueOf(0L));
        }
        if (CollectionUtils.isNotEmpty((Collection)orgRoleReqDto.getAccessCodes())) {
            Set parentCodes;
            HashSet collectedCodes = new HashSet(orgRoleReqDto.getAccessCodes());
            List currentLevel = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"code", collectedCodes)).list();
            while (CollectionUtils.isNotEmpty((Collection)currentLevel) && !CollectionUtils.isEmpty(parentCodes = currentLevel.stream().map(StdResourceEo::getParentCode).filter(StringUtils::isNotBlank).filter(pc -> !"-1".equals(pc)).filter(pc -> !collectedCodes.contains(pc)).collect(Collectors.toSet()))) {
                collectedCodes.addAll(parentCodes);
                currentLevel = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"code", parentCodes)).list();
            }
            currentLevel = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"code", collectedCodes)).list();
            List currentLevel2 = ((ExtQueryChainWrapper)this.resourceDas.filter().in((Object)"parent_code", (Collection)orgRoleReqDto.getAccessCodes())).list();
            currentLevel.addAll(currentLevel2);
            Set collect = currentLevel.stream().map(r -> {
                AccessDto resourceEo = new AccessDto();
                resourceEo.setResourceId(r.getId());
                resourceEo.setResourceType(r.getType());
                return resourceEo;
            }).collect(Collectors.toSet());
            orgRoleReqDto.setAccessSet(collect);
        }
        orgRoleReqDto = this.checkOrgRole(orgRoleReqDto);
        this.checkOrgRoleNameRepeat(orgRoleReqDto.getName(), this.getRoleMap(roleEo.getId(), orgRoleReqDto.getBelongOrgId()));
        roleEo.setName(orgRoleReqDto.getName());
        roleEo.setRoleType(orgRoleReqDto.getRoleType());
        roleEo.setBelongOrgId(orgRoleReqDto.getBelongOrgId());
        roleEo.setDescription(orgRoleReqDto.getDescription());
        this.roleDas.updateSelective((BaseEo)roleEo);
        if (CollectionUtils.isNotEmpty((Collection)orgRoleReqDto.getAccessSet())) {
            this.accessService.updateRoleResources(roleEo.getId(), orgRoleReqDto.getAccessSet());
        }
    }

    @Override
    public void delete(Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RoleEo roleEo = (RoleEo)this.roleDas.selectByPrimaryKey(id);
        if (ObjectUtils.isEmpty((Object)roleEo)) {
            return;
        }
        if (roleEo.getIsEnableModify() == 0) {
            throw new BizException("-1", "\u8be5\u7ec4\u7ec7\u89d2\u8272\u4e3a\u7cfb\u7edf\u9884\u7f6e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664");
        }
        EmployeeRoleEo params = new EmployeeRoleEo();
        params.setRoleId(roleEo.getId());
        List select = this.employeeRoleDas.select((BaseEo)params);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            throw new BizException("-1", "\u8be5\u7ec4\u7ec7\u89d2\u8272\u5df2\u88ab\u7ec4\u7ec7\u4eba\u5458\u7ed1\u5b9a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664");
        }
        this.roleService.delete(roleEo.getId());
    }

    @Override
    public OrgRoleRespDto queryDetail(Long id) {
        OrgRoleRespDto orgRoleRespDto = new OrgRoleRespDto();
        if (ObjectUtils.isEmpty((Object)id)) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38");
        }
        RoleDetailAndAccessRespDto roleDetailAndAccessRespDto = this.bocAccessService.queryById(id);
        if (ObjectUtils.isEmpty((Object)roleDetailAndAccessRespDto) || ObjectUtils.isEmpty((Object)roleDetailAndAccessRespDto.getRoleDto())) {
            throw new BizException("-1", "\u8be5\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)roleDetailAndAccessRespDto, (Object)orgRoleRespDto);
        if (ObjectUtils.isNotEmpty((Object)roleDetailAndAccessRespDto.getInstanceId())) {
            AppInstanceEo appInstanceEo = (AppInstanceEo)this.appInstanceDas.selectByPrimaryKey(roleDetailAndAccessRespDto.getInstanceId());
            orgRoleRespDto.setInstanceName(appInstanceEo.getAppInsName());
        }
        RoleAccessDto roleAccessDto = this.roleService.queryById(id);
        orgRoleRespDto.setRoleAccessDto(roleAccessDto);
        return orgRoleRespDto;
    }

    @Override
    public PageInfo<RoleDto> queryChoosePage(ChooseOrgRoleReqDto reqDto) {
        return this.roleExpandDas.queryChoosePage(reqDto);
    }

    @Override
    public List<AppInstanceDto> queryAppInstanceList() {
        List appInstanceEos = this.appInstanceDas.selectAll();
        ArrayList<AppInstanceDto> list = new ArrayList<AppInstanceDto>();
        DtoHelper.eoList2DtoList((Collection)appInstanceEos, list, AppInstanceDto.class);
        return list;
    }

    @Override
    public Long createOrUpdate(OrgRoleReqDto orgRoleReqDto) {
        if (Objects.nonNull(orgRoleReqDto.getId())) {
            this.update(orgRoleReqDto);
            return orgRoleReqDto.getId();
        }
        RoleEo roleEo = (RoleEo)((ExtQueryChainWrapper)this.roleDas.filter().eq((Object)"code", (Object)orgRoleReqDto.getCode())).one();
        if (Objects.nonNull(roleEo)) {
            orgRoleReqDto.setId(roleEo.getId());
            this.update(orgRoleReqDto);
            return roleEo.getId();
        }
        return this.create(orgRoleReqDto);
    }

    private Map<String, RoleEo> getRoleMap(Long id, Long belongOrgId) {
        HashMap appRoleMap = Maps.newHashMap();
        List roleEos = this.roleDas.selectAll();
        for (RoleEo roleEo : roleEos) {
            if (roleEo.getId().equals(id) || belongOrgId != null && !belongOrgId.equals(roleEo.getBelongOrgId())) continue;
            appRoleMap.put("CODE-" + roleEo.getCode(), roleEo);
            appRoleMap.put("NAME-" + roleEo.getName(), roleEo);
        }
        return appRoleMap;
    }

    private void checkOrgRoleNameRepeat(String name, Map<String, RoleEo> roleMap) {
        if (ObjectUtils.isEmpty(roleMap)) {
            return;
        }
        if (ObjectUtils.isNotEmpty((Object)roleMap.get("NAME-" + name))) {
            throw new BizException("-1", "\u89d2\u8272\u540d\u79f0\u91cd\u590d\uff01");
        }
    }

    private String getOrgRoleCode(Map<String, RoleEo> roleMap) {
        String code = null;
        while (code == null) {
            code = RandomStringUtils.randomAlphabetic((int)15);
            if (!roleMap.containsKey("CODE-" + code)) continue;
            logger.debug(String.format("\u751f\u6210\u91cd\u590d\u7684[code=%s]\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u751f\u6210", code));
            code = null;
        }
        return code;
    }

    private OrgRoleReqDto checkOrgRole(OrgRoleReqDto orgRoleReqDto) {
        if (orgRoleReqDto.getRoleType() == 2 && ObjectUtils.isEmpty((Object)orgRoleReqDto.getBelongOrgId())) {
            throw new BizException("-1", "\u666e\u901a\u89d2\u8272\u6240\u5c5e\u7ec4\u7ec7\u5fc5\u586b");
        }
        if (orgRoleReqDto.getRoleType() == 1) {
            orgRoleReqDto.setBelongOrgId(null);
        }
        if (CollectionUtils.isEmpty((Collection)orgRoleReqDto.getAccessSet())) {
            throw new BizException("-1", "\u89d2\u8272\u6743\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return orgRoleReqDto;
    }
}

