/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.build;

import com.dtyunxi.cube.component.track.commons.aspect.annotation.TransactionAction;
import com.dtyunxi.cube.component.track.commons.constant.TransactionControlTypeEnum;
import com.dtyunxi.cube.component.track.commons.constant.TransactionNodeTypeEnum;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.cube.component.track.commons.utils.PointUtils;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionVoBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionVoBuilder.class);

    public TransactionVo build(ProceedingJoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        TransactionAction transactionAction = ms.getClass().getAnnotation(TransactionAction.class);
        TransactionAction methodTransactionAction = this.getMethodTransactionAction(point, ms);
        TransactionVo transactionVo = new TransactionVo();
        TransactionVo overallTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.overall", (String)"transaction.overall.json");
        TransactionVo processTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.process", (String)"transaction.process.json");
        transactionVo.setEnv(System.getProperty("spring.profiles.active", "dev"));
        transactionVo.setParentTransactionId(Long.valueOf(processTransaction != null ? processTransaction.getId() : (overallTransaction != null ? overallTransaction.getId() : 0L)));
        transactionVo.setOverTransactionId(overallTransaction != null ? overallTransaction.getId() : null);
        transactionVo.setRequestId(ServerContextUtils.getReqId());
        transactionVo.setTransactionSort(Long.valueOf(processTransaction != null ? processTransaction.getTransactionSort() + 1L : (overallTransaction != null ? overallTransaction.getTransactionSort() + 1L : 1L)));
        transactionVo.setTransactionStatus(Integer.valueOf(TransactionStatusEnum.T_ACCEPT.code));
        transactionVo.setAccessTime(new Date());
        if (transactionAction == null && methodTransactionAction == null) {
            this.repackageByAnnotation(transactionVo, ms);
        } else if (methodTransactionAction == null) {
            this.repackageByAnnotation(transactionVo, transactionAction, ms);
        } else {
            this.repackageByAnnotation(transactionVo, methodTransactionAction, ms);
        }
        return transactionVo;
    }

    public void repackageByAnnotation(TransactionVo transactionVo, MethodSignature ms) {
        transactionVo.setTransactionName(PointUtils.getPointName((MethodSignature)ms));
        transactionVo.setTransactionGroup(PointUtils.getPointGroup((MethodSignature)ms));
        transactionVo.setTransactionCode(PointUtils.getPointCode((MethodSignature)ms));
        transactionVo.setTransactionControlType(Integer.valueOf(TransactionControlTypeEnum.T_OPEN.getCode()));
        transactionVo.setNodeType(Integer.valueOf(TransactionNodeTypeEnum.N_POINT.getCode()));
    }

    public void repackageByAnnotation(TransactionVo transactionVo, TransactionAction transactionAction, MethodSignature ms) {
        transactionVo.setTransactionName(this.compareAndGet(transactionAction.name(), e -> PointUtils.getPointName((MethodSignature)ms)));
        transactionVo.setTransactionGroup(this.compareAndGet(transactionAction.group(), e -> PointUtils.getPointGroup((MethodSignature)ms)));
        transactionVo.setTransactionCode(this.compareAndGet(transactionAction.code(), e -> PointUtils.getPointCode((MethodSignature)ms)));
        transactionVo.setTransactionControlType(Integer.valueOf(transactionAction.controlType()));
        transactionVo.setNodeType(Integer.valueOf(transactionAction.nodeType().getCode()));
    }

    public String compareAndGet(String a, Function<String, String> b) {
        return StringUtils.isNotBlank((CharSequence)a) ? a : b.apply(null);
    }

    public TransactionAction getMethodTransactionAction(ProceedingJoinPoint point, MethodSignature ms) {
        try {
            Method method = point.getTarget().getClass().getDeclaredMethod(ms.getName(), ms.getParameterTypes());
            return method.getAnnotation(TransactionAction.class);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

