/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.retry.executor;

import com.dtyunxi.cube.center.track.api.dto.response.TransactionNodeRecordRespDto;
import com.dtyunxi.cube.center.track.api.dto.response.TransactionNodeRespDto;
import com.dtyunxi.cube.center.track.api.dto.response.TransactionRespDto;
import com.dtyunxi.cube.center.track.api.query.ITransactionNodeQueryApi;
import com.dtyunxi.cube.center.track.api.query.ITransactionNodeRecordQueryApi;
import com.dtyunxi.cube.component.track.commons.utils.CommonUtils;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import com.dtyunxi.cube.component.track.retry.executor.TrackRetryExecutor;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;

public class DefaultTrackRetryExecutor
implements TrackRetryExecutor {
    private static Logger logger = LoggerFactory.getLogger(DefaultTrackRetryExecutor.class);
    @Resource
    private ITransactionNodeRecordQueryApi transactionNodeRecordQueryApiImpl;
    @Resource
    private ITransactionNodeQueryApi transactionNodeQueryApiImpl;
    private BeanFactory beanFactory;

    public DefaultTrackRetryExecutor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void executeRetry(Long transactionNodeRecordId) {
        Assert.notNull((Object)transactionNodeRecordId, (String)"trackNodeRecordId\u4e0d\u80fd\u4e3a\u7a7a");
        TransactionNodeRecordRespDto transactionNodeRecordRespDto = (TransactionNodeRecordRespDto)CommonUtils.checkResponse((RestResponse)this.transactionNodeRecordQueryApiImpl.queryById(transactionNodeRecordId));
        Assert.notNull((Object)transactionNodeRecordRespDto, (String)"\u83b7\u53d6\u4e0d\u5230transactionNodeRecordRespDto\u6570\u636e");
        TransactionNodeRespDto transactionNodeRespDto = (TransactionNodeRespDto)CommonUtils.checkResponse((RestResponse)this.transactionNodeQueryApiImpl.queryById(transactionNodeRecordRespDto.getNodeId()));
        Assert.notNull((Object)transactionNodeRespDto, (String)"\u83b7\u53d6\u4e0d\u5230transactionNodeRespDto\u6570\u636e");
        try {
            Class<?> beanClass = Class.forName(transactionNodeRespDto.getNodeApiClass());
            Object bean = this.getBeanByTransactionNode(beanClass, transactionNodeRespDto);
            Method method = this.getBeanMethodByTransactionNode(beanClass, transactionNodeRespDto, bean);
            Object[] objects = this.resetParamByTransactionNodeRecord(transactionNodeRecordRespDto, method);
            method.setAccessible(true);
            logger.debug("\u3010DefaultTrackRetryExecutor\u3011\u5f00\u59cb\u91cd\u8bd5\u6267\u884c\u65b9\u6cd5\uff1a" + beanClass + "." + method.getName());
            try {
                method.invoke(bean, objects);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            logger.debug("\u3010DefaultTrackRetryExecutor\u3011\u91cd\u8bd5\u6267\u884c\u65b9\u6cd5\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BusinessRuntimeException("\u3010DefaultTrackRetryExecutor\u3011\u91cd\u8bd5\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private Object getBeanByTransactionNode(Class<?> beanClass, TransactionNodeRespDto transactionNodeRespDto) {
        return this.beanFactory.getBean(beanClass);
    }

    private Method getBeanMethodByTransactionNode(Class<?> beanClass, TransactionNodeRespDto transactionNodeRespDto, Object bean) {
        Method[] methods = beanClass.getDeclaredMethods();
        Method targetMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals(transactionNodeRespDto.getNodeApiMethod())) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod == null) {
            throw new BusinessRuntimeException(beanClass.getName() + "\u83b7\u53d6\u4e0d\u5230\u65b9\u6cd5" + transactionNodeRespDto.getNodeApiMethod() + "(\u6682\u4e0d\u652f\u6301\u65b9\u6cd5\u91cd\u8f7d)\uff0c\u8bf7\u68c0\u67e5");
        }
        return targetMethod;
    }

    private TransactionVo buildTransactionVoByTransactionRespDto(TransactionRespDto transactionRespDto) {
        TransactionVo transactionVo = new TransactionVo();
        CubeBeanUtils.copyProperties((Object)transactionVo, (Object)transactionRespDto, (String[])new String[0]);
        return transactionVo;
    }

    private void resetTransactionContext(TransactionRespDto processTransactionRespDto, TransactionRespDto overTransactionRespDto) {
        TransactionVo processTransactionVo = this.buildTransactionVoByTransactionRespDto(processTransactionRespDto);
        TransactionVo overTransactionVo = this.buildTransactionVoByTransactionRespDto(overTransactionRespDto);
        ServerContextUtils.set((String)"transaction.overall", (Object)overTransactionVo);
        ServerContextUtils.set((String)"transaction.process", (Object)processTransactionVo);
    }

    private Object[] resetParamByTransactionNodeRecord(TransactionNodeRecordRespDto transactionNodeRecordRespDto, Method method) {
        return CommonUtils.resetParamByJson((String)transactionNodeRecordRespDto.getNodeApiMethodParams(), (Method)method);
    }
}

