package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * AuditItemEo
 *
 * @author 风影
 * @since 2.0.0
 */
@Table(name = "it_item_audit")
public class StdItemAuditEo extends CubeBaseEo {
    /**
     * 版本Id
     */
    @Column(name = "version_id")
    private Long versionId;
    /**
     * 品牌商code
     */
    @Column(name = "item_code")
    private String itemCode;
    /**
     * 审核结果
     */
    @Column(name = "result")
    private String result;
    /**
     * 审核意见
     */
    @Column(name = "audit_desc")
    private String auditDesc;
    /**
     * 审核人ID
     */
    @Column(name = "audit_person")
    private Long auditPerson;
    /**
     * 审核人名
     */
    @Column(name = "audit_person_name")
    private String auditPersonName;

    public static StdItemAuditEo newInstance() {
        return (StdItemAuditEo) BaseEo.newInstance(StdItemAuditEo.class);
    }

    public static StdItemAuditEo newInstance(Map<String, Object> extFields) {
        return (StdItemAuditEo) BaseEo.newInstance(StdItemAuditEo.class, extFields);
    }


    public Long getVersionId() {
        return versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public Long getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(Long auditPerson) {
        this.auditPerson = auditPerson;
    }

    public String getAuditPersonName() {
        return auditPersonName;
    }

    public void setAuditPersonName(String auditPersonName) {
        this.auditPersonName = auditPersonName;
    }
}
