/*
 * @(#)InventoryException.java 1.0 2018-08-22
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 商品组合实体类
 *
 * @author 佐助
 * @since 2.0.0
 */
@Table(name = "it_r_item_bundle")
public class StdItemBundleRelationEo extends CubeBaseEo {

    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 商品skuID
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 子商品ID
     */
    @Column(name = "sub_item_id")
    private Long subItemId;
    /**
     * 子商品SkuID
     */
    @Column(name = "sub_sku_id")
    private Long subSkuId;
    /**
     * 组合基数
     */
    @Column(name = "num")
    private Integer num;

    public static StdItemBundleRelationEo newInstance() {
        return (StdItemBundleRelationEo) BaseEo.newInstance(StdItemBundleRelationEo.class);
    }

    public static StdItemBundleRelationEo newInstance(Map<String, Object> extFields) {
        return (StdItemBundleRelationEo) BaseEo.newInstance(StdItemBundleRelationEo.class, extFields);
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSubItemId() {
        return subItemId;
    }

    public void setSubItemId(Long subItemId) {
        this.subItemId = subItemId;
    }

    public Long getSubSkuId() {
        return subSkuId;
    }

    public void setSubSkuId(Long subSkuId) {
        this.subSkuId = subSkuId;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }
}