/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.common.spring;

import com.fhs.common.spring.AnnotationTypeFilterBuilder;
import com.fhs.common.spring.SpringClassScanner;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.type.filter.TypeFilter;

public class ScannerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScannerUtils.class);

    public static Set<Class<?>> scan(Class<? extends Annotation> annotationClass, String[] packageNames) {
        TypeFilter entityFilter = AnnotationTypeFilterBuilder.build(annotationClass);
        SpringClassScanner entityScanner = new SpringClassScanner.Builder().typeFilter(entityFilter).build();
        for (String packageName : packageNames) {
            entityScanner.getScanPackages().add(packageName);
        }
        Set<Class<?>> entitySet = null;
        try {
            entitySet = entityScanner.scan();
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("\u5305\u626b\u63cf\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
        return entitySet;
    }
}

