/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.http;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.net.SSLContextBuilder;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.ijpay.core.IJPayHttpResponse;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocketFactory;

public abstract class AbstractHttpDelegate {
    public String get(String url) {
        return HttpUtil.get((String)url);
    }

    public String get(String url, Map<String, Object> paramMap) {
        return HttpUtil.get((String)url, paramMap);
    }

    public IJPayHttpResponse get(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.getToResponse(url, paramMap, headers);
        if (httpResponse.isGzip()) {
            response.setBodyByte(httpResponse.bodyBytes());
        } else {
            response.setBody(httpResponse.body());
        }
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public String post(String url, String data) {
        return HttpUtil.post((String)url, (String)data);
    }

    public String post(String url, Map<String, Object> paramMap) {
        return HttpUtil.post((String)url, paramMap);
    }

    public IJPayHttpResponse post(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.postToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public IJPayHttpResponse post(String url, String data, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.postToResponse(url, headers, data);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public IJPayHttpResponse patch(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.patchToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public IJPayHttpResponse patch(String url, String data, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.patchToResponse(url, headers, data);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public IJPayHttpResponse delete(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.deleteToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public IJPayHttpResponse delete(String url, String data, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.deleteToResponse(url, headers, data);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public IJPayHttpResponse put(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.putToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public IJPayHttpResponse put(String url, String data, Map<String, String> headers) {
        IJPayHttpResponse response = new IJPayHttpResponse();
        HttpResponse httpResponse = this.putToResponse(url, headers, data);
        response.setBody(httpResponse.body());
        response.setStatus(httpResponse.getStatus());
        response.setHeaders(httpResponse.headers());
        return response;
    }

    public String upload(String url, String data, String certPath, String certPass, String filePath, String protocol) {
        try {
            File file = FileUtil.newFile((String)filePath);
            SSLSocketFactory sslSocketFactory = this.getSslSocketFactory(certPath, null, certPass, protocol);
            return ((HttpRequest)HttpRequest.post((String)url).setSSLSocketFactory(sslSocketFactory).header("Content-Type", "multipart/form-data;boundary=\"boundary\"")).form("file", file).form("meta", (Object)data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String upload(String url, String data, String certPath, String certPass, String filePath) {
        return this.upload(url, data, certPath, certPass, filePath, "TLSv1");
    }

    public String post(String url, String data, String certPath, String certPass, String protocol) {
        try {
            SSLSocketFactory socketFactory = this.getSslSocketFactory(certPath, null, certPass, protocol);
            return HttpRequest.post((String)url).setSSLSocketFactory(socketFactory).body(data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String post(String url, String data, String certPath, String certPass) {
        return this.post(url, data, certPath, certPass, "TLSv1");
    }

    public String post(String url, String data, InputStream certFile, String certPass, String protocol) {
        try {
            SSLSocketFactory sslSocketFactory = this.getSslSocketFactory(null, certFile, certPass, protocol);
            return HttpRequest.post((String)url).setSSLSocketFactory(sslSocketFactory).body(data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String post(String url, String data, InputStream certFile, String certPass) {
        return this.post(url, data, certFile, certPass, "TLSv1");
    }

    private HttpResponse getToResponse(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        return ((HttpRequest)HttpRequest.get((String)url).addHeaders(headers)).form(paramMap).execute();
    }

    private HttpResponse postToResponse(String url, Map<String, String> headers, String data) {
        return ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).body(data).execute();
    }

    private HttpResponse postToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        return ((HttpRequest)HttpRequest.post((String)url).addHeaders(headers)).form(paramMap).execute();
    }

    private HttpResponse patchToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        return ((HttpRequest)HttpRequest.patch((String)url).addHeaders(headers)).form(paramMap).execute();
    }

    private HttpResponse patchToResponse(String url, Map<String, String> headers, String data) {
        return ((HttpRequest)HttpRequest.patch((String)url).addHeaders(headers)).body(data).execute();
    }

    private HttpResponse deleteToResponse(String url, Map<String, String> headers, String data) {
        return ((HttpRequest)HttpRequest.delete((String)url).addHeaders(headers)).body(data).execute();
    }

    private HttpResponse deleteToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        return ((HttpRequest)HttpRequest.delete((String)url).addHeaders(headers)).form(paramMap).execute();
    }

    private HttpResponse putToResponse(String url, Map<String, String> headers, String data) {
        return ((HttpRequest)HttpRequest.put((String)url).addHeaders(headers)).body(data).execute();
    }

    private HttpResponse putToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        return ((HttpRequest)HttpRequest.put((String)url).addHeaders(headers)).form(paramMap).execute();
    }

    private KeyManager[] getKeyManager(String certPass, String certPath, InputStream certFile) throws Exception {
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        if (certFile != null) {
            clientStore.load(certFile, certPass.toCharArray());
        } else {
            clientStore.load(Files.newInputStream(Paths.get(certPath, new String[0]), new OpenOption[0]), certPass.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientStore, certPass.toCharArray());
        return kmf.getKeyManagers();
    }

    private SSLSocketFactory getSslSocketFactory(String certPath, InputStream certFile, String certPass, String protocol) throws Exception {
        SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
        sslContextBuilder.setProtocol(protocol);
        sslContextBuilder.setKeyManagers(this.getKeyManager(certPass, certPath, certFile));
        sslContextBuilder.setSecureRandom(new SecureRandom());
        return sslContextBuilder.buildChecked().getSocketFactory();
    }
}

