/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.extend.filter.basic;

import com.github.xiaoymin.knife4j.extend.filter.basic.AbstractSecurityFilter;
import com.github.xiaoymin.knife4j.extend.util.FilterUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletSecurityBasicAuthFilter
extends AbstractSecurityFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
        this.initServletConfig(filterConfig.getInitParameterNames(), filterConfig.getInitParameter("enableBasicAuth"), filterConfig.getInitParameter("userName"), filterConfig.getInitParameter("password"));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        String auth;
        Object sessionObject;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        if (this.tryCommonBasic(url, sessionObject = request.getSession().getAttribute("KNIFE4J_BASIC_AUTH_SESSION"), auth = request.getHeader("Authorization"))) {
            if (this.match(url) && sessionObject == null) {
                request.getSession().setAttribute("KNIFE4J_BASIC_AUTH_SESSION", (Object)this.getUserName());
            }
            chain.doFilter(servletRequest, servletResponse);
        } else {
            FilterUtils.writeForbiddenCode(response);
        }
    }

    public void destroy() {
        this.urlFilters = null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServletSecurityBasicAuthFilter)) {
            return false;
        }
        ServletSecurityBasicAuthFilter other = (ServletSecurityBasicAuthFilter)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ServletSecurityBasicAuthFilter;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    public String toString() {
        return "ServletSecurityBasicAuthFilter()";
    }
}

