/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.filter.basic;

import com.github.xiaoymin.knife4j.spring.gateway.filter.AbstractBasicAuthFilter;
import java.util.Base64;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebFluxSecurityBasicAuthFilter
extends AbstractBasicAuthFilter
implements WebFilter {
    private boolean enableBasicAuth = false;
    private String userName;
    private String password;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.enableBasicAuth && this.match(exchange.getRequest().getURI().toString())) {
            return exchange.getSession().doOnNext(session -> this.doFilter(exchange, (WebSession)session)).then(chain.filter(exchange));
        }
        return chain.filter(exchange);
    }

    private void doFilter(ServerWebExchange exchange, WebSession session) {
        String credentials;
        String[] usernameAndPassword;
        String[] parts;
        Object attribute = session.getAttribute("KNIFE4J_BASIC_AUTH_SESSION");
        if (attribute != null) {
            return;
        }
        String authorization = exchange.getRequest().getHeaders().getFirst("Authorization");
        ServerHttpResponse response = exchange.getResponse();
        if (authorization == null) {
            this.writeForbiddenCode(response);
        }
        if ((parts = authorization.split(" ")).length != 2 || !parts[0].equals("Basic")) {
            this.writeForbiddenCode(response);
        }
        if ((usernameAndPassword = (credentials = new String(Base64.getDecoder().decode(parts[1]))).split(":")).length != 2 || !usernameAndPassword[0].equals(this.userName) || !usernameAndPassword[1].equals(this.password)) {
            this.writeForbiddenCode(response);
        } else {
            exchange.getSession().doOnNext(session1 -> session1.getAttributes().put("KNIFE4J_BASIC_AUTH_SESSION", this.userName)).subscribe();
        }
    }

    private void writeForbiddenCode(ServerHttpResponse serverHttpResponse) {
        serverHttpResponse.setRawStatusCode(Integer.valueOf(HttpStatus.UNAUTHORIZED.value()));
        serverHttpResponse.getHeaders().add("WWW-Authenticate", "Basic realm=\"Restricted Area\"");
        throw new ResponseStatusException(HttpStatus.UNAUTHORIZED.value(), null, null);
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

