/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.IConvertor;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.V2Convertor;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.xml.OBSXMLBuilder;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.CanonicalGrantee;
import com.obs.services.model.EventTypeEnum;
import com.obs.services.model.FunctionGraphConfiguration;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GranteeInterface;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.GroupGranteeEnum;
import com.obs.services.model.Owner;
import com.obs.services.model.Permission;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreTierEnum;
import com.obs.services.model.SSEAlgorithmEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TopicConfiguration;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class ObsConvertor
extends V2Convertor {
    private static ObsConvertor instance = new ObsConvertor();

    public static IConvertor getInstance() {
        return instance;
    }

    @Override
    public String transBucketLoction(String location) throws ServiceException {
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("CreateBucketConfiguration").elem("Location").text(ServiceUtils.toValid(location));
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public String transRestoreObjectRequest(RestoreObjectRequest req) throws ServiceException {
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("RestoreRequest").elem("Days").t(String.valueOf(req.getDays())).up();
            if (req.getRestoreTier() != null && req.getRestoreTier() != RestoreTierEnum.BULK) {
                builder.e("RestoreJob").e("Tier").t(req.getRestoreTier().getCode());
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for restoreobject", e);
        }
    }

    @Override
    public String transBucketEcryption(BucketEncryption encryption) throws ServiceException {
        String algorithm = encryption.getSseAlgorithm().getCode();
        String kmsKeyId = "";
        if (algorithm.equals(SSEAlgorithmEnum.KMS.getCode())) {
            kmsKeyId = encryption.getKmsKeyId();
        }
        return this.transBucketEcryptionXML(algorithm, kmsKeyId);
    }

    @Override
    public String transStoragePolicy(BucketStoragePolicyConfiguration status) throws ServiceException {
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("StorageClass").text(this.transStorageClass(status.getBucketStorageClass()));
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for StorageClass", e);
        }
    }

    @Override
    public String transBucketLoggingConfiguration(BucketLoggingConfiguration c) throws ServiceException {
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("BucketLoggingStatus");
            if (c.getAgency() != null) {
                builder.e("Agency").t(ServiceUtils.toValid(c.getAgency()));
            }
            if (c.isLoggingEnabled()) {
                GrantAndPermission[] grants;
                OBSXMLBuilder enabledBuilder = builder.elem("LoggingEnabled");
                if (c.getTargetBucketName() != null) {
                    enabledBuilder.elem("TargetBucket").text(ServiceUtils.toValid(c.getTargetBucketName()));
                }
                if (c.getLogfilePrefix() != null) {
                    enabledBuilder.elem("TargetPrefix").text(ServiceUtils.toValid(c.getLogfilePrefix()));
                }
                if ((grants = c.getTargetGrants()).length > 0) {
                    OBSXMLBuilder grantsBuilder = enabledBuilder.elem("TargetGrants");
                    this.transGrantsBuilder(grants, grantsBuilder);
                }
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for BucketLoggingConfiguration", e);
        }
    }

    private void transGrantsBuilder(GrantAndPermission[] grants, OBSXMLBuilder grantsBuilder) throws ParserConfigurationException, FactoryConfigurationError {
        for (GrantAndPermission gap : grants) {
            GranteeInterface grantee = gap.getGrantee();
            Permission permission = gap.getPermission();
            if (permission == null) continue;
            OBSXMLBuilder subBuilder = null;
            if (grantee instanceof CanonicalGrantee) {
                subBuilder = OBSXMLBuilder.create("Grantee").element("ID").text(ServiceUtils.toValid(grantee.getIdentifier()));
            } else if (grantee instanceof GroupGrantee) {
                subBuilder = OBSXMLBuilder.create("Grantee").element("Canned").text(this.transGroupGrantee(((GroupGrantee)grantee).getGroupGranteeType()));
            }
            if (subBuilder == null) continue;
            grantsBuilder.elem("Grant").importXMLBuilder(subBuilder).elem("Permission").text(ServiceUtils.toValid(permission.getPermissionString()));
        }
    }

    @Override
    public String transAccessControlList(AccessControlList acl, boolean isBucket) throws ServiceException {
        Owner owner = acl.getOwner();
        GrantAndPermission[] grants = acl.getGrantAndPermissions();
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("AccessControlPolicy");
            if (owner != null) {
                builder.elem("Owner").elem("ID").text(ServiceUtils.toValid(owner.getId()));
            }
            if (!isBucket) {
                builder.elem("Delivered").text(String.valueOf(acl.isDelivered()));
            }
            if (grants.length > 0) {
                OBSXMLBuilder accessControlList = builder.elem("AccessControlList");
                for (GrantAndPermission gap : grants) {
                    GranteeInterface grantee = gap.getGrantee();
                    Permission permission = gap.getPermission();
                    OBSXMLBuilder subBuilder = null;
                    if (grantee instanceof CanonicalGrantee) {
                        subBuilder = OBSXMLBuilder.create("Grantee").element("ID").text(ServiceUtils.toValid(grantee.getIdentifier()));
                    } else if (grantee instanceof GroupGrantee) {
                        if (((GroupGrantee)grantee).getGroupGranteeType() != GroupGranteeEnum.ALL_USERS) continue;
                        subBuilder = OBSXMLBuilder.create("Grantee").element("Canned").text(this.transGroupGrantee(((GroupGrantee)grantee).getGroupGranteeType()));
                    } else if (grantee != null) {
                        subBuilder = OBSXMLBuilder.create("Grantee").element("ID").text(ServiceUtils.toValid(grantee.getIdentifier()));
                    }
                    if (subBuilder == null) continue;
                    OBSXMLBuilder grantBuilder = accessControlList.elem("Grant").importXMLBuilder(subBuilder);
                    if (permission != null) {
                        grantBuilder.elem("Permission").text(ServiceUtils.toValid(permission.getPermissionString()));
                    }
                    if (!isBucket) continue;
                    grantBuilder.e("Delivered").t(String.valueOf(gap.isDelivered()));
                }
            }
            return builder.asString();
        }
        catch (FactoryConfigurationError | ParserConfigurationException | TransformerException e) {
            throw new ServiceException("Failed to build XML document for ACL", e);
        }
    }

    @Override
    public String transBucketNotificationConfiguration(BucketNotificationConfiguration bucketNotificationConfiguration) throws ServiceException {
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("NotificationConfiguration");
            if (bucketNotificationConfiguration == null) {
                return builder.asString();
            }
            for (TopicConfiguration topicConfiguration : bucketNotificationConfiguration.getTopicConfigurations()) {
                this.packNotificationConfig(builder, topicConfiguration, "TopicConfiguration", "Topic", "Object");
            }
            for (FunctionGraphConfiguration functionGraphConfiguration : bucketNotificationConfiguration.getFunctionGraphConfigurations()) {
                this.packNotificationConfig(builder, functionGraphConfiguration, "FunctionGraphConfiguration", "FunctionGraph", "Object");
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for Notification", e);
        }
    }

    @Override
    public String transReplicationConfiguration(ReplicationConfiguration replicationConfiguration) throws ServiceException {
        try {
            OBSXMLBuilder builder = OBSXMLBuilder.create("ReplicationConfiguration").e("Agency").t(ServiceUtils.toValid(replicationConfiguration.getAgency())).up();
            for (ReplicationConfiguration.Rule rule : replicationConfiguration.getRules()) {
                builder = builder.e("Rule");
                if (rule.getId() != null) {
                    builder.e("ID").t(rule.getId());
                }
                builder.e("Prefix").t(ServiceUtils.toValid(rule.getPrefix()));
                if (rule.getStatus() != null) {
                    builder.e("Status").t(rule.getStatus().getCode());
                }
                if (rule.getHistoricalObjectReplication() != null) {
                    builder.e("HistoricalObjectReplication").t(rule.getHistoricalObjectReplication().getCode());
                }
                if (rule.getDestination() != null) {
                    String bucketName = ServiceUtils.toValid(rule.getDestination().getBucket());
                    builder = builder.e("Destination").e("Bucket").t(bucketName).up();
                    if (rule.getDestination().getObjectStorageClass() != null) {
                        builder.e("StorageClass").t(this.transStorageClass(rule.getDestination().getObjectStorageClass()));
                    }
                    if (rule.getDestination().getDeleteData() != null) {
                        builder.e("DeleteData").t(rule.getDestination().getDeleteData().getCode());
                    }
                    builder = builder.up();
                }
                builder = builder.up();
            }
            return builder.asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for Replication", e);
        }
    }

    @Override
    public String transEventType(EventTypeEnum eventType) {
        return ObsConvertor.transEventTypeStatic(eventType);
    }

    public static String transEventTypeStatic(EventTypeEnum eventType) {
        String eventTypeStr = "";
        if (eventType != null) {
            switch (eventType) {
                case OBJECT_CREATED_ALL: {
                    eventTypeStr = "ObjectCreated:*";
                    break;
                }
                case OBJECT_CREATED_PUT: {
                    eventTypeStr = "ObjectCreated:Put";
                    break;
                }
                case OBJECT_CREATED_POST: {
                    eventTypeStr = "ObjectCreated:Post";
                    break;
                }
                case OBJECT_CREATED_COPY: {
                    eventTypeStr = "ObjectCreated:Copy";
                    break;
                }
                case OBJECT_CREATED_COMPLETE_MULTIPART_UPLOAD: {
                    eventTypeStr = "ObjectCreated:CompleteMultipartUpload";
                    break;
                }
                case OBJECT_REMOVED_ALL: {
                    eventTypeStr = "ObjectRemoved:*";
                    break;
                }
                case OBJECT_REMOVED_DELETE: {
                    eventTypeStr = "ObjectRemoved:Delete";
                    break;
                }
                case OBJECT_REMOVED_DELETE_MARKER_CREATED: {
                    eventTypeStr = "ObjectRemoved:DeleteMarkerCreated";
                    break;
                }
            }
        }
        return eventTypeStr;
    }

    @Override
    public String transStorageClass(StorageClassEnum storageClass) {
        String storageClassStr = "";
        if (storageClass != null) {
            switch (storageClass) {
                case STANDARD: {
                    storageClassStr = "STANDARD";
                    break;
                }
                case WARM: {
                    storageClassStr = "WARM";
                    break;
                }
                case COLD: {
                    storageClassStr = "COLD";
                    break;
                }
                case DEEP_ARCHIVE: {
                    storageClassStr = "DEEP_ARCHIVE";
                    break;
                }
                case INTELLIGENT_TIERING: {
                    storageClassStr = "INTELLIGENT_TIERING";
                    break;
                }
            }
        }
        return storageClassStr;
    }

    @Override
    public AccessControlList transCannedAcl(String cannedAcl) {
        if ("private".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PRIVATE;
        }
        if ("public-read".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ;
        }
        if ("public-read-write".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ_WRITE;
        }
        if ("public-read-delivered".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ_DELIVERED;
        }
        if ("public-read-write-delivered".equals(cannedAcl)) {
            return AccessControlList.REST_CANNED_PUBLIC_READ_WRITE_DELIVERED;
        }
        return null;
    }

    @Override
    public String transGroupGrantee(GroupGranteeEnum groupGrantee) {
        String groupGranteeStr = "";
        if (groupGrantee == GroupGranteeEnum.ALL_USERS) {
            groupGranteeStr = "Everyone";
        }
        return groupGranteeStr;
    }
}

