/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.speech_to_text.v1;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.speech_to_text.v1.model.FileRecognizeSpeechReq;
import com.lark.oapi.service.speech_to_text.v1.model.FileRecognizeSpeechResp;
import com.lark.oapi.service.speech_to_text.v1.model.StreamRecognizeSpeechReq;
import com.lark.oapi.service.speech_to_text.v1.model.StreamRecognizeSpeechResp;

public class SpeechToTextService {
    private final Speech speech;

    public SpeechToTextService(Config config) {
        this.speech = new Speech(config);
    }

    public Speech speech() {
        return this.speech;
    }

    public static class Speech {
        private final Config config;

        public Speech(Config config) {
            this.config = config;
        }

        public FileRecognizeSpeechResp fileRecognize(FileRecognizeSpeechReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/speech_to_text/v1/speech/file_recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
            FileRecognizeSpeechResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, FileRecognizeSpeechResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public FileRecognizeSpeechResp fileRecognize(FileRecognizeSpeechReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/speech_to_text/v1/speech/file_recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
            FileRecognizeSpeechResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, FileRecognizeSpeechResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public StreamRecognizeSpeechResp streamRecognize(StreamRecognizeSpeechReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/speech_to_text/v1/speech/stream_recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
            StreamRecognizeSpeechResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, StreamRecognizeSpeechResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public StreamRecognizeSpeechResp streamRecognize(StreamRecognizeSpeechReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/speech_to_text/v1/speech/stream_recognize", Sets.newHashSet(AccessTokenType.Tenant), req);
            StreamRecognizeSpeechResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, StreamRecognizeSpeechResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

