/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.wiki.v2;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.wiki.v2.model.CopySpaceNodeReq;
import com.lark.oapi.service.wiki.v2.model.CopySpaceNodeResp;
import com.lark.oapi.service.wiki.v2.model.CreateSpaceMemberReq;
import com.lark.oapi.service.wiki.v2.model.CreateSpaceMemberResp;
import com.lark.oapi.service.wiki.v2.model.CreateSpaceNodeReq;
import com.lark.oapi.service.wiki.v2.model.CreateSpaceNodeResp;
import com.lark.oapi.service.wiki.v2.model.CreateSpaceReq;
import com.lark.oapi.service.wiki.v2.model.CreateSpaceResp;
import com.lark.oapi.service.wiki.v2.model.DeleteSpaceMemberReq;
import com.lark.oapi.service.wiki.v2.model.DeleteSpaceMemberResp;
import com.lark.oapi.service.wiki.v2.model.GetNodeSpaceReq;
import com.lark.oapi.service.wiki.v2.model.GetNodeSpaceResp;
import com.lark.oapi.service.wiki.v2.model.GetSpaceReq;
import com.lark.oapi.service.wiki.v2.model.GetSpaceResp;
import com.lark.oapi.service.wiki.v2.model.GetTaskReq;
import com.lark.oapi.service.wiki.v2.model.GetTaskResp;
import com.lark.oapi.service.wiki.v2.model.ListSpaceNodeReq;
import com.lark.oapi.service.wiki.v2.model.ListSpaceNodeResp;
import com.lark.oapi.service.wiki.v2.model.ListSpaceReq;
import com.lark.oapi.service.wiki.v2.model.ListSpaceResp;
import com.lark.oapi.service.wiki.v2.model.MoveDocsToWikiSpaceNodeReq;
import com.lark.oapi.service.wiki.v2.model.MoveDocsToWikiSpaceNodeResp;
import com.lark.oapi.service.wiki.v2.model.MoveSpaceNodeReq;
import com.lark.oapi.service.wiki.v2.model.MoveSpaceNodeResp;
import com.lark.oapi.service.wiki.v2.model.UpdateSpaceSettingReq;
import com.lark.oapi.service.wiki.v2.model.UpdateSpaceSettingResp;
import com.lark.oapi.service.wiki.v2.model.UpdateTitleSpaceNodeReq;
import com.lark.oapi.service.wiki.v2.model.UpdateTitleSpaceNodeResp;

public class WikiService {
    private final Space space;
    private final SpaceMember spaceMember;
    private final SpaceNode spaceNode;
    private final SpaceSetting spaceSetting;
    private final Task task;

    public WikiService(Config config) {
        this.space = new Space(config);
        this.spaceMember = new SpaceMember(config);
        this.spaceNode = new SpaceNode(config);
        this.spaceSetting = new SpaceSetting(config);
        this.task = new Task(config);
    }

    public Space space() {
        return this.space;
    }

    public SpaceMember spaceMember() {
        return this.spaceMember;
    }

    public SpaceNode spaceNode() {
        return this.spaceNode;
    }

    public SpaceSetting spaceSetting() {
        return this.spaceSetting;
    }

    public Task task() {
        return this.task;
    }

    public static class Task {
        private final Config config;

        public Task(Config config) {
            this.config = config;
        }

        public GetTaskResp get(GetTaskReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetTaskResp get(GetTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/tasks/:task_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetTaskResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class SpaceSetting {
        private final Config config;

        public SpaceSetting(Config config) {
            this.config = config;
        }

        public UpdateSpaceSettingResp update(UpdateSpaceSettingReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/wiki/v2/spaces/:space_id/setting", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UpdateSpaceSettingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateSpaceSettingResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateSpaceSettingResp update(UpdateSpaceSettingReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "PUT", "/open-apis/wiki/v2/spaces/:space_id/setting", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            UpdateSpaceSettingResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateSpaceSettingResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class SpaceNode {
        private final Config config;

        public SpaceNode(Config config) {
            this.config = config;
        }

        public CopySpaceNodeResp copy(CopySpaceNodeReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/:node_token/copy", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CopySpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CopySpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CopySpaceNodeResp copy(CopySpaceNodeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/:node_token/copy", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            CopySpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CopySpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateSpaceNodeResp create(CreateSpaceNodeReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateSpaceNodeResp create(CreateSpaceNodeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListSpaceNodeResp list(ListSpaceNodeReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces/:space_id/nodes", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListSpaceNodeResp list(ListSpaceNodeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces/:space_id/nodes", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MoveSpaceNodeResp move(MoveSpaceNodeReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/:node_token/move", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            MoveSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MoveSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MoveSpaceNodeResp move(MoveSpaceNodeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/:node_token/move", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            MoveSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MoveSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MoveDocsToWikiSpaceNodeResp moveDocsToWiki(MoveDocsToWikiSpaceNodeReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/move_docs_to_wiki", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            MoveDocsToWikiSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MoveDocsToWikiSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public MoveDocsToWikiSpaceNodeResp moveDocsToWiki(MoveDocsToWikiSpaceNodeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/move_docs_to_wiki", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            MoveDocsToWikiSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, MoveDocsToWikiSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateTitleSpaceNodeResp updateTitle(UpdateTitleSpaceNodeReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/:node_token/update_title", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateTitleSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTitleSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UpdateTitleSpaceNodeResp updateTitle(UpdateTitleSpaceNodeReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/nodes/:node_token/update_title", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            UpdateTitleSpaceNodeResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UpdateTitleSpaceNodeResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class SpaceMember {
        private final Config config;

        public SpaceMember(Config config) {
            this.config = config;
        }

        public CreateSpaceMemberResp create(CreateSpaceMemberReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/members", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateSpaceMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateSpaceMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateSpaceMemberResp create(CreateSpaceMemberReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces/:space_id/members", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            CreateSpaceMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateSpaceMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteSpaceMemberResp delete(DeleteSpaceMemberReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/wiki/v2/spaces/:space_id/members/:member_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteSpaceMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteSpaceMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteSpaceMemberResp delete(DeleteSpaceMemberReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/wiki/v2/spaces/:space_id/members/:member_id", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            DeleteSpaceMemberResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteSpaceMemberResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Space {
        private final Config config;

        public Space(Config config) {
            this.config = config;
        }

        public CreateSpaceResp create(CreateSpaceReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces", Sets.newHashSet(AccessTokenType.User), req);
            CreateSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateSpaceResp create(CreateSpaceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/wiki/v2/spaces", Sets.newHashSet(AccessTokenType.User), req);
            CreateSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetSpaceResp get(GetSpaceReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces/:space_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetSpaceResp get(GetSpaceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces/:space_id", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            GetSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetNodeSpaceResp getNode(GetNodeSpaceReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces/get_node", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetNodeSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetNodeSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetNodeSpaceResp getNode(GetNodeSpaceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces/get_node", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            GetNodeSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetNodeSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListSpaceResp list(ListSpaceReq req, RequestOptions reqOptions) throws Exception {
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListSpaceResp list(ListSpaceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/wiki/v2/spaces", Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant), req);
            ListSpaceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListSpaceResp.class);
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

