/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import com.oceanbase.jdbc.extend.datatype.ComplexData;
import com.oceanbase.jdbc.extend.datatype.ComplexDataType;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ComplexUtil {
    public static void storeDateTime(PacketOutputStream pos, Date dt, int bufferType, Options options) throws SQLException, IOException {
        ComplexUtil.storeDateTime413AndNewer(pos, dt, bufferType, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeDateTime413AndNewer(PacketOutputStream pos, Date dt, int bufferType, Options options) throws IOException {
        GregorianCalendar sessionCalendar = null;
        sessionCalendar = !options.useLegacyDatetimeCode ? (bufferType == ColumnType.DATE.getType() ? new GregorianCalendar(TimeZone.getDefault()) : new GregorianCalendar(pos.getTimeZone())) : new GregorianCalendar();
        Date oldTime = sessionCalendar.getTime();
        try {
            sessionCalendar.setTime(dt);
            if (dt instanceof java.sql.Date) {
                sessionCalendar.set(11, 0);
                sessionCalendar.set(12, 0);
                sessionCalendar.set(13, 0);
            }
            byte length = 7;
            if (dt instanceof Timestamp) {
                length = 11;
            }
            pos.writeBytes(length, 1);
            int year = sessionCalendar.get(1);
            int month = sessionCalendar.get(2) + 1;
            int date = sessionCalendar.get(5);
            pos.writeIntV1(year);
            pos.writeBytes((byte)month, 1);
            pos.writeBytes((byte)date, 1);
            if (dt instanceof java.sql.Date) {
                pos.writeBytes((byte)0, 1);
                pos.writeBytes((byte)0, 1);
                pos.writeBytes((byte)0, 1);
            } else {
                pos.writeBytes((byte)sessionCalendar.get(11), 1);
                pos.writeBytes((byte)sessionCalendar.get(12), 1);
                pos.writeBytes((byte)sessionCalendar.get(13), 1);
            }
            if (length == 11) {
                pos.writeLongV1(((Timestamp)dt).getNanos() / 1000);
            }
        }
        finally {
            sessionCalendar.setTime(oldTime);
        }
    }

    public static ColumnType getMysqlType(int complexType) throws SQLException {
        switch (complexType) {
            case 2: {
                return ColumnType.DATETIME;
            }
            case 3: 
            case 4: {
                return ColumnType.COMPLEX;
            }
            case 0: {
                return ColumnType.DECIMAL;
            }
            case 1: {
                return ColumnType.VARCHAR;
            }
            case 6: {
                return ColumnType.RAW;
            }
        }
        throw new SQLException("unsupported complex type");
    }

    public static void storeComplexStruct(PacketOutputStream pos, ComplexData data, Options options) throws Exception {
        int nullCount = (data.getAttrCount() + 7) / 8;
        int nullBitsPosition = pos.getPosition();
        for (int i = 0; i < nullCount; ++i) {
            pos.writeBytes((byte)0, 1);
        }
        byte[] nullBitsBuffer = new byte[nullCount];
        for (int i = 0; i < data.getAttrCount(); ++i) {
            if (null != data.getAttrData(i)) {
                ComplexUtil.storeComplexAttrData(pos, data.getComplexType().getAttrType(i), data.getAttrData(i), options);
                continue;
            }
            int n = i / 8;
            nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i % 8);
        }
        int endPosition = pos.getPosition();
        pos.setPosition(nullBitsPosition);
        pos.write(nullBitsBuffer);
        pos.setPosition(endPosition);
    }

    public static void storeComplexArray(PacketOutputStream pos, ComplexData data, Options options) throws Exception {
        pos.writeFieldLength(data.getAttrCount());
        int nullCount = (data.getAttrCount() + 7) / 8;
        int nullBitsPosition = pos.getPosition();
        for (int i = 0; i < nullCount; ++i) {
            pos.writeBytes((byte)0, 1);
        }
        byte[] nullBitsBuffer = new byte[nullCount];
        for (int i = 0; i < data.getAttrCount(); ++i) {
            if (null != data.getAttrData(i)) {
                ComplexUtil.storeComplexAttrData(pos, data.getComplexType().getAttrType(0), data.getAttrData(i), options);
                continue;
            }
            int n = i / 8;
            nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i % 8);
        }
        int endPosition = pos.getPosition();
        pos.setPosition(nullBitsPosition);
        pos.write(nullBitsBuffer);
        pos.setPosition(endPosition);
    }

    public static void storeComplexAttrData(PacketOutputStream pos, ComplexDataType type, Object value, Options options) throws Exception {
        switch (type.getType()) {
            case 4: {
                ComplexUtil.storeComplexArray(pos, (ComplexData)value, options);
                return;
            }
            case 3: {
                ComplexUtil.storeComplexStruct(pos, (ComplexData)value, options);
                return;
            }
            case 0: {
                String valueStr = String.valueOf((Integer)value);
                pos.writeFieldLength(valueStr.getBytes().length);
                pos.write(valueStr.getBytes(StandardCharsets.UTF_8));
                return;
            }
            case 2: {
                ComplexUtil.storeDateTime(pos, (Date)value, ColumnType.DATETIME.getType(), options);
                return;
            }
            case 1: 
            case 6: 
            case 7: {
                if (value instanceof byte[]) {
                    byte[] tmp = (byte[])value;
                    pos.writeFieldLength(tmp.length);
                    pos.write(tmp);
                } else {
                    String strValue = null;
                    if (value instanceof String) {
                        strValue = (String)value;
                    } else if (value instanceof BigDecimal) {
                        strValue = ((BigDecimal)value).toString();
                    } else if (value instanceof java.sql.Date) {
                        strValue = ((java.sql.Date)value).toString();
                    } else if (value instanceof Timestamp) {
                        strValue = ((Timestamp)value).toString();
                    } else {
                        try {
                            strValue = String.valueOf(value);
                        }
                        catch (Exception e) {
                            throw new SQLException("unsupported complex data set for String, type:" + value.getClass() + " and content: " + value);
                        }
                    }
                    byte[] tmp = strValue.getBytes();
                    pos.writeFieldLength(tmp.length);
                    pos.write(tmp);
                }
                return;
            }
        }
        throw new SQLException("unsupported complex data type");
    }
}

