/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.com.send.parameters;

import com.oceanbase.jdbc.Clob;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.send.parameters.LongDataParameterHolder;
import com.oceanbase.jdbc.internal.io.output.PacketOutputStream;
import com.oceanbase.jdbc.util.Options;
import java.io.IOException;
import java.io.Reader;

public class OBReaderParameter
implements Cloneable,
LongDataParameterHolder {
    private Reader reader;
    private final Clob clob;
    private final long length;
    private final boolean noBackslashEscapes;
    private final boolean hasLobLocator;
    private final byte[] bytes;

    public OBReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.hasLobLocator = false;
        this.clob = null;
        this.length = length;
        this.bytes = null;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public OBReaderParameter(Clob clob, long length, boolean noBackslashEscapes) {
        this.reader = null;
        this.hasLobLocator = false;
        this.clob = clob;
        this.length = length;
        this.bytes = null;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public OBReaderParameter(boolean hasLobLocator, byte[] bytes, long length, boolean noBackslashEscapes) {
        this.reader = null;
        this.hasLobLocator = hasLobLocator;
        this.clob = null;
        this.length = length;
        this.bytes = bytes;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public OBReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    private void setReader() {
        if (this.clob != null) {
            this.reader = this.clob.getCharacterStream();
        }
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        this.setReader();
        if (!this.hasLobLocator && this.reader != null) {
            pos.write(39);
            if (this.length == Long.MAX_VALUE) {
                pos.writeEscapeQuote(this.reader, this.noBackslashEscapes);
            } else {
                pos.writeEscapeQuote(this.reader, this.length, this.noBackslashEscapes);
            }
            pos.write(39);
        }
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return -1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        this.setReader();
        if (this.hasLobLocator && this.bytes != null) {
            pos.writeFieldLength(this.bytes.length);
            pos.write(this.bytes, 0, this.bytes.length);
        } else if (this.reader != null && this.length == Long.MAX_VALUE) {
            pos.write(this.reader, false, this.noBackslashEscapes);
        } else {
            pos.write(this.reader, this.length, false, this.noBackslashEscapes);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return this.hasLobLocator ? ColumnType.ORA_CLOB : ColumnType.BLOB;
    }

    @Override
    public String toString() {
        return "<Reader>";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return !this.hasLobLocator;
    }

    @Override
    public boolean writePieceData(PacketOutputStream writer, boolean first, Options options) throws IOException {
        int piece;
        if (first) {
            this.setReader();
        }
        int pieceLen = options.pieceLength;
        char[] buffer = new char[pieceLen];
        int len = this.reader.read(buffer);
        boolean ret = false;
        if (len < 0) {
            writer.write(3);
            writer.write(0);
            writer.writeLong(0L);
            writer.flush();
            return false;
        }
        byte[] data = new String(buffer, 0, len).getBytes(options.characterEncoding);
        if (first && this.reader.ready()) {
            piece = 1;
            ret = true;
        } else if (first && !this.reader.ready()) {
            piece = 3;
            ret = false;
        } else if (!first && this.reader.ready()) {
            piece = 2;
            ret = true;
        } else {
            piece = 3;
            ret = false;
        }
        writer.write(piece);
        writer.write(0);
        writer.writeLong(data.length);
        writer.write(data);
        writer.flush();
        return ret;
    }

    @Override
    public boolean writeLongData(PacketOutputStream pos, Options options, int statementId, short paramIndex) throws IOException {
        return false;
    }
}

