/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.failover.utils;

import com.oceanbase.jdbc.HostAddress;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.failover.BlackList.BlackListConfig;
import com.oceanbase.jdbc.internal.failover.BlackList.append.RetryDuration;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceAddressList;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceHostAddress;
import com.oceanbase.jdbc.internal.failover.impl.LoadBalanceInfo;
import com.oceanbase.jdbc.internal.failover.utils.CONFIGTYPE;
import com.oceanbase.jdbc.internal.failover.utils.STATE;
import com.oceanbase.jdbc.internal.failover.utils.ZONE;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.util.HttpClient;
import com.oceanbase.jdbc.internal.util.JsonParser;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.constant.HaMode;
import com.oceanbase.jdbc.util.Options;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class ConfigParser {
    private static final Logger logger = LoggerFactory.getLogger(ConfigParser.class);
    private static final ReentrantLock lock = new ReentrantLock();
    static ConcurrentHashMap<String, LoadBalanceInfo> loadBalanceInfos = new ConcurrentHashMap();
    static ConcurrentHashMap<String, Long> ocpAccessTimes = new ConcurrentHashMap();

    public static void readLoadBalanceInfosFromTns(Reader reader) throws IOException {
        LoadBalanceInfo loadBalanceInfo = null;
        BlackListConfig blackListConfig = null;
        LoadBalanceAddressList loadBalanceAddressList = null;
        HostAddress loadBalanceHostAddress = null;
        StringBuilder word = new StringBuilder();
        char[] buffer = new char[1024];
        int readNum = 0;
        STATE state = STATE.NONE;
        int bracketsCount = 0;
        CONFIGTYPE curConfigType = CONFIGTYPE.NONE;
        String str = null;
        ZONE curZone = ZONE.NONE;
        String currentNetServiceName = "";
        while ((readNum = reader.read(buffer)) != -1) {
            block29: for (int i = 0; i < readNum; ++i) {
                char cur = buffer[i];
                switch (cur) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block29;
                    }
                    case '(': {
                        state = STATE.LEAFBRACKETS;
                        ++bracketsCount;
                        continue block29;
                    }
                    case ')': {
                        if (--bracketsCount == 0) {
                            loadBalanceInfos.put(currentNetServiceName, loadBalanceInfo);
                            state = STATE.NONE;
                            curConfigType = CONFIGTYPE.NONE;
                            word = new StringBuilder();
                        }
                        if (bracketsCount > 0 && curConfigType != CONFIGTYPE.NONE) {
                            String value = word.toString();
                            switch (curConfigType) {
                                case SERVICE_NAME: {
                                    loadBalanceInfo.setServiceName(value);
                                    break;
                                }
                                case RETRYALLDOWNS: {
                                    loadBalanceInfo.setRetryAllDowns(Integer.parseInt(value));
                                    break;
                                }
                                case GROUPSTRATEGY: {
                                    loadBalanceInfo.getGroupBalanceStrategyConfigs().put("NAME", value.toUpperCase());
                                    break;
                                }
                                case LOADBALANCESTRATEGY: 
                                case LOADBALANCESTRATEGYALIAS: {
                                    if (curZone == ZONE.INDESCRIPTION) {
                                        loadBalanceInfo.getBalanceStrategyConfigs().put("NAME", value.toUpperCase());
                                        break;
                                    }
                                    loadBalanceInfo.getGroups().get(loadBalanceInfo.getGroups().size() - 1).getBalanceStrategyConfigs().put("NAME", value.toUpperCase());
                                    break;
                                }
                                case LOADBALANCEALIAS: 
                                case LOADBALANCE: {
                                    if (value.equalsIgnoreCase("ON")) {
                                        loadBalanceInfo.setHaMode(HaMode.LOADBALANCE);
                                        break;
                                    }
                                    loadBalanceInfo.setHaMode(HaMode.NONE);
                                    break;
                                }
                                case NAME: {
                                    if (curZone == ZONE.INREMOVESTRATGY) {
                                        blackListConfig.getRemoveStrategyConfigs().put("NAME", "TIMEOUT");
                                        break;
                                    }
                                    blackListConfig.getAppendStrategyConfigs().put("NAME", value.toUpperCase());
                                    break;
                                }
                                case TIMEOUT: {
                                    blackListConfig.getRemoveStrategyConfigs().put("TIMEOUT", value.toUpperCase());
                                    break;
                                }
                                case RETRYTIMES: {
                                    blackListConfig.getAppendStrategyConfigs().put("RETRYTIMES", value.toUpperCase());
                                    break;
                                }
                                case DURATION: {
                                    blackListConfig.getAppendStrategyConfigs().put("DURATION", value.toUpperCase());
                                    RetryDuration.updateMaxDuration(Long.parseLong(value));
                                    break;
                                }
                                case PORT: {
                                    loadBalanceHostAddress.setPort(Integer.parseInt(value));
                                    break;
                                }
                                case HOST: {
                                    loadBalanceHostAddress.setHost(value);
                                    break;
                                }
                                case WEIGHT: {
                                    ((LoadBalanceHostAddress)loadBalanceHostAddress).setWeight(Integer.parseInt(value));
                                    break;
                                }
                            }
                            state = STATE.NONE;
                            curConfigType = CONFIGTYPE.NONE;
                            word = new StringBuilder();
                            continue block29;
                        }
                        if (state != STATE.INBRACKETS) continue block29;
                        str = word.toString();
                        if (bracketsCount == 0) {
                            state = STATE.NONE;
                            continue block29;
                        }
                        state = STATE.RIGHTBRACKETS;
                        word = new StringBuilder();
                        continue block29;
                    }
                    case '=': {
                        str = word.toString();
                        boolean inKeys = false;
                        CONFIGTYPE[] configEnums = CONFIGTYPE.values();
                        CONFIGTYPE tmp = CONFIGTYPE.NONE;
                        for (CONFIGTYPE v : configEnums) {
                            if (!str.equalsIgnoreCase(v.name)) continue;
                            tmp = v;
                            inKeys = true;
                        }
                        if (!inKeys) {
                            currentNetServiceName = str;
                        }
                        if (tmp != CONFIGTYPE.NONE) {
                            curConfigType = tmp;
                        }
                        switch (curConfigType) {
                            case DESCRIPTION: {
                                curZone = ZONE.INDESCRIPTION;
                                loadBalanceInfo = new LoadBalanceInfo();
                                break;
                            }
                            case BLACKLISTSTRATECONFIG: {
                                curZone = ZONE.INBLACKLIST;
                                blackListConfig = new BlackListConfig();
                                loadBalanceInfo.setBlackListConfig(blackListConfig);
                                break;
                            }
                            case REMOVESTRATEGY: {
                                curZone = ZONE.INREMOVESTRATGY;
                                break;
                            }
                            case APPENDSTRATEGY: {
                                curZone = ZONE.INAPPENDSTRATGY;
                                break;
                            }
                            case ADDRESSLIST: {
                                curZone = ZONE.INADDRESSLIST;
                                loadBalanceAddressList = new LoadBalanceAddressList();
                                loadBalanceInfo.getGroups().add(loadBalanceAddressList);
                                break;
                            }
                            case ADDRESS: {
                                curZone = ZONE.INADDRESS;
                                loadBalanceHostAddress = new LoadBalanceHostAddress(null, 0);
                                loadBalanceAddressList.getAddressList().add((LoadBalanceHostAddress)loadBalanceHostAddress);
                            }
                        }
                        word = new StringBuilder();
                        continue block29;
                    }
                    default: {
                        if (state == STATE.LEAFBRACKETS) {
                            state = STATE.INBRACKETS;
                        }
                        word.append(cur);
                    }
                }
            }
        }
    }

    public static void readLoadBalanceInfosFromJsonFile() throws IOException, SQLException {
        String inputLine;
        logger.debug("Read json file on disk...");
        ConfigInfo jsonFileInfo = ConfigParser.getJsonFilePath();
        String filePath = jsonFileInfo.path + "/" + jsonFileInfo.name;
        File file = new File(filePath);
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        StringBuffer content = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            content.append(inputLine);
        }
        String jsonBalanceInfos = content.toString();
        if (!jsonBalanceInfos.equals("")) {
            JsonParser parsing = new JsonParser(jsonBalanceInfos);
            parsing.parse();
            ArrayList listServices = (ArrayList)((HashMap)parsing.getStack().peek()).get("NET_SERVICES");
            for (HashMap mapService : listServices) {
                String netServiceName = (String)mapService.get("NET_SERVICE_NAME");
                HashMap mapDescription = (HashMap)mapService.get("DESCRIPTION");
                LoadBalanceInfo balanceInfo = new LoadBalanceInfo(mapDescription);
                loadBalanceInfos.put(netServiceName, balanceInfo);
            }
        }
    }

    public static void writeLoadBalanceInfosIntoJsonFile() throws IOException, SQLException {
        logger.debug("Write json file on disk...");
        StringBuilder json = new StringBuilder("{\"NET_SERVICES\": [");
        boolean atLeastOneNet = false;
        for (Map.Entry<String, LoadBalanceInfo> entry : loadBalanceInfos.entrySet()) {
            String netServiceName = entry.getKey();
            LoadBalanceInfo balanceInfo = entry.getValue();
            if (atLeastOneNet) {
                json.append(",");
            } else {
                atLeastOneNet = true;
            }
            json.append("{");
            json.append("\"NET_SERVICE_NAME\":\"" + netServiceName + "\"");
            json.append(",\"DESCRIPTION\":{" + balanceInfo.toJson() + "}");
            json.append("}");
        }
        json.append("]}");
        ConfigInfo jsonFileInfo = ConfigParser.getJsonFilePath();
        String filePath = jsonFileInfo.path + "/" + jsonFileInfo.name;
        File file = new File(filePath);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        out.write(json.toString());
        out.close();
    }

    public static LoadBalanceInfo getLoadBalanceInfoFromTns(UrlParser urlParser) throws SQLException, IOException {
        if (Utils.tnsDaemon == null) {
            ConfigInfo tnsFileInfo = ConfigParser.getTnsFilePath();
            String filePath = tnsFileInfo.path + "/" + tnsFileInfo.name;
            File file = new File(filePath);
            InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
            ConfigParser.readLoadBalanceInfosFromTns(reader);
            return loadBalanceInfos.get(urlParser.getTnsServiceName());
        }
        if (Utils.tnsDaemon.getState() == Thread.State.TERMINATED) {
            throw new SQLException("Config file daemon thread  is TERMINATED");
        }
        LoadBalanceInfo tnsPropertis = loadBalanceInfos.get(urlParser.getTnsServiceName());
        if (tnsPropertis == null) {
            throw new SQLException("Unknown host specified ");
        }
        return tnsPropertis;
    }

    public static LoadBalanceInfo getLoadBalanceInfoFromExtendDescription(UrlParser urlParser) throws SQLException, IOException {
        try {
            ConfigParser.readLoadBalanceInfosFromTns(new StringReader(urlParser.getExtendDescription()));
        }
        catch (Exception e) {
            SQLException sqlException = new SQLException("LoadBalance config error", e);
            throw sqlException;
        }
        String netServiceName = ConfigParser.getNetServiceName(urlParser.getExtendDescription());
        return loadBalanceInfos.get(netServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadBalanceInfo getLoadBalanceInfoFromOcpApi(OcpApi ocpApi, Options options) throws IOException, SQLException {
        String jsonBalanceInfo = null;
        boolean ocpAavailable = true;
        String ocpUrl = null;
        try {
            ocpAccessTimes.putIfAbsent(ocpApi.appName, 0L);
            if (System.currentTimeMillis() - ocpAccessTimes.get(ocpApi.appName) < (long)(options.ocpAccessInterval * 60 * 1000)) {
                return ConfigParser.getGlobalLoadBalanceInfo(ocpApi.appName);
            }
            ocpUrl = "http://" + ocpApi.ip + ":" + ocpApi.port + "/api/v2/obproxy/loadBalanceInfo?appName=" + ocpApi.appName;
            Iterator iter = ((ConcurrentHashMap.KeySetView)ocpAccessTimes.keySet()).iterator();
            String targetApp = null;
            while (iter.hasNext() && (targetApp = (String)iter.next()).equals(ocpApi.appName)) {
            }
            logger.debug("Key : (hashCode={}, toString={}) --> Value : (hashCode={}, toString={})", targetApp.hashCode(), targetApp, ocpAccessTimes.get(targetApp).hashCode(), ocpAccessTimes.get(targetApp));
            String string = targetApp;
            synchronized (string) {
                logger.debug("synchronized begin {}", (Object)ocpApi.appName);
                if (System.currentTimeMillis() - ocpAccessTimes.get(ocpApi.appName) < (long)(options.ocpAccessInterval * 60 * 1000)) {
                    logger.debug("synchronized return {}", (Object)ocpApi.appName);
                    return ConfigParser.getGlobalLoadBalanceInfo(ocpApi.appName);
                }
                logger.debug("Accessing OCP API... " + ocpUrl);
                jsonBalanceInfo = HttpClient.doGet(ocpUrl, options);
                ocpAccessTimes.put(ocpApi.appName, System.currentTimeMillis());
                if (jsonBalanceInfo != null) {
                    logger.debug("Load balance info from OCP : " + jsonBalanceInfo);
                    JsonParser parsing = new JsonParser(jsonBalanceInfo);
                    parsing.parse();
                    HashMap mapService = (HashMap)((HashMap)parsing.getStack().peek()).get("data");
                    String netServiceName = (String)mapService.get("NET_SERVICE_NAME");
                    HashMap mapDescription = (HashMap)mapService.get("DESCRIPTION");
                    LoadBalanceInfo balanceInfo = new LoadBalanceInfo(mapDescription);
                    lock.lock();
                    try {
                        ConfigParser.readLoadBalanceInfosFromJsonFile();
                    }
                    catch (Exception e) {
                        logger.warn("Failed to read json file on disk");
                    }
                    logger.debug("loadBalanceInfos.put({}, balanceInfo)", (Object)ocpApi.appName);
                    loadBalanceInfos.put(netServiceName, balanceInfo);
                    ConfigParser.writeLoadBalanceInfosIntoJsonFile();
                    lock.unlock();
                }
                logger.debug("synchronized end {}", (Object)ocpApi.appName);
            }
        }
        catch (Exception e) {
            logger.warn("OCP API isn't available, " + ocpUrl);
            ocpAavailable = false;
        }
        if (!ocpAavailable) {
            ConfigParser.readLoadBalanceInfosFromJsonFile();
        }
        return ConfigParser.getGlobalLoadBalanceInfo(ocpApi.appName);
    }

    public static LoadBalanceInfo getLoadBalanceInfoByDefault(UrlParser urlParser) {
        LoadBalanceInfo ret = new LoadBalanceInfo();
        String strategy = urlParser.getOptions().loadBalanceStrategy.toUpperCase();
        ret.getBalanceStrategyConfigs().put("NAME", strategy);
        String serverAffinityOrder = urlParser.getOptions().serverAffinityOrder;
        if (serverAffinityOrder == null || serverAffinityOrder.equals("")) {
            List<HostAddress> addressList = urlParser.getHostAddresses();
            LoadBalanceAddressList loadBalanceAddressList = new LoadBalanceAddressList();
            for (HostAddress address : addressList) {
                LoadBalanceHostAddress loadBalanceHostAddress = new LoadBalanceHostAddress(address.host, address.port);
                loadBalanceAddressList.addressList.add(loadBalanceHostAddress);
            }
            ret.getGroups().add(loadBalanceAddressList);
        } else {
            serverAffinityOrder = serverAffinityOrder.trim();
            String[] urls = serverAffinityOrder.split(",");
            LoadBalanceAddressList loadBalanceAddressList = new LoadBalanceAddressList();
            loadBalanceAddressList.getBalanceStrategyConfigs().put("NAME", strategy);
            for (String str : urls) {
                LoadBalanceHostAddress loadBalanceHostAddress = new LoadBalanceHostAddress("0.0.0.0", 0);
                String[] vals = str.split(":");
                loadBalanceHostAddress.setHost(vals[0]);
                loadBalanceHostAddress.setPort(Integer.parseInt(vals[1]));
                if (vals.length == 3) {
                    loadBalanceHostAddress.setWeight(Integer.parseInt(vals[2]));
                } else {
                    loadBalanceHostAddress.setWeight(1);
                }
                loadBalanceAddressList.addressList.add(loadBalanceHostAddress);
            }
            ret.getGroups().add(loadBalanceAddressList);
        }
        return ret;
    }

    public static LoadBalanceInfo getGlobalLoadBalanceInfo(String netServiceName) {
        return loadBalanceInfos.get(netServiceName);
    }

    public static String getNetServiceName(String extendDescription) throws SQLException {
        int endIndex;
        int startIndex;
        String tmp = extendDescription.trim();
        String value = tmp.substring((startIndex = tmp.indexOf("(")) + 1, endIndex = tmp.indexOf("="));
        if (value.trim().equalsIgnoreCase("DESCRIPTION")) {
            throw new SQLException("Url config format error !");
        }
        return value.trim();
    }

    public static ConfigInfo getTnsFilePath() throws SQLException {
        ConfigInfo configInfo = new ConfigInfo();
        String tnsPath = System.getProperty("oceanbase.tns_admin");
        String tnsEnv = System.getenv("OCEANBASE_TNS_ADMIN");
        if (tnsEnv == null && tnsPath == null) {
            throw new SQLException("Unknown TNS_ADMIN specified ");
        }
        if (tnsPath == null) {
            tnsPath = tnsEnv;
        }
        String configFileName = "tnsnames.ob";
        String tnsConfigName = System.getProperty("oceanbase.tns_admin_name");
        String tnsConfigNameEnv = System.getenv("OCEANBASE_TNS_ADMIN_NAME");
        if (tnsConfigName != null) {
            configFileName = tnsConfigName;
        }
        if (tnsConfigNameEnv != null) {
            configFileName = tnsConfigNameEnv;
        }
        configInfo.path = tnsPath;
        configInfo.name = configFileName;
        return configInfo;
    }

    public static ConfigInfo getJsonFilePath() throws SQLException {
        ConfigInfo configInfo = new ConfigInfo();
        String tnsPath = System.getProperty("oceanbase.tns_admin");
        String tnsEnv = System.getenv("OCEANBASE_TNS_ADMIN");
        if (tnsEnv == null && tnsPath == null) {
            throw new SQLException("Unknown TNS_ADMIN specified ");
        }
        if (tnsPath == null) {
            tnsPath = tnsEnv;
        }
        String configFileName = "jsonnames.ob";
        String jsonConfigName = System.getProperty("oceanbase.json_admin_name");
        String jsonConfigNameEnv = System.getenv("OCEANBASE_JSON_ADMIN_NAME");
        if (jsonConfigName != null) {
            configFileName = jsonConfigName;
        }
        if (jsonConfigNameEnv != null) {
            configFileName = jsonConfigNameEnv;
        }
        configInfo.path = tnsPath;
        configInfo.name = configFileName;
        return configInfo;
    }

    public static class ConfigInfo {
        public String name;
        public String path;
    }

    public static class OcpApi {
        public String ip;
        public String port;
        public String appName;
    }
}

