/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol.flt;

import com.oceanbase.jdbc.internal.com.read.Buffer;
import com.oceanbase.jdbc.internal.protocol.flt.OceanBaseSerialize;
import java.io.IOException;

public class ObObj {
    public ObObjMeta meta = new ObObjMeta();
    public int valueLen = 0;
    public ObObjValue value = new ObObjValue();

    public long getSerializeSize() {
        long len = 0L;
        len += this.meta.getSerializeSize();
        if (this.meta.getType() != ObObjType.ObVarcharType) {
            throw new UnsupportedOperationException("unsupported obj type");
        }
        return len += this.getSerializeSizeOfObVarcharType();
    }

    public void serialize(Buffer extraInfo) throws IOException {
        this.meta.serialize(extraInfo);
        if (this.meta.isValid()) {
            if (this.meta.getType() != ObObjType.ObVarcharType) {
                throw new UnsupportedOperationException("unsupported obj type");
            }
        } else {
            throw new IOException("invalid ob object type");
        }
        this.serializeOfObVarcharType(extraInfo);
    }

    public void deserialize(Buffer extraInfo) throws IOException {
        this.meta.deserialize(extraInfo);
        if (this.meta.isValid()) {
            if (this.meta.getType() != ObObjType.ObVarcharType) {
                throw new UnsupportedOperationException("unsupported obj type");
            }
        } else {
            throw new IOException("invalid ob object type");
        }
        this.deserializeOfObVarcharType(extraInfo);
    }

    private long getSerializeSizeOfObVarcharType() {
        return OceanBaseSerialize.encoded_length_vstr_with_len(this.valueLen);
    }

    private void serializeOfObVarcharType(Buffer buf) throws IOException {
        OceanBaseSerialize.encode_vstr_with_len(buf, this.value.vStr, this.valueLen);
    }

    private void deserializeOfObVarcharType(Buffer buf) throws IOException {
        long MINIMAL_NEEDED_SIZE = 2L;
        if ((long)buf.remaining() >= 2L) {
            this.value.vStr = OceanBaseSerialize.decode_vstr_nocopy(buf);
            if (null == this.value.vStr) {
                throw new IOException("OB DESERIALIZE ERROR");
            }
        } else {
            throw new IOException("OB DESERIALIZE ERROR");
        }
        this.valueLen = this.value.vStr.length;
    }

    public void setVarchar(byte[] str, int size) {
        this.meta.setVarcharMeta();
        this.meta.setCollationLevel(ObCollationLevel.CS_LEVEL_IMPLICIT);
        this.valueLen = size;
        this.value.vStr = str;
    }

    public static class ObObjMeta {
        public ObObjType type = ObObjType.ObNullType;
        public ObCollationLevel csLevel = ObCollationLevel.CS_LEVEL_INVALID;
        public ObCollationType csType = ObCollationType.CS_TYPE_INVALID;
        public byte scale = (byte)-1;

        private long getSerializeSize() {
            return 4L;
        }

        private void serialize(Buffer buf) throws IOException {
            OceanBaseSerialize.encode_int8_t(buf, (byte)this.type.ordinal());
            OceanBaseSerialize.encode_int8_t(buf, (byte)this.csLevel.ordinal());
            OceanBaseSerialize.encode_int8_t(buf, (byte)this.csType.getValue());
            OceanBaseSerialize.encode_int8_t(buf, this.scale);
        }

        private void deserialize(Buffer buf) throws IOException {
            this.type = ObObjType.valueOf(OceanBaseSerialize.decode_int8_t(buf));
            this.csLevel = ObCollationLevel.valueOf(OceanBaseSerialize.decode_int8_t(buf));
            this.csType = ObCollationType.valueOf(OceanBaseSerialize.decode_int8_t(buf));
            this.scale = OceanBaseSerialize.decode_int8_t(buf);
        }

        private void setVarcharMeta() {
            this.type = ObObjType.ObVarcharType;
        }

        private void setCollationLevel(ObCollationLevel level) {
            this.csLevel = level;
        }

        private void setCollationType(ObCollationType type) {
            this.csType = type;
        }

        private void setScale(byte scale) {
            this.scale = scale;
        }

        private ObObjType getType() {
            return this.type;
        }

        private boolean isValid() {
            return this.isValidObjType(this.type);
        }

        private boolean isValidObjType(ObObjType type) {
            return type.compareTo(ObObjType.ObNullType) >= 0 && type.compareTo(ObObjType.ObMaxType) <= 0;
        }
    }

    public static class ObObjValue {
        public byte[] vStr;
    }

    private static enum ObObjType {
        ObNullType,
        ObTinyIntType,
        ObSmallIntType,
        ObMediumIntType,
        ObInt32Type,
        ObIntType,
        ObUTinyIntType,
        ObUSmallIntType,
        ObUMediumIntType,
        ObUInt32Type,
        ObUInt64Type,
        ObFloatType,
        ObDoubleType,
        ObUFloatType,
        ObUDoubleType,
        ObNumberType,
        ObUNumberType,
        ObDateTimeType,
        ObTimestampType,
        ObDateType,
        ObTimeType,
        ObYearType,
        ObVarcharType,
        ObCharType,
        ObHexStringType,
        ObExtendType,
        ObUnknownType,
        ObTinyTextType,
        ObTextType,
        ObMediumTextType,
        ObLongTextType,
        ObBitType,
        ObEnumType,
        ObSetType,
        ObEnumInnerType,
        ObSetInnerType,
        ObTimestampTZType,
        ObTimestampLTZType,
        ObTimestampNanoType,
        ObRawType,
        ObIntervalYMType,
        ObIntervalDSType,
        ObNumberFloatType,
        ObNVarchar2Type,
        ObNCharType,
        ObURowIDType,
        ObLobType,
        ObMaxType;


        public static ObObjType valueOf(byte value) {
            switch (value) {
                case 0: {
                    return ObNullType;
                }
                case 22: {
                    return ObVarcharType;
                }
            }
            return null;
        }
    }

    private static enum ObCollationLevel {
        CS_LEVEL_EXPLICIT,
        CS_LEVEL_NONE,
        CS_LEVEL_IMPLICIT,
        CS_LEVEL_SYSCONST,
        CS_LEVEL_COERCIBLE,
        CS_LEVEL_NUMERIC,
        CS_LEVEL_IGNORABLE,
        CS_LEVEL_INVALID;


        public static ObCollationLevel valueOf(byte value) {
            switch (value) {
                case 2: {
                    return CS_LEVEL_IMPLICIT;
                }
                case 7: {
                    return CS_LEVEL_INVALID;
                }
            }
            return null;
        }
    }

    private static enum ObCollationType {
        CS_TYPE_INVALID(0),
        CS_TYPE_GBK_CHINESE_CI(28),
        CS_TYPE_UTF8MB4_GENERAL_CI(45),
        CS_TYPE_UTF8MB4_BIN(46),
        CS_TYPE_UTF16_GENERAL_CI(54),
        CS_TYPE_UTF16_BIN(55),
        CS_TYPE_BINARY(63),
        CS_TYPE_GBK_BIN(87),
        CS_TYPE_UTF16_UNICODE_CI(101),
        CS_TYPE_UTF8MB4_UNICODE_CI(224),
        CS_TYPE_GB18030_CHINESE_CI(248),
        CS_TYPE_GB18030_BIN(249),
        CS_TYPE_MAX(250);

        private final int value;

        private ObCollationType(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static ObCollationType valueOf(int v) {
            switch (v) {
                case 0: {
                    return CS_TYPE_INVALID;
                }
                case 28: {
                    return CS_TYPE_GBK_CHINESE_CI;
                }
                case 45: {
                    return CS_TYPE_UTF8MB4_GENERAL_CI;
                }
                case 46: {
                    return CS_TYPE_UTF8MB4_BIN;
                }
                case 54: {
                    return CS_TYPE_UTF16_GENERAL_CI;
                }
                case 55: {
                    return CS_TYPE_UTF16_BIN;
                }
                case 63: {
                    return CS_TYPE_BINARY;
                }
                case 87: {
                    return CS_TYPE_GBK_BIN;
                }
                case 101: {
                    return CS_TYPE_UTF16_UNICODE_CI;
                }
                case 224: {
                    return CS_TYPE_UTF8MB4_UNICODE_CI;
                }
                case 248: {
                    return CS_TYPE_GB18030_CHINESE_CI;
                }
                case 249: {
                    return CS_TYPE_GB18030_BIN;
                }
                case 250: {
                    return CS_TYPE_MAX;
                }
            }
            return null;
        }
    }
}

