/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class CHAR
extends Datum {
    static final long serialVersionUID = 5559010489982176244L;
    public static final CharacterSet DEFAULT_CHARSET = CharacterSet.make(-1);
    private CharacterSet charSet;
    private int oracleId;
    private boolean variableLength;
    private static final byte[] empty = new byte[0];

    protected CHAR() {
    }

    public CHAR(byte[] bytes, CharacterSet charSet) {
        this.setValue(bytes, charSet);
    }

    public CHAR(byte[] bytes, int offset, int count, CharacterSet charSet) throws SQLException {
        if (bytes == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        byte[] data = new byte[count];
        System.arraycopy(bytes, offset, data, 0, count);
        this.setValue(data, charSet);
    }

    public CHAR(String str, CharacterSet charSet, int len) throws SQLException {
        this(str, charSet);
        byte[] tmpData = this.shareBytes();
        if (tmpData.length < len) {
            byte[] tmp = new byte[len];
            System.arraycopy(tmpData, 0, tmp, 0, tmpData.length);
            for (int i = tmpData.length; i < len; ++i) {
                tmp[i] = 32;
            }
            this.setShareBytes(tmp);
        }
    }

    public CHAR(String str, CharacterSet charSet) throws SQLException {
        if (str == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        if (charSet == null) {
            charSet = DEFAULT_CHARSET;
        }
        this.setValue(charSet.convertWithReplacement(str), charSet);
    }

    public CHAR(Object obj, CharacterSet charSet) throws SQLException {
        this(obj == null ? (String)null : obj.toString(), charSet);
    }

    public CharacterSet getCharacterSet() {
        if (this.charSet == null) {
            if (this.oracleId == 0) {
                this.oracleId = -1;
            }
            this.charSet = DEFAULT_CHARSET != null && (this.oracleId == -1 || this.oracleId == DEFAULT_CHARSET.getOracleId()) ? DEFAULT_CHARSET : CharacterSet.make(this.oracleId);
        }
        return this.charSet;
    }

    public int oracleId() {
        return this.oracleId;
    }

    public String getString() throws SQLException {
        return this.getCharacterSet().toString(this.shareBytes(), 0, (int)this.getLength());
    }

    public String getStringWithReplacement() {
        byte[] bytes = this.shareBytes();
        return this.getCharacterSet().toStringWithReplacement(bytes, 0, bytes.length);
    }

    public String toString() {
        return this.getStringWithReplacement();
    }

    @Override
    public boolean equals(Object other) {
        boolean result;
        boolean bl = result = this == other;
        if (!result && other instanceof CHAR) {
            CHAR o = (CHAR)other;
            result = this.bytesEqual(o) && this.getCharacterSet().equals(o.getCharacterSet());
        }
        return result;
    }

    void setValue(byte[] bytes, CharacterSet charSet) {
        this.charSet = charSet == null ? DEFAULT_CHARSET : charSet;
        this.oracleId = this.charSet.getOracleId();
        this.setShareBytes(bytes == null ? empty : bytes);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.stringValue();
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.lang.String") == 0 || class_name.compareTo("java.lang.Long") == 0 || class_name.compareTo("java.math.BigDecimal") == 0 || class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.sql.Date") == 0 || class_name.compareTo("java.sql.Time") == 0 || class_name.compareTo("java.sql.Timestamp") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    @Override
    public String stringValue() {
        return this.toString();
    }

    @Override
    public boolean booleanValue() throws SQLException {
        String s = this.stringValue();
        if (s == null || s.trim().equals("0") || s.trim().compareToIgnoreCase("f") == 0 || s.trim().compareToIgnoreCase("false") == 0 || s.trim().compareToIgnoreCase("n") == 0 || s.trim().compareToIgnoreCase("no") == 0) {
            return false;
        }
        if (s.trim().equals("1") || s.trim().compareToIgnoreCase("t") == 0 || s.trim().compareToIgnoreCase("true") == 0 || s.trim().compareToIgnoreCase("y") == 0 || s.trim().compareToIgnoreCase("yes") == 0) {
            return true;
        }
        throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
    }

    @Override
    public int intValue() throws SQLException {
        long result = this.longValue();
        if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
            throw (SQLException)DatabaseError.createSqlException(26).fillInStackTrace();
        }
        return (int)result;
    }

    @Override
    public long longValue() throws SQLException {
        long ret_val = 0L;
        try {
            ret_val = Long.valueOf(this.stringValue().trim());
        }
        catch (NumberFormatException e) {
            throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
        }
        return ret_val;
    }

    @Override
    public float floatValue() throws SQLException {
        float ret_val = 0.0f;
        try {
            ret_val = Float.valueOf(this.stringValue().trim()).floatValue();
        }
        catch (NumberFormatException e) {
            throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
        }
        return ret_val;
    }

    @Override
    public double doubleValue() throws SQLException {
        double ret_val = 0.0;
        try {
            ret_val = Double.valueOf(this.stringValue().trim());
        }
        catch (NumberFormatException e) {
            throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
        }
        return ret_val;
    }

    @Override
    public byte byteValue() throws SQLException {
        long result = this.longValue();
        if (result > 127L || result < -128L) {
            throw (SQLException)DatabaseError.createSqlException(26).fillInStackTrace();
        }
        return (byte)result;
    }

    @Override
    public Date dateValue() throws SQLException {
        return Date.valueOf(this.stringValue().trim());
    }

    @Override
    public Time timeValue() throws SQLException {
        return Time.valueOf(this.stringValue().trim());
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return Timestamp.valueOf(this.stringValue().trim());
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        BigDecimal big_dec_val = null;
        try {
            big_dec_val = new BigDecimal(this.stringValue().trim());
        }
        catch (NumberFormatException e) {
            throw (SQLException)DatabaseError.createSqlException(12, "bigDecimalValue").fillInStackTrace();
        }
        return big_dec_val;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return new StringReader(this.getString());
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.getStream();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new String[arraySize];
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    public void setVariableLength(boolean variableLength) {
        this.variableLength = variableLength;
    }

    public boolean isVariableLength() {
        return this.variableLength;
    }
}

