/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;

class OracleReturnResultSet
extends ForwardOnlyResultSet {
    OracleReturnResultSet(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        super(conn, stmt);
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();){
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        super.doClose();
        this.statement.currentResultSet = null;
        this.statement.returnParamsFetched = false;
        this.statement.rowsDmlReturned = 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
            }
            if (this.statement.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            AutoKeyInfo info = this.statement.getAutoKeyInfo();
            if (info == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            info.statement = this.statement;
            info.connection = this.connection;
            info.initMetaData(this);
            AutoKeyInfo autoKeyInfo = info;
            return autoKeyInfo;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        Monitor.CloseableLock lock = this.statement.connection.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (lock != null) {
                if (throwable != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    lock.close();
                }
            }
            throw throwable3;
        }
    }
}

