/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PKCS12KeyBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private PrivateKey key;
    private ASN1Sequence contents;

    public PKCS12KeyBag() {
    }

    public PKCS12KeyBag(PKCS12Safe parent) {
        this.parent = parent;
    }

    public PKCS12KeyBag(PKCS12Safe parent, PrivateKey key) {
        this(parent);
        this.key = key;
    }

    public PKCS12KeyBag(PKCS12Safe parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12KeyBag(PKCS12Safe parent, ASN1Sequence s) throws IOException {
        this(parent);
        this.input(s);
    }

    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s) throws IOException {
        this.reset();
        ASN1GenericConstructed bc = (ASN1GenericConstructed)s.elementAt(1);
        ASN1Sequence pki = (ASN1Sequence)bc.elementAt(0);
        this.key = CryptoUtils.inputPrivateKey((InputStream)Utils.toStream((Streamable)pki));
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 1));
            s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.key, 0));
            ASN1Set attr = this.outputAttrsASN1();
            if (attr != null) {
                s.addElement((ASN1Object)attr);
            }
            this.contents = s;
        }
        return this.contents;
    }

    public int length() {
        return this.outputASN1().length();
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public ASN1Sequence getPrivateKeyInfo() {
        try {
            return new ASN1Sequence((InputStream)new UnsyncByteArrayInputStream(this.key.getEncoded()));
        }
        catch (IOException ex) {
            throw new StreamableInputException(ex.toString());
        }
    }

    public void setPrivateKey(PrivateKey key) {
        this.key = key;
        this.reset();
    }

    public String toString() {
        String s = "";
        if (this.friendlyName != null) {
            s = s + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            s = s + "localKeyID = " + Utils.toHexString((byte[])this.localKeyID) + ", ";
        }
        return s + this.key.toString();
    }
}

