/*
 * Decompiled with CFR 0.152.
 */
package com.pongsky.kit.springfox.config;

import java.text.MessageFormat;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={RouteLocator.class})
@ConditionalOnProperty(value={"doc.gateway-route-enabled"}, havingValue="true")
public class SwaggerRouteLocator {
    @Value(value="${server.port}")
    private Integer port;

    @Bean
    public RouteLocator routes(RouteLocatorBuilder builder) {
        return builder.routes().route("swagger", r -> r.path(new String[]{"/v3/api-docs/**"}).filters(f -> f.rewritePath("/v3/api-docs/(?<path>.*)", "/$\\{path}/v3/api-docs")).uri(MessageFormat.format("http://localhost:{0}", this.port.toString()))).build();
    }
}

