/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.model.ReplicationRule;
import com.qcloud.cos.utils.Jackson;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BucketReplicationConfiguration
implements Serializable {
    private String roleName;
    private Map<String, ReplicationRule> rules = new HashMap<String, ReplicationRule>();

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public BucketReplicationConfiguration withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    public Map<String, ReplicationRule> getRules() {
        return this.rules;
    }

    public ReplicationRule getRule(String id) {
        return this.rules.get(id);
    }

    public void setRules(Map<String, ReplicationRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("Replication rules cannot be null");
        }
        this.rules = new HashMap<String, ReplicationRule>(rules);
    }

    public BucketReplicationConfiguration withRules(Map<String, ReplicationRule> rules) {
        this.setRules(rules);
        return this;
    }

    public BucketReplicationConfiguration addRule(String id, ReplicationRule rule) {
        if (id == null || id.trim().isEmpty()) {
            throw new IllegalArgumentException("Rule id cannot be null or empty.");
        }
        if (rule == null) {
            throw new IllegalArgumentException("Replication rule cannot be null");
        }
        this.rules.put(id, rule);
        return this;
    }

    public BucketReplicationConfiguration removeRule(String id) {
        this.rules.remove(id);
        return this;
    }

    public String toString() {
        return Jackson.toJsonString(this);
    }
}

