/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.BasXMLWriter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DefaultStructure;
import com.sap.conn.jco.rt.StructureParameter;
import com.sap.conn.rfc.api.BasXMLAware;
import java.io.IOException;

public class FlatStructure
extends StructureParameter
implements BasXMLAware {
    DefaultStructure structure;
    Converter converter;

    protected FlatStructure(JCoStructure structure, String name) {
        this((DefaultStructure)structure, name, 0, new byte[1]);
    }

    protected FlatStructure(DefaultStructure structure, String name) {
        this(structure, name, 0, new byte[1]);
    }

    public FlatStructure(DefaultStructure structure, String name, int index, byte[] flags) {
        this(structure, name, null, index, flags);
    }

    protected FlatStructure(DefaultStructure structure, String name, Converter converter, int index, byte[] flags) {
        super(name, index, flags);
        this.structure = structure;
        this.converter = converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public int getType() {
        return 17;
    }

    public byte[] getBytes() {
        int padOffset;
        int i;
        DefaultRecordMetaData metaData = (DefaultRecordMetaData)this.structure.metaData;
        byte[] ret = new byte[metaData.tabLength[this.converter.sendCodepageType]];
        block10: for (i = 0; i < metaData.numFields; ++i) {
            switch (metaData.type[i]) {
                case 0: 
                case 1: 
                case 3: 
                case 6: {
                    this.converter.decodeChar(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.decodeNumber(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 2: 
                case 4: {
                    this.converter.decodeBinary(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
                case 23: 
                case 24: {
                    this.converter.decodeDecNumber(this.structure, ret, i, metaData.offset[this.converter.sendCodepageType][i], metaData.length[this.converter.sendCodepageType][i]);
                    continue block10;
                }
            }
        }
        if ((padOffset = metaData.offset[this.converter.sendCodepageType][--i] + metaData.length[this.converter.sendCodepageType][i]) < ret.length) {
            switch (metaData.type[i]) {
                case 0: {
                    this.converter.padSpaces(ret, padOffset);
                    break;
                }
                case 6: {
                    this.converter.padZeros(ret, padOffset);
                    break;
                }
            }
        }
        return ret;
    }

    public void setBytes(byte[] rfcBytes) {
        int offset;
        this.structure.ensureBufferCapacity();
        DefaultRecordMetaData metaData = (DefaultRecordMetaData)this.structure.metaData;
        int numFields = metaData.computeFieldNumber(rfcBytes.length, this.converter.receiveCodepageType);
        int i = 0;
        while (i < numFields) {
            switch (metaData.type[i]) {
                case 0: 
                case 1: 
                case 3: {
                    this.converter.encodeChar(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 6: {
                    this.converter.encodeNumchar(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.converter.encodeNumber(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 2: 
                case 4: {
                    this.converter.encodeBinary(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 23: 
                case 24: {
                    this.converter.encodeDecNumber(this.structure, rfcBytes, i, metaData.offset[this.converter.receiveCodepageType][i], metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
            }
            int n = i++;
            this.structure.flags[n] = (byte)(this.structure.flags[n] & 0xFFFFFFFE);
        }
        if (i < metaData.numFields && (offset = metaData.offset[this.converter.receiveCodepageType][i]) < rfcBytes.length) {
            switch (metaData.type[i]) {
                case 0: {
                    this.converter.encodeChar(this.structure, rfcBytes, i, offset, metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 6: {
                    this.converter.encodeNumchar(this.structure, rfcBytes, i, offset, metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
                case 4: {
                    this.converter.encodeBinary(this.structure, rfcBytes, i, offset, metaData.length[this.converter.receiveCodepageType][i]);
                    break;
                }
            }
            int n = i;
            this.structure.flags[n] = (byte)(this.structure.flags[n] & 0xFFFFFFFE);
        }
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
    }

    public int getNumBytes() {
        return ((DefaultRecordMetaData)this.structure.metaData).tabLength[this.converter.sendCodepageType];
    }

    public DefaultStructure getStructure() {
        return this.structure;
    }

    void setStructure(DefaultStructure structure) {
        this.structure = structure;
    }

    public AbstractRecord getParameterRecord() {
        int n = this.index;
        this.flags[n] = (byte)(this.flags[n] & 0xFFFFFFFE);
        return this.structure;
    }

    public void writebASXML(BasXMLWriter writer) throws IOException {
        writer.encode(this.structure, this.name);
    }
}

