/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.activity.component;

import com.simple.mybatis.JpaCriteria;
import com.wego168.activity.domain.Activity;
import com.wego168.activity.domain.ActivitySignFile;
import com.wego168.activity.service.ActivityService;
import com.wego168.activity.service.ActivitySignFileService;
import com.wego168.activity.service.ActivitySignService;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.SignData;
import com.wego168.base.domain.SignDataSetting;
import com.wego168.base.enums.SignDataSettingTypeEnum;
import com.wego168.base.enums.SignStatusEnum;
import com.wego168.base.persistence.SignDataMapper;
import com.wego168.base.persistence.SignDataSettingMapper;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.SignDataService;
import com.wego168.base.service.SignDataSettingService;
import com.wego168.domain.BaseDomain;
import com.wego168.exception.HttpException;
import com.wego168.exception.RestStatusException;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.BaseDomainUtil;
import com.wego168.util.Checker;
import com.wego168.util.Https509TrustManager;
import com.wego168.util.SequenceUtil;
import com.wego168.util.ZipUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ActivitySignFileComponent {
    private static final Logger log = LoggerFactory.getLogger(ActivitySignFileComponent.class);
    @Autowired
    private ActivityService activityService;
    @Autowired
    private SignDataService signDataService;
    @Autowired
    private SignDataMapper signDataMapper;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private ActivitySignFileService activitySignFileService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Value(value="${cos.path}")
    private String cosHost;
    @Autowired
    private SignDataSettingMapper signDataSettingMapper;
    @Autowired
    private SignDataSettingService signDataSettingService;
    @Autowired
    private ActivitySignService activitySignService;
    private static final String basePath = "D:" + File.separator + "activity";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void zip2(String activityId) {
        Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
        this.simpleRedisTemplate.setString("zip_" + activityId, "start");
        long random = new Date().getTime();
        try {
            String base = basePath + File.separator + activityId + File.separator;
            File baseFile = new File(base);
            baseFile.mkdir();
            String appId = activity.getAppId();
            List signDataSettings = this.signDataSettingMapper.selectList(JpaCriteria.builder().eq("appId", (Object)appId).eq("sourceId", (Object)activityId).eq("type", (Object)SignDataSettingTypeEnum.FILE.getIndex()));
            List<String> dataIds = this.activitySignService.selectDataIdBySourceId(appId, activityId);
            for (SignDataSetting signDataSetting : signDataSettings) {
                File file = new File(baseFile.getAbsolutePath() + File.separator + signDataSetting.getName().replace("/", ""));
                if (!file.exists()) {
                    file.mkdir();
                }
                String settingId = signDataSetting.getId();
                List signDatas = this.signDataMapper.selectList(JpaCriteria.builder().eq("settingId", (Object)settingId));
                for (SignData signData : signDatas) {
                    String dataId = signData.getDataId();
                    if (!dataIds.contains(dataId)) continue;
                    String downloadUrl = this.cosHost + signData.getValue();
                    List threeSignDataSetting = this.signDataSettingService.selectByActivityId(activityId, Integer.valueOf(3));
                    ArrayList<String> signDataSettingIds = new ArrayList<String>();
                    if (Checker.listNotEmpty((List)threeSignDataSetting)) {
                        for (SignDataSetting signDataSetting2 : threeSignDataSetting) {
                            signDataSettingIds.add(signDataSetting2.getId());
                        }
                    }
                    List signData1 = this.signDataService.selectBySignDataSettingId(signDataSettingIds, SignStatusEnum.SIGN.getIndex().intValue(), dataId);
                    String fileName = ActivitySignFileComponent.getFileName(threeSignDataSetting, signData1);
                    fileName = fileName + downloadUrl.substring(downloadUrl.lastIndexOf("."), downloadUrl.length());
                    fileName = ActivitySignFileComponent.filterIllegalName(fileName);
                    FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)new File(file.getAbsolutePath() + File.separator + fileName));
                }
            }
            File zipFile = new File(basePath + File.separator + activityId + random + ".zip");
            ZipUtil.doCompress((File)baseFile, (File)zipFile);
            FileServer server = (FileServer)this.fileServerService.selectById((Object)"1");
            Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u5b58\u50a8\u670d\u52a1\u5668\u672a\u914d\u7f6e");
            log.error("\u6253\u5305\u5b8c\u6210\uff0c\u6b63\u5728\u4e0a\u4f20\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)zipFile.length());
            String cosPath = FileUploadUtil.uploadPart((File)zipFile, (String)"attachments/activitySignFile", (String)(activity.getTitle() + "_" + new Date().getTime() + ".zip"), (FileServer)server);
            ActivitySignFile activitySignFile = new ActivitySignFile();
            BaseDomainUtil.initBaseDomain((BaseDomain)activitySignFile, (String)activity.getAppId());
            activitySignFile.setActivityId(activityId);
            activitySignFile.setCosPath(cosPath);
            activitySignFile.setLocalPath(zipFile.getAbsolutePath());
            activitySignFile.setRemoveCosPath(false);
            activitySignFile.setRemoveLocalPath(false);
            this.activitySignFileService.insert((Object)activitySignFile);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4e0b\u8f7d\u9644\u4ef6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                this.simpleRedisTemplate.setString("zip_" + activityId, "end");
                System.gc();
                FileUtils.deleteQuietly((File)new File(basePath + File.separator + activityId));
                FileUtils.deleteQuietly((File)new File(basePath + File.separator + activityId + random + ".zip"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String filterIllegalName(String name) {
        Pattern p = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
        Matcher m = p.matcher(name);
        return m.replaceAll(" ");
    }

    private static String getFileName(List<SignDataSetting> threeSignDataSetting, List<SignData> signDatas) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (SignData signData : signDatas) {
            valueMap.put(signData.getSettingId(), signData.getValue());
        }
        StringBuilder sb = new StringBuilder();
        for (SignDataSetting setting : threeSignDataSetting) {
            sb.append((String)valueMap.get(setting.getId()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void zip(String activityId) {
        this.simpleRedisTemplate.setString("zip_" + activityId, "start");
        try {
            Activity activity = (Activity)((Object)this.activityService.selectById(activityId));
            String title = activity.getTitle();
            String appId = activity.getAppId();
            Map urlList = this.signDataService.batchDownloadSignFile(activityId, appId);
            FileServer server = (FileServer)this.fileServerService.selectById((Object)"1");
            Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u5b58\u50a8\u670d\u52a1\u5668\u672a\u914d\u7f6e");
            String random = SequenceUtil.createUuid();
            String path = basePath + File.separator + activityId + File.separator + random + File.separator;
            String zipPath = this.zipPath(urlList, activityId, path);
            File file = new File(zipPath);
            FileUtils.deleteDirectory((File)new File(path + "signFile" + File.separator));
            log.error("\u6253\u5305\u5b8c\u6210\uff0c\u6b63\u5728\u4e0a\u4f20\uff0c\u6587\u4ef6\u5927\u5c0f\uff1a{}", (Object)file.length());
            String cosPath = FileUploadUtil.uploadPart((File)file, (String)"attachments/activitySignFile", (String)(title + "_" + new Date().getTime() + ".zip"), (FileServer)server);
            ActivitySignFile activitySignFile = new ActivitySignFile();
            BaseDomainUtil.initBaseDomain((BaseDomain)activitySignFile, (String)appId);
            activitySignFile.setActivityId(activityId);
            activitySignFile.setCosPath(cosPath);
            activitySignFile.setLocalPath(path);
            activitySignFile.setRemoveCosPath(false);
            activitySignFile.setRemoveLocalPath(false);
            this.activitySignFileService.insert((Object)activitySignFile);
            log.error(basePath + File.separator + activityId + File.separator + random);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u4e0b\u8f7d\u9644\u4ef6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        finally {
            try {
                this.simpleRedisTemplate.setString("zip_" + activityId, "end");
                System.gc();
                FileUtils.deleteDirectory((File)new File(basePath + File.separator + activityId));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String zipPath(Map<String, String> urlList, String activityId, String path) {
        File signFile = new File(path + "signFile" + File.separator);
        signFile.mkdirs();
        File zipFile = new File(path + "zipFile" + File.separator + activityId + ".zip");
        zipFile.getParentFile().mkdirs();
        for (Map.Entry<String, String> url : urlList.entrySet()) {
            int index = url.getValue().lastIndexOf(".");
            if (index == -1) {
                log.error("\u62a5\u540d\u9644\u4ef6\u4e0d\u662f\u6587\u4ef6->{}", (Object)url.getValue());
                continue;
            }
            String suffix = url.getValue().substring(index, url.getValue().length());
            File temp = new File(signFile + File.separator + url.getKey() + suffix);
            String urlFile = this.cosHost + url.getValue();
            try {
                this.httpDownloadFile(urlFile, "GET", temp.getAbsolutePath());
            }
            catch (Exception e) {
                log.error("\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6->{}\u81f3{}\u4f4d\u7f6e\uff0c\u53d1\u751f\u9519\u8bef\uff0c\u8df3\u8fc7\u4e0b\u8f7d{}", new Object[]{urlFile, temp.getAbsolutePath(), e});
                throw new RestStatusException("\u53d1\u751f\u9519\u8bef");
            }
        }
        ZipUtil.doCompress((File)signFile, (File)zipFile);
        return zipFile.getAbsolutePath();
    }

    private void download(String urlPath, String path) throws MalformedURLException {
        int bytesum = 0;
        int byteread = 0;
        URL url = new URL(urlPath);
        try {
            URLConnection conn = url.openConnection();
            InputStream inStream = conn.getInputStream();
            FileOutputStream fs = new FileOutputStream(path);
            byte[] buffer = new byte[1204];
            while ((byteread = inStream.read(buffer)) != -1) {
                System.out.println(bytesum += byteread);
                fs.write(buffer, 0, byteread);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void httpDownloadFile(String requestUrl, String requestMethod, String targetPath) {
        InputStream inputStream = null;
        HttpURLConnection httpUrlConn = null;
        try {
            int index;
            TrustManager[] tm = new TrustManager[]{new Https509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("TLSv1", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            httpUrlConn = (HttpsURLConnection)url.openConnection();
            ((HttpsURLConnection)httpUrlConn).setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            inputStream = httpUrlConn.getInputStream();
            byte[] bytes = new byte[1024];
            FileOutputStream downloadFile = new FileOutputStream(targetPath);
            while ((index = inputStream.read(bytes)) != -1) {
                downloadFile.write(bytes, 0, index);
                downloadFile.flush();
            }
            downloadFile.close();
            inputStream.close();
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u51fa\u9519->{}, {}", (Object)requestUrl, (Object)e);
            throw HttpException.connectError();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e2) {
                    throw HttpException.disconnectError();
                }
            }
            if (httpUrlConn != null) {
                try {
                    httpUrlConn.disconnect();
                }
                catch (Exception e2) {
                    throw HttpException.disconnectError();
                }
            }
        }
    }
}

